from django.utils import timezone
from .models import HomepageBlock, RSSArticle

import logging, feedparser
logging.basicConfig()

from datetime import datetime
import time

def import_rss():

    import sys

    reload(sys)

    sys.setdefaultencoding('utf-8')

    blocks = HomepageBlock.objects.filter(block_type='rss')
    feeds = []

    print blocks

    for block in blocks:
        print 'Checking block %s' % block
        block_feeds = block.rss_feeds.split('\n')

        for bf in block_feeds:
            if block.needs_resetting:
                articles = RSSArticle.objects.filter(source=bf)
                if articles:
                    articles.delete()

            if not bf in feeds:
                feeds.append(bf)

    for feed in feeds:
        print "Fetching feed %s" % feed
        f = feedparser.parse(feed)

        for item in f.entries:
            article, created = RSSArticle.objects.get_or_create(link=item.link, source=feed)

            if created:
                print "Adding article %s" % item.title
                try:
                    article.added = time.strftime("%Y-%m-%d %H:%M:%S", item.updated_parsed)
                except:
                    article.added = timezone.now()
                article.title = item.title
                article.summary = item.summary
                article.link = item.link
                article.save()
            else:
                print "Skipped article %s" % item.title

    for block in blocks:
        block.needs_resetting = False
        block.save()
