from django.core.management.base import BaseCommand, CommandError
from django.conf import settings

from django.shortcuts import render
from django.http import HttpResponse
from django.template.loader import render_to_string

import datetime
import csv
import os

from modules.certificates.models import Certificate
from modules.notifications.models import *
from modules.core.functions import is_valid_email
import pdfcrowd

class Command(BaseCommand):

    def handle(self, *args, **options):

        client = pdfcrowd.Client("calmdigital", "dc33e7c4525620565185d0a00d90b8f0")
        client.setPageMargins('50','30','50','30')

        csv_file = open("%s/attendees.csv" % (settings.BASE_DIR), "rU")
        reader = csv.reader(csv_file)

        row_count = 1
        for row in reader:
            if row[0] != 'Title':

                if is_valid_email(row[3]):

                    day_1 = False
                    if row[4] == '1':
                        day_1 = True
                    
                    day_2 = False
                    if row[5] == '1':
                        day_2 = True

                    certificate = Certificate(
                        first_name = row[1],
                        last_name = row[2],
                        email=row[3],
                        day_1=day_1,
                        day_2=day_2
                    )
                    certificate.save()

                    if certificate.day_1 and certificate.day_2:
                        attended ='Thursday 21st and Friday 22nd November 2019'
                        cpd = '10'
                    elif certificate.day_1:
                        attended ='Thursday 21st November 2019'
                        cpd = '5'
                    elif certificate.day_2:
                        attended ='Friday 22nd November 2019'
                        cpd = '5'
                    else:
                        attended = '-'
                        cpd = '-'

                    file_name = 'certificates/certificate_%s.pdf' % (certificate.id)
                    output_file = open(os.path.join(settings.PRIVATE_FILES, file_name), 'wb')
                    html = render_to_string('certificate.html', {'certificate': certificate, 'attended':attended, 'cpd':cpd})
                    client.convertHtml(html, output_file)

                    certificate.certificate = file_name
                    certificate.save()

                    print "Row %s - certificate added." % (row_count)

                else:
                    print "Row %s - could not find email" % (row_count)

            row_count += 1

