from django.core.management.base import BaseCommand, CommandError
from django.conf import settings

from django.shortcuts import render
from django.http import HttpResponse
from django.template.loader import render_to_string

import datetime
import csv
import os

from modules.certificates.models import Certificate
from modules.notifications.models import *
from modules.core.functions import is_valid_email
import pdfcrowd

class Command(BaseCommand):

    def handle(self, *args, **options):

        certificates = Certificate.objects.filter(sent=False)
        template = EmailTemplate.objects.get(key='certificate_generated')

        for certificate in certificates:

            print "Sending Certificate %s" % (certificate.id)

            message = template.content % (certificate.first_name)
            send_mail(template.key,template.subject,message,template.from_address.email_address,certificate.email,attachments=[certificate.certificate])

            certificate.sent = True
            certificate.save