#Django core bits
from django.shortcuts import render_to_response, get_object_or_404
from django.template import RequestContext, loader, Context
from django.contrib.auth.decorators import login_required, permission_required
from django.db.models import Q
from django.contrib.sites.models import Site
from django.conf import settings
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.contrib.auth.models import User, Group

import csv

#Forms

#Models
from models import Submission

from modules.core.decorators import *

@permission_required('admin_users.can_access_contact')
def submissions(request):

    submissions = Submission.objects.all().order_by('-date_sent')

    return render_to_response('admin/contact/contact.html',{'submissions':submissions}, context_instance=RequestContext(request))

@permission_required('admin_users.can_access_contact')
def download_submissions(request):
    
    submissions = Submission.objects.all().order_by('-date_sent')
    
    # Create the HttpResponse object with the appropriate CSV header.
    response = HttpResponse(content_type='text/csv')
    response['Content-Disposition'] = "attachment; filename=contact-submissions.csv"

    writer = csv.writer(response)
    
    writer.writerow(['Namne','Email Address','Telephone','Message','Mailing List','Created'])

    for submission in submissions:
        
        if submission.mailing_list:
            mailing_list = 'Yes'
        else:
            mailing_list = 'No'

        writer.writerow([unicode(s).encode("utf-8") for s in (submission.name,submission.email,submission.telephone,submission.message,mailing_list,submission.date_sent)])

    return response


@permission_required('admin_users.can_access_contact')
def view_submission(request,submissionid):

    submission = get_object_or_404(Submission,id=submissionid)
	
    return render_to_response('admin/contact/submission.html',{'submission':submission}, context_instance=RequestContext(request))

@permission_required('admin_users.can_access_contact')
def delete_submission(request,submissionid):

    submission = get_object_or_404(Submission,id=submissionid)

    submission.delete()

    return HttpResponseRedirect(reverse('admin_contact'))
