#Django core bits
from django.shortcuts import render, get_object_or_404
from django.template import RequestContext, loader, Context
from django.contrib.auth.decorators import login_required, permission_required
from django.conf import settings
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.contrib.auth.models import User, Group

import csv

#Forms

#Models
from models import ContactStudySubmission

from modules.core.decorators import *

@permission_required('admin_users.can_access_contact_study')
def submissions(request):

    submissions = ContactStudySubmission.objects.all().order_by('-created')
    return render(request, 'admin/contact-study/submissions.html',{'submissions': submissions})


@permission_required('admin_users.can_access_contact_study')
def download_submissions(request):
    
    submissions = ContactStudySubmission.objects.all().order_by('-created')
    
    # Create the HttpResponse object with the appropriate CSV header.
    response = HttpResponse(content_type='text/csv')
    response['Content-Disposition'] = "attachment; filename=contact-submissions.csv"

    writer = csv.writer(response)
    writer.writerow(['Title', 'Redcap Username', 'Forename', 'Surname', 'Email Address','Role','Other', 'Hospital Name', 'Hospital Type', 'Speciality', 'Other','Created'])

    for submission in submissions:

        writer.writerow([unicode(s).encode("utf-8") for s in (
            submission.title,
            submission.redcap_username,
            submission.forename,
            submission.surname,
            submission.email,
            submission.role,
            submission.role_other,
            submission.hospital_name,
            submission.hospital_type,
            submission.speciality,
            submission.speciality_other,
            submission.created
        )])

    return response


    title           = models.CharField(max_length=10, choices=TITLE_CHOICES)
    redcap_username = models.CharField(max_length=100, help_text='Please write your REDCap username in the following format \'first initial\' then \'surname\' then \'.\' then \'contact\' e.g. Tom Smith would be tsmith.contact')
    forename        = models.CharField(max_length=100)
    surname         = models.CharField(max_length=100)
    email           = models.EmailField(verbose_name="Email Address")
    role            = models.CharField(max_length=100, choices=ROLE_CHOICES)
    role_other      = models.CharField(max_length=100, blank=True)
    hospital_name   = models.CharField(max_length=100)
    hospital_type   = models.CharField(max_length=100, choices=TYPE_CHOICES)
    speciality      = models.CharField(max_length=100, choices=SPECIALITY_CHOICES)
    speciality_other = models.CharField(max_length=100, blank=True)


@permission_required('admin_users.can_access_contact_study')
def view_submission(request,submissionid):

    submission = get_object_or_404(ContactStudySubmission,id=submissionid)

    return render(request, 'admin/contact-study/submission.html',{'submission':submission})


@permission_required('admin_users.can_access_contact_study')
def delete_submission(request, submissionid):

    submission = get_object_or_404(ContactStudySubmission,id=submissionid)

    submission.delete()

    return HttpResponseRedirect(reverse('admin_contact_study'))
