# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='ContactStudySubmission',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('title', models.CharField(max_length=10, choices=[('Mr', 'Mr'), ('Mrs', 'Mrs'), ('Miss', 'Miss'), ('Ms', 'Ms'), ('Doctor', 'Doctor'), ('Professor', 'Professor')])),
                ('redcap_username', models.CharField(help_text=b"Please write your REDCap username in the following format 'first initial' then 'surname' then '.' then 'contact' e.g. Tom Smith would be tsmith.contact", max_length=100)),
                ('forename', models.CharField(max_length=100)),
                ('surname', models.CharField(max_length=100)),
                ('email', models.EmailField(max_length=254, verbose_name=b'Email Address')),
                ('role', models.CharField(max_length=100, choices=[('Consultant', 'Consultant'), ('Registrar', 'Registrar'), ('SHO FY1/FY2', 'SHO FY1/FY2'), ('Medical Student', 'Ms'), ('Specialist Nurse', 'Specialist Nurse'), ('Other', 'Other')])),
                ('role_other', models.CharField(max_length=100, blank=True)),
                ('hospital_name', models.CharField(max_length=100)),
                ('hospital_type', models.CharField(max_length=100, choices=[('Specialist Pancreas Centre', 'Specialist Pancreas Centre'), ('Non Specialist Centre', 'Non Specialist Centre')])),
                ('speciality', models.CharField(max_length=100, choices=[('HPB Surgery', 'HPB Surgery'), ('General Surgery', 'General Surgery'), ('Gastroenterology', 'Gastroenterology'), ('Oncology', 'Oncology'), ('Palliative Care', 'Palliative Care'), ('Other', 'Other')])),
                ('speciality_other', models.CharField(max_length=100, blank=True)),
            ],
            options={
                'ordering': ['-created'],
            },
        ),
    ]
