from django.db import models
from django.core.urlresolvers import reverse

class ContactStudySubmission(models.Model):

    TITLE_CHOICES = (
        (u'Mr',u'Mr'),
        (u'Mrs',u'Mrs'),
        (u'Miss',u'Miss'),
        (u'Ms',u'Ms'),
        (u'Doctor',u'Doctor'),
        (u'Professor',u'Professor'),
    )

    ROLE_CHOICES = (
        (u'Consultant',u'Consultant'),
        (u'Registrar',u'Registrar'),
        (u'SHO FY1/FY2',u'SHO FY1/FY2'),
        (u'Medical Student',u'Ms'),
        (u'Specialist Nurse',u'Specialist Nurse'),
        (u'Other',u'Other'),
    )

    TYPE_CHOICES = (
        (u'Specialist Pancreas Centre', u'Specialist Pancreas Centre'),
        (u'Non Specialist Centre', u'Non Specialist Centre'),
    )

    SPECIALITY_CHOICES = (
        (u'HPB Surgery',u'HPB Surgery'),
        (u'General Surgery',u'General Surgery'),
        (u'Gastroenterology',u'Gastroenterology'),
        (u'Oncology',u'Oncology'),
        (u'Palliative Care',u'Palliative Care'),
        (u'Other',u'Other'),
    )

    created         = models.DateTimeField(auto_now_add=True)

    title           = models.CharField(max_length=10, choices=TITLE_CHOICES)
    redcap_username = models.CharField(max_length=100, help_text='Please write your REDCap username in the following format \'first initial\' then \'surname\' then \'.\' then \'contact\' e.g. Tom Smith would be tsmith.contact')
    forename        = models.CharField(max_length=100)
    surname         = models.CharField(max_length=100)
    email           = models.EmailField(verbose_name="Email Address")
    role            = models.CharField(max_length=100, choices=ROLE_CHOICES)
    role_other      = models.CharField(max_length=100, blank=True)
    hospital_name   = models.CharField(max_length=100)
    hospital_type   = models.CharField(max_length=100, choices=TYPE_CHOICES)
    speciality      = models.CharField(max_length=100, choices=SPECIALITY_CHOICES)
    speciality_other = models.CharField(max_length=100, blank=True)

    def __unicode__(self):
        return "%s %s" % (self.forename, self.surname)

    class Meta:
        ordering = ['-created']
