#Django core bits
from django.shortcuts import render, get_object_or_404
from django.contrib import messages

#Forms
from forms import *

#Models
from modules.blocks.models import ContentBlock
from models import *

import emails

def contact_study(request):

    try:
        content_block = ContentBlock.objects.get(slug='contact-study-form')
    except:
        content_block = False

    form = ContactStudyForm()

    if request.POST:
        form = ContactStudyForm(request.POST)
        if form.is_valid():
            submission = form.save(commit=False)
            submission.ip = request.META['REMOTE_ADDR']
            submission.save()

            emails.contact_study_submit(request=request, submission=submission)

            try:
                content_block = ContentBlock.objects.get(slug='contact-study-form-complete')
            except:
                content_block = False

            return render(request, 'public/contact-study/contact-submitted.html', {'content_block':content_block})

        else:
            messages.error(request,'Could not send your enquiry, please check the fields and resubmit.')

    return render(request, 'public/contact-study/contact.html', {'form': form, 'content_block':content_block })