from django.core.exceptions import PermissionDenied
from django.http import HttpResponseRedirect
from django.core.urlresolvers import reverse

from modules.members.models import *

from datetime import datetime,date,time

def superuser_only(function):

    def _inner(request, *args, **kwargs):
        if not request.user.is_superuser:
            return HttpResponseRedirect(reverse('login'))
        return function(request, *args, **kwargs)
    return _inner
    
    
def staff_only(function):
    
    def _inner(request,*args,**kwargs):
        if not request.user.is_staff:
            return HttpResponseRedirect(reverse('login'))
        return function(request,*args,**kwargs)
    return _inner
    

def admin_only(function):
    
    def _inner(request,*args,**kwargs):
        if request.user.is_staff or request.user.is_superuser:
            return function(request,*args,**kwargs)
        else:
            return HttpResponseRedirect(reverse('login'))
    return _inner

def members_only(function):

    def _inner(request, *args, **kwargs):
        if request.user.is_anonymous():
            return HttpResponseRedirect('/login/?next=%s' % request.path)

        try:
            member = Member.objects.get(user=request.user)
            return function(request, *args, **kwargs)
        except Member.DoesNotExist:
            if request.user.is_superuser:
                return HttpResponseRedirect(reverse('member_required'))
            else: 
                return HttpResponseRedirect('/login/?next=%s' % request.path)
    return _inner    

def approved_members_only(function):
    
    def _inner(request, *args, **kwargs):
        if request.user.is_anonymous():
            return HttpResponseRedirect('/login/?next=%s' % request.path)

        try:
            member = Member.objects.get(user=request.user)
            if not member.approved:
                return HttpResponseRedirect(reverse('member_not_approved'))
            else:
                return function(request, *args, **kwargs)
        except Member.DoesNotExist:        
            if request.user.is_superuser:
                return HttpResponseRedirect(reverse('admin'))
            else: 
                return HttpResponseRedirect('/login/?next=%s' % request.path)
    return _inner

def current_members_only(function):

    def _inner(request, *args, **kwargs):
        if request.user.is_anonymous():
            return HttpResponseRedirect('/login/?next=%s' % request.path)

        try:
            member = Member.objects.get(user=request.user)
            if not member.is_current() or not member.approved:
                return HttpResponseRedirect(reverse('member_expired'))
            else:
                return function(request, *args, **kwargs)
        except Member.DoesNotExist:        
            if request.user.is_superuser:
                return HttpResponseRedirect(reverse('admin'))
            else: 
                return HttpResponseRedirect('/login/?next=%s' % request.path)
    return _inner