from django.forms import ModelForm
from django.contrib.auth.forms import AuthenticationForm

from django import forms

class LoginForm(forms.Form):
    
    email_address = forms.EmailField()
    password      = forms.CharField(widget=forms.PasswordInput(), min_length=6, max_length=20, label='Password')

class ForgotPasswordForm(forms.Form):
    email       = forms.CharField(max_length=50, label='Email Address')
    
class ChangePasswordForm(forms.Form):
    
    password1 = forms.CharField(widget=forms.PasswordInput(), min_length=6, max_length=20, label='New Password')
    password2 = forms.CharField(widget=forms.PasswordInput(), min_length=6, max_length=20, label='Confirm Password')

    def clean_password2(self):
        password1 = self.cleaned_data.get('password1')
        password2 = self.cleaned_data.get('password2')

        if password1 and password2:
            if password1 != password2:
                raise forms.ValidationError(u'Please ensure your passwords match')
    