#Django core bits
from django.shortcuts import render_to_response, get_object_or_404
from django.template import RequestContext, loader, Context
from django.contrib.auth.decorators import login_required, permission_required
from django.db.models import Q
from django.conf import settings
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.contrib.auth.models import User, Group
from django.contrib import messages
from datetime import datetime, date, time
import random,csv,string

from modules.core.functions import *
from modules.members.functions import *
from modules.payments.functions import *

from signals import *

#Forms
from forms import *

#Models
from models import *
from modules.members.models import *
from modules.payments.models import *

@permission_required('admin_users.can_access_donations')
def donations(request):
    
    donations = Donation.objects.filter(complete=True).order_by('-created')
    
    return render_to_response('admin/donations/donations.html',{'donations':donations},context_instance=RequestContext(request))

@permission_required('admin_users.can_access_donations')
def download_donations(request):
    
    donations = Donation.objects.filter(complete=True).order_by('-created')
    
    # Create the HttpResponse object with the appropriate CSV header.
    response = HttpResponse(content_type='text/csv')
    response['Content-Disposition'] = "attachment; filename=donations.csv"

    writer = csv.writer(response)
    
    writer.writerow(['Title','Name','Email Address', 'Address 1', 'Address 2', 'Town', 'County', 'Country', 'Telephone', 'Amount', 'Created'])

    for donation in donations:
        
        name= "%s %s" % (donation.first_name,donation.surname)

        writer.writerow([unicode(s).encode("utf-8") for s in (donation.title,name,donation.email_address,donation.address_1,donation.address_2,donation.town,donation.county,donation.country,donation.telephone,donation.amount,donation.created)])

    return response
    
@permission_required('admin_users.can_access_donations')
def view_donation(request,donation_id):
    
    donation = get_object_or_404(Donation,id=donation_id)
    
    return render_to_response('admin/donations/view-donation.html',{'donation':donation},context_instance=RequestContext(request))
    
@permission_required('admin_users.can_access_donations')
def delete_donation(request,donation_id):
    
    donation = get_object_or_404(Donation,id=donation_id)
    
    try:
        donation.delete()
        messages.success(request,'Donation Deleted')
    
    except:
        messages.error(request,'Could not delete donation')
        
    return HttpResponseRedirect(reverse('admin_donations'))