from django.conf.urls import *
from django.conf import settings

import adminviews

urlpatterns = (
    url(r'^$',adminviews.evaluations, name='admin_evaluations'),
    url(r'^add/$',adminviews.add_evaluation, name='admin_evaluations_add_evaluation'),
    url(r'^(?P<evaluation_id>[-\d]+)/edit/$', adminviews.edit_evaluation, name='admin_evaluations_edit_evaluation'),
    url(r'^(?P<evaluation_id>[-\d]+)/delete/$', adminviews.delete_evaluation, name='admin_evaluations_delete_evaluation'),
    url(r'^(?P<evaluation_id>[-\d]+)/enable/$', adminviews.enable_evaluation, name='admin_evaluations_enable_evaluation'),
    url(r'^(?P<evaluation_id>[-\d]+)/disable/$', adminviews.disable_evaluation, name='admin_evaluations_disable_evaluation'),
    url(r'^(?P<evaluation_id>[-\d]+)/preview/$', adminviews.preview_evaluation, name='admin_evaluations_preview_evaluation'),
    url(r'^(?P<evaluation_id>[-\d]+)/preview/pdf/$', adminviews.preview_evaluation_pdf, name='admin_evaluations_preview_evaluation_pdf'),
    
    url(r'^(?P<evaluation_id>[-\d]+)/days/$',adminviews.evaluation_days, name='admin_evaluations_evaluation_days'),
    url(r'^(?P<evaluation_id>[-\d]+)/days/add/$',adminviews.add_evaluation_day, name='admin_evaluations_add_evaluation_day'),
    url(r'^(?P<evaluation_id>[-\d]+)/days/(?P<day_id>[-\d]+)/edit/$', adminviews.edit_evaluation_day, name='admin_evaluations_edit_evaluation_day'),
    url(r'^(?P<evaluation_id>[-\w]+)/days/(?P<day_id>[-\d]+)/delete/$', adminviews.delete_evaluation_day, name='admin_evaluations_delete_evaluation_day'),
    
    url(r'^(?P<evaluation_id>[-\d]+)/areas/$',adminviews.evaluation_areas, name='admin_evaluations_evaluation_areas'),
    url(r'^(?P<evaluation_id>[-\d]+)/areas/add/$',adminviews.add_evaluation_area, name='admin_evaluations_add_evaluation_area'),
    url(r'^(?P<evaluation_id>[-\d]+)/areas/(?P<area_id>[-\d]+)/edit/$', adminviews.edit_evaluation_area, name='admin_evaluations_edit_evaluation_area'),
    url(r'^(?P<evaluation_id>[-\w]+)/areas/(?P<area_id>[-\d]+)/delete/$', adminviews.delete_evaluation_area, name='admin_evaluations_delete_evaluation_area'),
    
    url(r'^(?P<evaluation_id>[-\w]+)/areas/(?P<area_id>[-\d]+)/items/add/$', adminviews.add_evaluation_item, name='admin_evaluations_add_evaluation_item'),
    url(r'^(?P<evaluation_id>[-\d]+)/areas/(?P<area_id>[-\d]+)/items/(?P<item_id>[-\d]+)/edit/$', adminviews.edit_evaluation_item, name='admin_evaluations_edit_evaluation_item'),
    url(r'^(?P<evaluation_id>[-\w]+)/areas/(?P<area_id>[-\d]+)/items/(?P<item_id>[-\d]+)/delete/$', adminviews.delete_evaluation_item, name='admin_evaluations_delete_evaluation_item'),
    
    url(r'^(?P<evaluation_id>[-\d]+)/questions/$',adminviews.evaluation_questions, name='admin_evaluations_evaluation_questions'),
    url(r'^(?P<evaluation_id>[-\d]+)/questions/add/$',adminviews.add_evaluation_question, name='admin_evaluations_add_evaluation_question'),
    url(r'^(?P<evaluation_id>[-\d]+)/questions/(?P<question_id>[-\d]+)/edit/$', adminviews.edit_evaluation_question, name='admin_evaluations_edit_evaluation_question'),
    url(r'^(?P<evaluation_id>[-\w]+)/questions/(?P<question_id>[-\d]+)/delete/$', adminviews.delete_evaluation_question, name='admin_evaluations_delete_evaluation_question'),
    
    url(r'^(?P<evaluation_id>[-\d]+)/submissions/$',adminviews.evaluation_submissions, name='admin_evaluations_evaluation_submissions'),
    url(r'^(?P<evaluation_id>[-\d]+)/submissions/download/$',adminviews.download_evaluation_submissions, name='admin_evaluations_evaluation_submissions_download'),
    url(r'^(?P<evaluation_id>[-\d]+)/submissions/(?P<submission_id>[-\d]+)/view/$',adminviews.view_evaluation_submission, name='admin_evaluations_view_evaluation_submission'),


)