#Django core bits
from django.shortcuts import render_to_response, get_object_or_404
from django.template import RequestContext, loader, Context
from django.contrib.auth.decorators import login_required, permission_required
from django.conf import settings
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.contrib import messages

from datetime import datetime, date, time
import csv

import pdfcrowd

#Forms
from forms import *

#Models
from models import *
from modules.members.models import *

@permission_required('admin_users.can_access_evaluation')
def evaluations(request):

    enabled_evaluations = Evaluation.objects.filter(enabled=True).order_by('name')
    disabled_evaluations = Evaluation.objects.filter(enabled=False).order_by('name')

    return render(request, 'admin/evaluations/evaluations.html',{'enabled_evaluations':enabled_evaluations,'disabled_evaluations':disabled_evaluations})

@permission_required('admin_users.can_access_evaluation')
def add_evaluation(request):

    form = AdminEvaluationForm()

    if request.POST:
        form = AdminEvaluationForm(request.POST,request.FILES)

        if form.is_valid():
            try:
                evaluation = form.save(commit=False)
                evaluation.slug = slugify_unique(evaluation.name,Evaluation,'slug')
                evaluation.save()

                messages.success(request,'Evaluation has been created')
                return HttpResponseRedirect(reverse('admin_evaluations'))

            except:
                messages.error(request,'Could not create evaluation')

    return render(request, 'admin/evaluations/add-evaluation.html',{'form':form})

@permission_required('admin_users.can_access_evaluation')
def edit_evaluation(request,evaluation_id):

    evaluation = get_object_or_404(Evaluation,id=evaluation_id)

    form = AdminEvaluationForm(instance=evaluation)

    if request.POST:

        form = AdminEvaluationForm(request.POST,request.FILES,instance=evaluation)
        if form.is_valid():
            try:
                form.save()
                messages.success(request,'Evaluation has been updated')
                return HttpResponseRedirect(reverse('admin_evaluations'))
            except:
                messages.error(request,'Could not update evaluation')

    return render(request, 'admin/evaluations/edit-evaluation.html',{'form':form})

@permission_required('admin_users.can_access_evaluation')
def delete_evaluation(request,evaluation_id):

    evaluation = get_object_or_404(Evaluation,id=evaluation_id)

    try:
        evaluation.delete()
        messages.success(request,'Evaluation Deleted')
    except:
        messages.error(request,'Could not delete evaluation')

    return HttpResponseRedirect(reverse('admin_evaluations'))

@permission_required('admin_users.can_access_evaluation')
def enable_evaluation(request,evaluation_id):

    evaluation = get_object_or_404(Evaluation,id=evaluation_id)

    try:
        evaluation.enabled = True
        evaluation.save()
        messages.success(request,'Evaluation has been enabled')
    except:
        messages.error(request,'Could not enable evaluation')

    return HttpResponseRedirect(reverse('admin_evaluations'))

@permission_required('admin_users.can_access_evaluation')
def disable_evaluation(request,evaluation_id):

    evaluation = get_object_or_404(Evaluation,id=evaluation_id)

    try:
        evaluation.enabled = False
        evaluation.save()
        messages.success(request,'Evaluation has been disabled')
    except:
        messages.error(request,'Could not disable evaluation')

    return HttpResponseRedirect(reverse('admin_evaluations'))


@permission_required('admin_users.can_access_evaluation')
def preview_evaluation(request,evaluation_id):

    evaluation = get_object_or_404(Evaluation,id=evaluation_id)

    try:
        # create an API client instance
        client = pdfcrowd.Client("calmdigital", "dc33e7c4525620565185d0a00d90b8f0")
        client.setPageMargins('50','50','0','50')

        html = loader.render_to_string('public/evaluation/pdf/certificate.html',{'evaluation':evaluation,'preview':True})
        pdf = client.convertHtml(html)

         # set HTTP response headers
        response = HttpResponse(content_type="application/pdf")
        response["Cache-Control"] = "no-cache"
        response["Accept-Ranges"] = "none"
        response["Content-Disposition"] = "attachment; filename=cpd_preview.pdf"

        response.write(pdf)

    except pdfcrowd.Error, why:
        response = HttpResponse(content_type="text/plain")
        response.write(why)
    return response

def preview_evaluation_pdf(request,evaluation_id):

    evaluation = get_object_or_404(Evaluation,id=evaluation_id)

    return render(request, 'public/evaluation/pdf/certificate.html',{'evaluation':evaluation,'preview':True})


@permission_required('admin_users.can_access_evaluation')
def evaluation_days(request,evaluation_id):

    evaluation = get_object_or_404(Evaluation,id=evaluation_id)
    evaluation_days = EvaluationDay.objects.filter(evaluation=evaluation).order_by('order')

    return render(request, 'admin/evaluations/evaluation-days.html',{'evaluation':evaluation,'evaluation_days':evaluation_days})

@permission_required('admin_users.can_access_evaluation')
def add_evaluation_day(request,evaluation_id):

    evaluation = get_object_or_404(Evaluation,id=evaluation_id)
    form = AdminEvaluationDayForm()

    if request.POST:
        form = AdminEvaluationDayForm(request.POST)
        if form.is_valid():
            try:
                evaluation_day = form.save(commit=False)
                evaluation_day.evaluation = evaluation
                evaluation_day.save()

                messages.success(request,'Evaluation Day has been created')

                return HttpResponseRedirect(reverse('admin_evaluations_evaluation_days',args=[evaluation.id]))

            except:
                messages.error(request,'Could not create Evaluation Day')

    return render(request, 'admin/evaluations/add-evaluation-day.html',{'form':form,'evaluation':evaluation})


@permission_required('admin_users.can_access_evaluation')
def edit_evaluation_day(request,evaluation_id,day_id):

    evaluation = get_object_or_404(Evaluation,id=evaluation_id)
    evaluation_day = get_object_or_404(EvaluationDay,id=day_id,evaluation=evaluation)

    form = AdminEvaluationDayForm(instance=evaluation_day)

    if request.POST:
        form = AdminEvaluationDayForm(request.POST,instance=evaluation_day)
        if form.is_valid():
            try:
                form.save()
                messages.success(request,'Evaluation Day has been updated')

                return HttpResponseRedirect(reverse('admin_evaluations_evaluation_days',args=[evaluation.id]))
            except:
                messages.error(request,'Could not update evaluation day.')

    return render(request, 'admin/evaluations/edit-evaluation-day.html',{'evaluation':evaluation,'evaluation_day':evaluation_day,'form':form})

@permission_required('admin_users.can_access_evaluation')
def delete_evaluation_day(request,evaluation_id,day_id):

    evaluation = get_object_or_404(Evaluation,id=evaluation_id)
    evaluation_day = get_object_or_404(EvaluationDay,id=day_id,evaluation=evaluation)

    try:
        evaluation_day.delete()
        messages.success(request,'Evaluation Day Deleted')
    except:
        messages.error(request,'Could not delete evaluation day')

    return HttpResponseRedirect(reverse('admin_evaluations_evaluation_days',args=[evaluation.id]))


@permission_required('admin_users.can_access_evaluation')
def evaluation_areas(request,evaluation_id):

    evaluation = get_object_or_404(Evaluation,id=evaluation_id)
    evaluation_areas = EvaluationArea.objects.filter(evaluation=evaluation).order_by('order')

    return render(request, 'admin/evaluations/evaluation-areas.html',{'evaluation':evaluation,'evaluation_areas':evaluation_areas})

@permission_required('admin_users.can_access_evaluation')
def add_evaluation_area(request,evaluation_id):

    evaluation = get_object_or_404(Evaluation,id=evaluation_id)
    form = AdminEvaluationAreaForm()

    if request.POST:
        form = AdminEvaluationAreaForm(request.POST)
        if form.is_valid():
            try:
                evaluation_area = form.save(commit=False)
                evaluation_area.evaluation = evaluation
                evaluation_area.save()

                messages.success(request,'Evaluation Area has been created')

                return HttpResponseRedirect(reverse('admin_evaluations_evaluation_areas',args=[evaluation.id]))

            except:
                messages.error(request,'Could not create Evaluation Area')

    return render(request, 'admin/evaluations/edit-evaluation-area.html',{'evaluation':evaluation,'form':form})

@permission_required('admin_users.can_access_evaluation')
def edit_evaluation_area(request,evaluation_id,area_id):

    evaluation = get_object_or_404(Evaluation,id=evaluation_id)
    evaluation_area = get_object_or_404(EvaluationArea,id=area_id,evaluation=evaluation)

    form = AdminEvaluationAreaForm(instance=evaluation_area)

    if request.POST:
        form = AdminEvaluationAreaForm(request.POST,instance=evaluation_area)
        if form.is_valid():
            try:
                form.save()
                messages.success(request,'Evaluation Day has been updated')

                return HttpResponseRedirect(reverse('admin_evaluations_evaluation_areas',args=[evaluation.id]))
            except:
                messages.error(request,'Could not update evaluation day.')

    return render(request, 'admin/evaluations/edit-evaluation-area.html',{'evaluation':evaluation,'evaluation_area':evaluation_area,'form':form})


@permission_required('admin_users.can_access_evaluation')
def delete_evaluation_area(request,evaluation_id,area_id):

    evaluation = get_object_or_404(Evaluation,id=evaluation_id)
    evaluation_area = get_object_or_404(EvaluationArea,id=area_id,evaluation=evaluation)

    try:
        evaluation_area.delete()
        messages.success(request,'Evaluation area deleted')
    except:
        messages.error(request,'Could not delete evaluation area')

    return HttpResponseRedirect(reverse('admin_evaluations_evaluation_areas',args=[evaluation.id]))

@permission_required('admin_users.can_access_evaluation')
def add_evaluation_item(request,evaluation_id,area_id):

    evaluation = get_object_or_404(Evaluation,id=evaluation_id)
    evaluation_area = get_object_or_404(EvaluationArea,id=area_id,evaluation=evaluation)
    form = AdminEvaluationItemForm()

    if request.POST:
        form = AdminEvaluationItemForm(request.POST)

        if form.is_valid():
            try:
                evaluation_item = form.save(commit=False)
                evaluation_item.evaluation_area = evaluation_area
                evaluation_item.save()

                messages.success(request,'Item has been created')

                return HttpResponseRedirect(reverse('admin_evaluations_evaluation_areas',args=[evaluation.id]))

            except:
                messages.error(request,'Could not save item')

    return render(request, 'admin/evaluations/add-evaluation-item.html',{'evaluation':evaluation,'evaluation_area':evaluation_area,'form':form})


@permission_required('admin_users.can_access_evaluation')
def edit_evaluation_item(request,evaluation_id,area_id,item_id):

    evaluation = get_object_or_404(Evaluation,id=evaluation_id)
    evaluation_area = get_object_or_404(EvaluationArea,id=area_id,evaluation=evaluation)
    evaluation_item = get_object_or_404(EvaluationItem,id=item_id,evaluation_area=evaluation_area)
    form = AdminEvaluationItemForm(instance=evaluation_item)

    if request.POST:
        form = AdminEvaluationItemForm(request.POST,instance=evaluation_item)
        if form.is_valid():
            try:
                form.save()
                messages.success(request,'Item saved')

                return HttpResponseRedirect(reverse('admin_evaluations_evaluation_areas',args=[evaluation.id]))

            except:
                messages.error(request,'Could not save item')

    return render(request, 'admin/evaluations/edit-evaluation-item.html',{'evaluation':evaluation,'evaluation_area':evaluation_area,'evaluation_item':evaluation_item,'form':form})

@permission_required('admin_users.can_access_evaluation')
def delete_evaluation_item(request,evaluation_id,area_id,item_id):

    evaluation = get_object_or_404(Evaluation,id=evaluation_id)
    evaluation_area = get_object_or_404(EvaluationArea,id=area_id,evaluation=evaluation)
    evaluation_item = get_object_or_404(EvaluationItem,id=item_id,evaluation_area=evaluation_area)

    try:
        evaluation_item.delete()
        messages.success(request,'Evaluation item deleted')
    except:
        messages.error(request,'Could not delete evaluation item')

    return HttpResponseRedirect(reverse('admin_evaluations_evaluation_areas',args=[evaluation.id]))


@permission_required('admin_users.can_access_evaluation')
def evaluation_questions(request,evaluation_id):

    evaluation = get_object_or_404(Evaluation,id=evaluation_id)
    evaluation_questions = EvaluationQuestion.objects.filter(evaluation=evaluation).order_by('order')

    return render(request, 'admin/evaluations/evaluation-questions.html',{'evaluation':evaluation,'evaluation_questions':evaluation_questions})

@permission_required('admin_users.can_access_evaluation')
def add_evaluation_question(request,evaluation_id):

    evaluation = get_object_or_404(Evaluation,id=evaluation_id)
    form = AdminEvaluationQuestionForm()

    if request.POST:
        form = AdminEvaluationQuestionForm(request.POST)
        if form.is_valid():
            try:
                question = form.save(commit=False)
                question.evaluation = evaluation
                question.save()

                messages.success(request,'Question created')
                return HttpResponseRedirect(reverse('admin_evaluations_evaluation_questions',args=[evaluation.id]))

            except:
                messages.error(request,'Could not add Question')

    return render(request, 'admin/evaluations/add-evaluation-question.html',{'evaluation':evaluation,'form':form})

@permission_required('admin_users.can_access_evaluation')
def edit_evaluation_question(request,evaluation_id,question_id):

    evaluation = get_object_or_404(Evaluation,id=evaluation_id)
    evaluation_question = get_object_or_404(EvaluationQuestion,id=question_id,evaluation=evaluation)

    form = AdminEvaluationQuestionForm(instance=evaluation_question)

    if request.POST:
        form = AdminEvaluationQuestionForm(request.POST,instance=evaluation_question)
        if form.is_valid():
            try:
                form.save()
                messages.success(request,'Question updated')
                return HttpResponseRedirect(reverse('admin_evaluations_evaluation_questions',args=[evaluation.id]))
            except:
                messages.error(request,'Could not update question')

    return render(request, 'admin/evaluations/edit-evaluation-question.html',{'evaluation':evaluation,'evaluation_question':evaluation_question,'form':form})

@permission_required('admin_users.can_access_evaluation')
def delete_evaluation_question(request,evaluation_id,question_id):

    evaluation = get_object_or_404(Evaluation,id=evaluation_id)
    evaluation_question = get_object_or_404(EvaluationQuestion,id=question_id,evaluation=evaluation)

    try:
        evaluation_question.delete()
        messages.success(request,'Evaluation question deleted')
    except:
        messages.error(request,'Could not delete evaluation question')

    return HttpResponseRedirect(reverse('admin_evaluations_evaluation_questions',args=[evaluation.id]))

@permission_required('admin_users.can_access_evaluation')
def evaluation_submissions(request,evaluation_id):

    evaluation = get_object_or_404(Evaluation,id=evaluation_id)
    evaluation_submissions = EvaluationSubmission.objects.filter(evaluation=evaluation).order_by('-created')

    return render(request, 'admin/evaluations/evaluation-submissions.html',{'evaluation':evaluation,'evaluation_submissions':evaluation_submissions})

@permission_required('admin_users.can_access_evaluation')
def download_evaluation_submissions(request,evaluation_id):

    evaluation = get_object_or_404(Evaluation,id=evaluation_id)
    evaluation_submissions = EvaluationSubmission.objects.filter(evaluation=evaluation).order_by('-created')

    fields = ['Name','Email Address','Time Submitted']
    evaluation_days = EvaluationDay.objects.filter(evaluation=evaluation).order_by('order')
    for day in evaluation_days:
        fields.append(day.name)

    evaluation_areas = EvaluationArea.objects.filter(evaluation=evaluation).order_by('order')
    for area in evaluation_areas:
        evaluation_items = EvaluationItem.objects.filter(evaluation_area=area).order_by('order')
        for item in evaluation_items:
            fields.append(item.name)

    evaluation_questions = EvaluationQuestion.objects.filter(evaluation=evaluation).order_by('order')
    for question in evaluation_questions:
        fields.append(question.name)

    response = HttpResponse(content_type='text/csv')
    response['Content-Disposition'] = "attachment; filename=evaluation_submissions.csv"

    writer = csv.writer(response)
    writer.writerow(fields)

    for submission in evaluation_submissions:

        submission_array = [submission.name,submission.email_address,submission.created]
        for evaluation_day in evaluation_days:
            try:
                evaluation_day_submission = EvaluationDaySubmission.objects.get(evaluation_day=evaluation_day,evaluation_submission=submission)
                submission_array.append('Yes')
            except:
                submission_array.append('No')

        for area in evaluation_areas:
            evaluation_items = EvaluationItem.objects.filter(evaluation_area=area).order_by('order')
            for item in evaluation_items:
                try:
                    evaluation_item_submission = EvaluationItemSubmission.objects.get(evaluation_item=item,evaluation_submission=submission)
                    submission_array.append(evaluation_item_submission.choice)
                except:
                    submission_array.append('')

        for question in evaluation_questions:
            try:
                evaluation_question_submission = EvaluationQuestionSubmission.objects.get(evaluation_question=question,evaluation_submission=submission)
                submission_array.append(evaluation_question_submission.answer)
            except:
                submission_array,append('')

        writer.writerow([unicode(s).encode("utf-8") for s in submission_array])

    return response

@permission_required('admin_users.can_access_evaluation')
def view_evaluation_submission(request,evaluation_id,submission_id):

    evaluation = get_object_or_404(Evaluation,id=evaluation_id)
    evaluation_submission = get_object_or_404(EvaluationSubmission,id=submission_id,evaluation=evaluation)

    return render(request, 'admin/evaluations/view-evaluation-submission.html',{'evaluation':evaluation,'evaluation_submission':evaluation_submission})
