from django.forms import ModelForm
from django import forms

from models import *

class EvaluationForm(ModelForm):
    
    class Meta:
        model = EvaluationSubmission
        fields = ('name','email_address')
        
        
class AdminEvaluationForm(ModelForm):
    
    class Meta:
        model = Evaluation
        exclude = ('slug',)
        
class AdminEvaluationDayForm(ModelForm):
    
    class Meta:
        model = EvaluationDay
        exclude = ('evaluation',)
        
        
class AdminEvaluationAreaForm(ModelForm):
    
    class Meta:
        model = EvaluationArea
        exclude = ('evaluation',)
        
class AdminEvaluationItemForm(ModelForm):

    class Meta:
        model = EvaluationItem
        exclude = ('evaluation_area',)
        
class AdminEvaluationQuestionForm(ModelForm):
    
    class Meta:
        model = EvaluationQuestion
        exclude = ('evaluation',)