# -*- coding: utf-8 -*-
# Generated by Django 1.11.26 on 2022-03-11 16:06
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('members', '0017_auto_20200903_1205'),
    ]

    operations = [
        migrations.CreateModel(
            name='Evaluation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('slug', models.SlugField()),
                ('description', models.TextField()),
                ('enabled', models.BooleanField(default=False)),
                ('event_name', models.CharField(blank=True, max_length=200, null=True)),
                ('event_date', models.CharField(blank=True, max_length=200, null=True)),
                ('event_venue', models.TextField(blank=True, null=True)),
                ('event_author', models.TextField(blank=True, null=True)),
                ('event_signature', models.ImageField(upload_to=b'evaluations')),
            ],
        ),
        migrations.CreateModel(
            name='EvaluationArea',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('order', models.IntegerField()),
                ('scale', models.CharField(choices=[('poor-excellent', 'Poor to Excellent'), ('numeric', '1 to 5'), ('more-less', 'More,Less')], max_length=20)),
                ('evaluation', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='evaluation.Evaluation')),
            ],
        ),
        migrations.CreateModel(
            name='EvaluationDay',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('cpd_points', models.IntegerField()),
                ('order', models.IntegerField()),
                ('evaluation', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='evaluation.Evaluation')),
            ],
        ),
        migrations.CreateModel(
            name='EvaluationDaySubmission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('evaluation_day_name', models.CharField(max_length=200)),
                ('evaluation_day_points', models.IntegerField()),
                ('evaluation_day', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='evaluation.EvaluationDay')),
            ],
        ),
        migrations.CreateModel(
            name='EvaluationItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('order', models.IntegerField()),
                ('did_not_attend_option', models.BooleanField(default=False, verbose_name=b'Show Did Not Attend Option')),
                ('evaluation_area', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='evaluation.EvaluationArea')),
            ],
        ),
        migrations.CreateModel(
            name='EvaluationItemSubmission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('item_name', models.CharField(max_length=200)),
                ('choice', models.CharField(max_length=200)),
                ('evaluation_item', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='evaluation.EvaluationItem')),
            ],
        ),
        migrations.CreateModel(
            name='EvaluationQuestion',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('type', models.CharField(choices=[('text', 'Text Box'), ('text-area', 'Text Area')], max_length=200)),
                ('required', models.BooleanField(default=False)),
                ('order', models.IntegerField()),
                ('evaluation', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='evaluation.Evaluation')),
            ],
        ),
        migrations.CreateModel(
            name='EvaluationQuestionSubmission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('question_name', models.CharField(max_length=200)),
                ('answer', models.TextField()),
                ('evaluation_question', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='evaluation.EvaluationQuestion')),
            ],
        ),
        migrations.CreateModel(
            name='EvaluationSubmission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('evaluation_name', models.CharField(max_length=200)),
                ('name', models.CharField(max_length=200)),
                ('email_address', models.EmailField(max_length=200)),
                ('created', models.DateTimeField(auto_now_add=True, max_length=200)),
                ('certificate', models.FileField(blank=True, null=True, upload_to=b'members/certificates')),
                ('evaluation', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='evaluation.Evaluation')),
                ('website_user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='members.Member')),
            ],
        ),
        migrations.AddField(
            model_name='evaluationquestionsubmission',
            name='evaluation_submission',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='evaluation.EvaluationSubmission'),
        ),
        migrations.AddField(
            model_name='evaluationitemsubmission',
            name='evaluation_submission',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='evaluation.EvaluationSubmission'),
        ),
        migrations.AddField(
            model_name='evaluationdaysubmission',
            name='evaluation_submission',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='evaluation.EvaluationSubmission'),
        ),
    ]
