from django.template import Library

register = Library()

@register.filter
def get_evaluation_day_post_value(model,request):
    
    if request.POST:
        if request.POST.getlist('evaluation_days'):
            for posted_model in request.POST.getlist('evaluation_days'):
                if int(posted_model) == model.id:
                    return True

    return False

@register.filter
def get_evaluation_item_post_value(model,request):

    if request.POST:
        if request.POST.get("evaluation_item_%s" % (model.id)):
            return request.POST["evaluation_item_%s" % (model.id)]
        else:
            return ''
    else:
        return ''
        
@register.filter
def get_evaluation_question_post_value(model,request):

    if request.POST:
        if request.POST.get("question_%s" % (model.id)):
            return request.POST["question_%s" % (model.id)]
        else:
            return ''
    else:
        return ''