#Django core bits
from django.shortcuts import render_to_response, get_object_or_404
from django.template.loader import render_to_string
from django.conf import settings
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.contrib import messages
from datetime import datetime,date,time
import math

import pdfcrowd

#Models
from models import *
from modules.members.models import *

from forms import *

#Others
import random,csv,string

from emails import evaluation_completed

def evaluation(request,evaluation_slug):

    evaluation = get_object_or_404(Evaluation,slug=evaluation_slug,enabled=True)
    evaluation_areas = EvaluationArea.objects.filter(evaluation=evaluation).order_by('order')
    evaluation_questions = EvaluationQuestion.objects.filter(evaluation=evaluation).order_by('order')
    evaluation_days = EvaluationDay.objects.filter(evaluation=evaluation).order_by('order')

    already_submitted = False
    if request.user.is_authenticated():
        try:
            member = Member.objects.get(user=request.user)
            evaluation_form = EvaluationForm(initial={'name':"%s %s" % (member.given_name,member.surname), 'email_address':member.user.email})

            evaluation_submissions = EvaluationSubmission.objects.filter(evaluation=evaluation,website_user=member)
            if evaluation_submissions:
                already_submitted = True

        except Member.DoesNotExist:
            evaluation_form = EvaluationForm()
    else:
        evaluation_form = EvaluationForm()

    if request.POST:
        errors = False
        evaluation_form = EvaluationForm(request.POST)

        if evaluation_form.is_valid():

            evaluation_submission = EvaluationSubmission.objects.filter(email_address=request.POST['email_address'],evaluation=evaluation)

            if evaluation_submission:

                messages.error(request,'Sorry, you have already submitted an evaluation')

            else :

                evaluation_items = EvaluationItem.objects.filter(evaluation_area__evaluation=evaluation)

                for item in evaluation_items:
                    if not request.POST.get('evaluation_item_%s' % (item.id)):
                        errors = True

                required_questions = EvaluationQuestion.objects.filter(evaluation=evaluation,required=True)
                for question in required_questions:
                    if not request.POST.get('question_%s' % (question.id)):
                        errors = True

                evaluation_days_submitted = request.POST.getlist('evaluation_days')
                if not evaluation_days_submitted:
                    errors = True

                if not errors:

                    evaluation_submission = evaluation_form.save(commit=False)
                    evaluation_submission.evaluation = evaluation
                    evaluation_submission.evaluation_name = evaluation.name

                    try:
                        member = Member.objects.get(user__email=request.POST['email_address'])
                        evaluation_submission.member = member
                    except:
                        pass

                    evaluation_submission.save()

                    for item in evaluation_items:
                        item_submission = EvaluationItemSubmission(evaluation_submission=evaluation_submission,evaluation_item=item,item_name=item.name,choice=request.POST['evaluation_item_%s' % item.id])
                        item_submission.save()

                    for question in evaluation_questions:
                        question_submission = EvaluationQuestionSubmission(evaluation_submission=evaluation_submission,evaluation_question=question,question_name=question.name,answer=request.POST['question_%s' % question.id])
                        question_submission.save()

                    for evaluation_day_submitted in evaluation_days_submitted:
                        try:
                            evaluation_day = EvaluationDay.objects.get(id=evaluation_day_submitted,evaluation=evaluation)
                            evaluation_day_submission = EvaluationDaySubmission(evaluation_submission=evaluation_submission,evaluation_day=evaluation_day,evaluation_day_name=evaluation_day.name,evaluation_day_points=evaluation_day.cpd_points)
                            evaluation_day_submission.save()
                        except:
                            pass

                    evaluation_submission.save()

                    #try:
                    # create an API client instance
                    client = pdfcrowd.Client("calmdigital", "dc33e7c4525620565185d0a00d90b8f0")
                    client.setPageMargins('50','50','0','50')

                    # convert an HTML string and save the result to a file
                    output_file = open(os.path.join(settings.PRIVATE_FILES, 'members/certificates/cpd_certificate_%s.pdf' % (evaluation_submission.id)), 'wb')
                    content = render_to_string('public/evaluation/pdf/certificate.html',{'evaluation':evaluation_submission.evaluation, 'evaluation_submission':evaluation_submission})
                    client.convertHtml(content, output_file)
                    output_file.close()
                    #except:
                    #    pass

                    evaluation_submission.certificate = 'members/certificates/cpd_certificate_%s.pdf' % (evaluation_submission.id)
                    evaluation_submission.save()

                    #email here
                    evaluation_completed(request=request,evaluation_submission=evaluation_submission)

                    return render(request, 'public/evaluation/evaluation-submitted.html',{'evaluation':evaluation})

                else:
                    messages.error(request,'Please ensure you have completed all required items.')

    return render(request, 'public/evaluation/evaluation.html',{'evaluation':evaluation,'evaluation_areas':evaluation_areas,'evaluation_questions':evaluation_questions,'evaluation_days':evaluation_days,'evaluation_form':evaluation_form,'already_submitted':already_submitted})


def evaluation_submission_pdf(request,submission_id):

    evaluation_submission = get_object_or_404(EvaluationSubmission,id=submission_id)

    return render(request, 'public/evaluation/pdf/certificate.html',{'evaluation':evaluation_submission.evaluation,'evaluation_submission':evaluation_submission})
