# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations


class Migration(migrations.Migration):

    dependencies = [
        ('resources', '0001_initial'),
        ('blocks', '0001_initial'),
        ('members', '0003_auto_20150904_1057'),
    ]

    operations = [
        migrations.CreateModel(
            name='MediaArticle',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=150)),
                ('slug', models.SlugField(unique=True, max_length=160)),
                ('description', models.TextField(verbose_name=b'Snippet', blank=True)),
                ('keywords', models.TextField(help_text=b'These are used for search, please enter comma separated.', blank=True)),
                ('content', models.TextField()),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('archive_date', models.DateField(null=True, blank=True)),
                ('published', models.BooleanField(default=True)),
                ('sticky', models.BooleanField(default=False, verbose_name=b'Pull article to top of list')),
                ('event_date_start', models.DateField(null=True, verbose_name=b'Date Event Starts', blank=True)),
                ('event_date_end', models.DateField(null=True, verbose_name=b'Date Event Ends', blank=True)),
                ('limit_to_member_groups', models.ManyToManyField(to='members.MemberGroup', blank=True)),
                ('limit_to_member_types', models.ManyToManyField(to='members.MemberType', blank=True)),
                ('search_terms', models.ManyToManyField(to='blocks.HomepageSearch', blank=True)),
            ],
        ),
        migrations.CreateModel(
            name='MediaArticleResource',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=150)),
                ('order', models.IntegerField()),
                ('article', models.ForeignKey(to='mediacentre.MediaArticle')),
                ('resource', models.ForeignKey(to='resources.Resource')),
            ],
        ),
        migrations.CreateModel(
            name='MediaSection',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=150)),
                ('slug', models.SlugField(unique=True, max_length=160)),
                ('type', models.CharField(max_length=50, choices=[('news', 'News'), ('events', 'Events')])),
                ('order', models.CharField(max_length=50, choices=[('created', 'Oldest First'), ('-created', 'Newest First'), ('title', 'Alphabetical'), ('-title', 'Alphabetical Reverse'), ('event_date_start', b'Nearest Event First'), ('-event_date_start', b'Furthest Away Event First')])),
            ],
        ),
        migrations.AddField(
            model_name='mediaarticle',
            name='section',
            field=models.ForeignKey(to='mediacentre.MediaSection'),
        ),
    ]
