#Django core bits
from django.shortcuts import render_to_response, get_object_or_404
from django.template import RequestContext, loader, Context
from django.contrib.auth.decorators import login_required, permission_required
from django.db.models import Q
from django.contrib.sites.models import Site
from django.conf import settings
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.contrib.auth.models import User, Group
from django.core.mail import EmailMessage
from django.contrib import messages
from datetime import datetime,date,time
from django.views.decorators.csrf import csrf_exempt

from dateutil.relativedelta import relativedelta
from calendar import *
#Others
import random,csv,string

import pdfcrowd

#Forms
from forms import *

#Models
from modules.members.models import *
from models import *

from modules.core.functions import *
from modules.core.decorators import * 

@members_only
def meeting_bookings(request):
    
    member = get_object_or_404(Member,user=request.user)
    meeting_bookings = MeetingBooking.objects.filter(member=member,status='approved').order_by('-time')
    
    return render_to_response('account/meeting-bookings.html',{'meeting_bookings':meeting_bookings},context_instance=RequestContext(request))

@members_only
def view_meeting_booking(request,booking_id):
    
    member = get_object_or_404(Member,user=request.user)
    try:
        meeting_booking = MeetingBooking.objects.get(id=booking_id,member=member,status='approved')
    except MeetingBooking.DoesNotExist:
        messages.error(request,'Sorry, that meeting booking does not exist.')
        return HttpResponseRedirect(reverse('account_meeting_bookings'))
        
    return render_to_response('account/view-booking.html',{'meeting_booking':meeting_booking},context_instance=RequestContext(request))