from django.forms import ModelForm
from django import forms
from django.contrib.auth.models import User
from models import *

#admin forms
class MeetingForm(ModelForm):

    def __init__(self,*args,**kwargs):
        super(MeetingForm,self).__init__(*args,**kwargs)
        self.fields['limit_booking_to_member_types'].help_text = 'Leave blank to allow non-members to register.'

    class Meta:
        model = Meeting
        exclude = ('slug','category','confirmation_message')

class MeetingConfirmationForm(ModelForm):

    class Meta:
        model = Meeting
        fields = ('confirmation_message',)

class MeetingDuplicateForm(ModelForm):
    class Meta:
        model = Meeting
        exclude = ('slug',)

class MeetingResourceForm(ModelForm):
    class Meta:
        model = MeetingResource
        exclude = ('meeting',)

class MeetingSessionCategoryForm(ModelForm):

    class Meta:
        model = MeetingSessionCategory
        exclude = ('meeting',)

class MeetingSessionForm(ModelForm):

    class Meta:
        model = MeetingSession
        exclude = ('meeting',)

class MeetingBookingTypeForm(ModelForm):

    def __init__(self,*args,**kwargs):
        super(MeetingBookingTypeForm,self).__init__(*args,**kwargs)
        self.fields['limit_to_member_types'].help_text = 'Leave blank to allow non-members to choose this option.'

    class Meta:
        model = MeetingBookingType
        exclude = ('meeting','enabled')


class MeetingBookingTypeCodeForm(ModelForm):

    class Meta:
        model = MeetingBookingTypeCode
        exclude = ('booking_type',)


class MeetingSocialEventForm(ModelForm):

    class Meta:
        model = MeetingSocialEvent
        exclude = ('meeting',)

class MeetingDayForm(ModelForm):

    class Meta:
        model = MeetingDay
        exclude = ('meeting',)

class MeetingBookingForm(ModelForm):

    class Meta:
        model = MeetingBooking
        fields = ('title','given_name','surname','email_address','membership_number')


class MeetingBookingInstitutionForm(ModelForm):

    def __init__(self, *args, **kwargs):
        super(MeetingBookingInstitutionForm, self).__init__(*args, **kwargs)
        self.fields['institution'].required = True
        self.fields['job_title'].required = True

    class Meta:
        model = MeetingBooking
        fields = ('institution','job_title','trust','hospital')


class MeetingBookingBadgeForm(ModelForm):

    def __init__(self, *args, **kwargs):
        super(MeetingBookingBadgeForm, self).__init__(*args, **kwargs)
        self.fields['badge_name'].required = True
        self.fields['badge_organisation'].required = True

    class Meta:
        model = MeetingBooking
        fields = ('badge_name','badge_organisation')

class MeetingBookingAddressForm(ModelForm):

    def __init__(self, *args, **kwargs):
        super(MeetingBookingAddressForm, self).__init__(*args, **kwargs)
        self.fields['address_1'].required = True
        self.fields['town'].required = True
        self.fields['country'].required = True
        self.fields['postcode'].required = True
        self.fields['dietary_requirements'].widget = forms.CheckboxSelectMultiple()
        self.fields['dietary_requirements'].required = True
        self.fields['dietary_requirements_other'].label = 'Other'
        
    class Meta:
        model = MeetingBooking
        fields = ('address_1','address_2','town','county','country','postcode','telephone','requirements', 'dietary_requirements', 'dietary_requirements_other', 'sharing')

class MeetingBookingFormEdit(ModelForm):

    def __init__(self, *args, **kwargs):
        super(MeetingBookingFormEdit, self).__init__(*args, **kwargs)
        if self.instance.registrant_type == 'member':
            self.fields['email_address'].widget.attrs['readonly'] = True

    class Meta:
        model = MeetingBooking
        fields = ('title','given_name','surname','email_address', 'badge_name', 'badge_organisation', 'type')

class MeetingBookingFormAdmin(ModelForm):

    class Meta:
        model = MeetingBooking
        fields = ('title','given_name','surname','email_address', 'badge_name', 'badge_organisation', 'type')

class MeetingBookingAddressFormAdmin(ModelForm):

    class Meta:
        model = MeetingBooking
        fields = ('institution','job_title','trust','hospital','address_1','address_2','town','county','country','postcode','telephone','requirements', 'dietary_requirements', 'dietary_requirements_other')


class MeetingBookingPaymentFormAdmin(ModelForm):

    def __init__(self,*args,**kwargs):
        super(MeetingBookingPaymentFormAdmin,self).__init__(*args,**kwargs)
        self.fields['paid'].label = 'Has been paid or is free, send the confirmation email'
    class Meta:
        model = MeetingBooking
        fields = ('paid','payment_method')


class MeetingBookingNotesFormAdmin(ModelForm):

    def __init__(self,*args,**kwargs):
        super(MeetingBookingNotesFormAdmin,self).__init__(*args,**kwargs)
        self.fields['type_code'].help_text = ''

    class Meta:
        model = MeetingBooking
        fields = ('price_paid','type_code','discount','notes')

    def clean_price_paid(self):
        price_paid = self.cleaned_data.get('price_paid')
        try:
            float(price_paid)
            return price_paid
        except:
            raise forms.ValidationError(u'Please ensure the price paid is a valid amount')


class MeetingBookingInvoiceForm(ModelForm):

    class Meta:
        model = MeetingBookingInvoice
        exclude = ('meeting_booking',)


# booking forms
class MeetingMemberBookingForm(ModelForm):

    class Meta:
        model = MeetingBooking
        fields = ('title','given_name','surname','email_address','membership_number')


class MeetingBookingDiscountForm(ModelForm):

    class Meta:
        model = MeetingBooking
        fields = ('type_code',)


class MeetingMemberBookingTypeForm(ModelForm):

    def __init__(self,*args,**kwargs):
        super(MeetingMemberBookingTypeForm,self).__init__(*args,**kwargs)
        self.fields['type'].required = True

    class Meta:
        model = MeetingBooking
        fields = ('type',)
