# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
import django.db.models.deletion
import modules.core.encryption


class Migration(migrations.Migration):

    dependencies = [
        ('resources', '0001_initial'),
        ('members', '0003_auto_20150904_1057'),
    ]

    operations = [
        migrations.CreateModel(
            name='Meeting',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=100)),
                ('slug', models.SlugField(unique=True, max_length=120)),
                ('description', models.TextField()),
                ('start_date', models.DateField(help_text=b'Date to start taking bookings from')),
                ('end_date', models.DateField(help_text=b'Last date bookings can be made')),
                ('link_to_agenda', models.CharField(max_length=200, null=True, blank=True)),
                ('link_to_agenda_file', models.FileField(null=True, upload_to=b'meetings', blank=True)),
                ('enabled', models.BooleanField(default=False)),
                ('euro_booking', models.BooleanField(default=False, verbose_name=b'Allow members to pay in Euros')),
                ('confirmation_message', models.TextField(null=True, verbose_name=b'Content for confirmation email', blank=True)),
                ('receipt_message', models.TextField(null=True, verbose_name=b'Cancellation text for receipt', blank=True)),
                ('limit_booking_to_member_types', models.ManyToManyField(to='members.MemberType', blank=True)),
            ],
        ),
        migrations.CreateModel(
            name='MeetingBooking',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('registrant_type', models.CharField(default=b'delegate', max_length=100, choices=[('member', 'Member'), ('delegate', 'Delegate')])),
                ('user_registered', models.BooleanField(default=False)),
                ('title', models.CharField(max_length=20, choices=[('Mr', 'Mr'), ('Mrs', 'Mrs'), ('Miss', 'Miss'), ('Ms', 'Ms'), ('Doctor', 'Doctor'), ('Professor', 'Professor')])),
                ('given_name', models.CharField(max_length=100, verbose_name=b'First Name')),
                ('surname', models.CharField(max_length=100)),
                ('email_address', models.CharField(max_length=200)),
                ('membership_number', models.IntegerField(null=True, blank=True)),
                ('institution', models.CharField(max_length=200, null=True, blank=True)),
                ('job_title', models.CharField(max_length=200, null=True, blank=True)),
                ('trust', models.CharField(max_length=200, null=True, blank=True)),
                ('hospital', models.CharField(max_length=200, null=True, blank=True)),
                ('address_1', modules.core.encryption.EncryptedCharField(max_length=869, null=True, blank=True)),
                ('address_2', models.CharField(max_length=200, null=True, blank=True)),
                ('town', models.CharField(max_length=200, null=True, blank=True)),
                ('county', models.CharField(max_length=200, null=True, blank=True)),
                ('postcode', modules.core.encryption.EncryptedCharField(max_length=165, null=True, blank=True)),
                ('telephone', models.CharField(max_length=40, null=True, verbose_name=b'Phone Number', blank=True)),
                ('requirements', models.TextField(help_text=b'Please complete this box if you have any special requirements for your booking, for example dietary requirements or health requirements.', null=True, blank=True)),
                ('price_paid', models.CharField(default=0, max_length=200)),
                ('payment_method', models.CharField(max_length=200, null=True, blank=True)),
                ('currency', models.CharField(default=b'GBP', max_length=10, choices=[('GBP', 'Pounds (&pound;)'), ('EUR', 'Euros (&euro;)')])),
                ('type_name', models.CharField(max_length=200, null=True, blank=True)),
                ('type_price', models.FloatField(default=0, null=True, blank=True)),
                ('time', models.DateTimeField(auto_now_add=True)),
                ('status', models.CharField(default=b'pending', max_length=200, choices=[('pending', b'Pending'), ('approved', b'Approved'), ('rejected', b'Rejected')])),
                ('invoiced', models.BooleanField(default=False)),
                ('paid', models.BooleanField(default=False)),
                ('complete', models.BooleanField(default=False)),
                ('unique_key', models.CharField(max_length=100, null=True, blank=True)),
                ('notes', models.TextField(null=True, blank=True)),
                ('country', models.ForeignKey(related_name='booking_country', blank=True, to='members.Country', null=True)),
                ('meeting', models.ForeignKey(to='meeting_booking.Meeting')),
                ('member', models.ForeignKey(blank=True, to='members.Member', null=True)),
            ],
        ),
        migrations.CreateModel(
            name='MeetingBookingInvoice',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('organisation_name', models.CharField(max_length=200)),
                ('address_1', models.CharField(max_length=200)),
                ('address_2', models.CharField(max_length=200, null=True, blank=True)),
                ('address_3', models.CharField(max_length=200, null=True, blank=True)),
                ('town', models.CharField(max_length=200)),
                ('postcode', models.CharField(max_length=20)),
                ('po_number', models.CharField(max_length=100, verbose_name=b'Purchase Order Number / Contact Name')),
                ('email_address', models.CharField(max_length=100)),
                ('telephone', models.CharField(max_length=20)),
                ('country', models.ForeignKey(related_name='invoice_country', to='members.Country')),
                ('meeting_booking', models.ForeignKey(to='meeting_booking.MeetingBooking')),
            ],
        ),
        migrations.CreateModel(
            name='MeetingBookingType',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('cost', models.FloatField(default=0, verbose_name=b'Cost (GBP)')),
                ('cost_eur', models.FloatField(default=0, null=True, verbose_name=b'Cost (EUR)', blank=True)),
                ('early_bird_date', models.DateField(help_text=b'Last date which early bird rate can be purchased.', null=True, blank=True)),
                ('early_bird_cost', models.FloatField(null=True, verbose_name=b'Early Bird Cost (GBP)', blank=True)),
                ('early_bird_cost_eur', models.FloatField(null=True, verbose_name=b'Early Bird Cost (EUR)', blank=True)),
                ('text', models.TextField(help_text=b'Text that shows when this option is selected.', null=True, blank=True)),
                ('order', models.IntegerField()),
                ('meeting_days_generate', models.BooleanField(default=False, verbose_name=b'Show Day options for this meeting booking')),
                ('enabled', models.BooleanField(default=True)),
                ('guests_only', models.BooleanField(default=False, help_text=b'Tick to limit booking to non-members only')),
                ('limit_to_member_types', models.ManyToManyField(help_text=b'Leave blank to allow non-members to choose this option.', to='members.MemberType', blank=True)),
                ('meeting', models.ForeignKey(to='meeting_booking.Meeting')),
            ],
            options={
                'ordering': ['meeting', 'order'],
            },
        ),
        migrations.CreateModel(
            name='MeetingDay',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=100)),
                ('order', models.IntegerField()),
                ('cost', models.FloatField(verbose_name=b'Cost (GBP)')),
                ('cost_eur', models.FloatField(default=0, null=True, verbose_name=b'Cost (EUR)', blank=True)),
                ('cost_member', models.FloatField(null=True, verbose_name=b'Cost for members (GBP)', blank=True)),
                ('cost_member_eur', models.FloatField(null=True, verbose_name=b'Cost for members (EUR)', blank=True)),
                ('early_bird_date', models.DateField(help_text=b'Last date which early bird rate can be purchased.', null=True, blank=True)),
                ('early_bird_cost', models.FloatField(null=True, verbose_name=b'Early Bird Cost (GBP)', blank=True)),
                ('early_bird_cost_eur', models.FloatField(null=True, verbose_name=b'Early Bird Cost (EUR)', blank=True)),
                ('early_bird_member_cost', models.FloatField(null=True, verbose_name=b'Early Bird Member Cost (GBP)', blank=True)),
                ('early_bird_member_cost_eur', models.FloatField(null=True, verbose_name=b'Early Bird Member Cost (EUR)', blank=True)),
                ('meeting', models.ForeignKey(to='meeting_booking.Meeting')),
            ],
        ),
        migrations.CreateModel(
            name='MeetingDayBooking',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('meeting_day_name', models.CharField(max_length=100)),
                ('price_paid', models.FloatField()),
                ('meeting_booking', models.ForeignKey(to='meeting_booking.MeetingBooking')),
                ('meeting_day', models.ForeignKey(on_delete=django.db.models.deletion.SET_NULL, blank=True, to='meeting_booking.MeetingDay', null=True)),
            ],
        ),
        migrations.CreateModel(
            name='MeetingResource',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=150)),
                ('order', models.IntegerField()),
                ('meeting', models.ForeignKey(to='meeting_booking.Meeting')),
                ('resource', models.ForeignKey(to='resources.Resource')),
            ],
        ),
        migrations.CreateModel(
            name='MeetingSession',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=100)),
                ('description', models.TextField()),
                ('order', models.IntegerField()),
                ('quantity_available', models.IntegerField()),
                ('bookable', models.BooleanField(default=True)),
                ('cost', models.FloatField(default=0, verbose_name=b'Price (GBP)')),
                ('cost_eur', models.FloatField(default=0, verbose_name=b'Price (EUR)')),
                ('meeting', models.ForeignKey(to='meeting_booking.Meeting')),
            ],
        ),
        migrations.CreateModel(
            name='MeetingSessionBooking',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('session_name', models.CharField(max_length=200)),
                ('waiting_list', models.BooleanField(default=False)),
                ('price_paid', models.FloatField(default=0)),
                ('meeting_booking', models.ForeignKey(to='meeting_booking.MeetingBooking')),
                ('session', models.ForeignKey(on_delete=django.db.models.deletion.SET_NULL, blank=True, to='meeting_booking.MeetingSession', null=True)),
            ],
        ),
        migrations.CreateModel(
            name='MeetingSessionCategory',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('order', models.IntegerField()),
                ('only_one', models.BooleanField(default=False, verbose_name=b'Limit session so that only one can be booked')),
                ('meeting', models.ForeignKey(to='meeting_booking.Meeting')),
            ],
        ),
        migrations.CreateModel(
            name='MeetingSocialEvent',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=100)),
                ('max_quantity', models.IntegerField(verbose_name=b'Max Quantity Per Booking')),
                ('order', models.IntegerField()),
                ('cost', models.FloatField(verbose_name=b'Cost (GBP)')),
                ('cost_eur', models.FloatField(null=True, verbose_name=b'Cost (EUR)', blank=True)),
                ('enabled', models.BooleanField(default=False)),
                ('day_bookings_only', models.BooleanField(default=False)),
                ('meeting', models.ForeignKey(to='meeting_booking.Meeting')),
            ],
        ),
        migrations.CreateModel(
            name='MeetingSocialEventBooking',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('social_event_name', models.CharField(max_length=100)),
                ('quantity', models.IntegerField()),
                ('price_paid', models.FloatField()),
                ('meeting_booking', models.ForeignKey(to='meeting_booking.MeetingBooking')),
                ('social_event', models.ForeignKey(on_delete=django.db.models.deletion.SET_NULL, blank=True, to='meeting_booking.MeetingSocialEvent', null=True)),
            ],
        ),
        migrations.AddField(
            model_name='meetingsession',
            name='session_category',
            field=models.ForeignKey(to='meeting_booking.MeetingSessionCategory'),
        ),
        migrations.AddField(
            model_name='meetingbooking',
            name='type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.SET_NULL, blank=True, to='meeting_booking.MeetingBookingType', null=True),
        ),
    ]
