#Django core bits
from django.shortcuts import render_to_response, get_object_or_404
from django.template import RequestContext, loader, Context
from django.contrib.auth.decorators import login_required, permission_required
from django.db.models import Q
from django.contrib.sites.models import Site
from django.conf import settings
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.contrib.auth.models import User, Group
from django.contrib import messages
from django.template.defaultfilters import slugify
from datetime import datetime, date, time
from itertools import chain
import cPickle
import base64

import pdfcrowd

from django.views.decorators.csrf import csrf_exempt

from modules.core.decorators import *
from modules.core.functions import *
from modules.members.functions import *
from modules.payments.functions import *

from signals import *

#Forms
from forms import *
from modules.members.forms import *

#Models
from models import *
from modules.resources.models import *
from modules.members.models import *
from modules.payments.models import *

from paypal.standard.forms import PayPalEncryptedPaymentsForm, PayPalPaymentsForm

def get_access(request,meeting):

    allowed = True
    today = date.today()

    if not meeting.enabled:
        return False

    if meeting.start_date and today < meeting.start_date:
        return False

    if meeting.end_date and today > meeting.end_date:
        return False

    if meeting.limit_booking_to_member_types.all():
        if request.user.is_authenticated():
            try:
                member = Member.objects.get(user=request.user, user_type='member', member_status='current')
                if not member.member_type in meeting.limit_booking_to_member_types.all():
                    allowed = False
            except:
                if not request.user.is_superuser:
                    allowed = False
        else:
            allowed = False

    return allowed

#1st step of meeting booking
def meeting(request,meeting_slug):

    meeting = get_object_or_404(Meeting,slug=meeting_slug)

    try:
        current_member = Member.objects.get(user=request.user)
    except:
        current_member = False

    if not get_access(request,meeting):
        return HttpResponseRedirect(reverse('meeting_booking_denied',args=[meeting.slug]))

    meeting_booking = False

    if request.session.get('meeting_booking_key',False):
        try:
            meeting_booking = MeetingBooking.objects.get(unique_key=request.session['meeting_booking_key'])
            booking_form = MeetingBookingForm(instance=meeting_booking)
        except:
            pass
    if not meeting_booking:
        try:
            member = Member.objects.get(user=request.user)
            booking_form = MeetingBookingForm(initial={'title':member.title,'surname':member.surname,'given_name':member.given_name,'email_address':member.user.email,'membership_number':member.membership_number})
        except:
            member = False
            booking_form = MeetingBookingForm()

    if request.POST:

        booking_form = MeetingBookingForm(request.POST)

        if booking_form.is_valid():
            try:
                meeting_booking = MeetingBooking.objects.get(meeting=meeting,email_address=request.POST['email_address'],complete=True)
                messages.error(request,'Sorry, you have already booked onto this meeting')
            except MeetingBooking.DoesNotExist:

                meeting_bookings = MeetingBooking.objects.filter(meeting=meeting,email_address=request.POST['email_address'],complete=False)
                for meeting_booking in meeting_bookings:
                    meeting_booking.delete()

                meeting_booking = booking_form.save(commit=False)
                meeting_booking.unique_key = random_string_unique(100,MeetingBooking,'unique_key')
                meeting_booking.meeting = meeting

                if current_member:
                    meeting_booking.member = current_member
                    meeting_booking.registrant_type = 'delegate'
                    if current_member.is_current():
                        meeting_booking.registrant_type = 'member'
                    meeting_booking.job_title = current_member.job_title
                    meeting_booking.hospital = current_member.hospital
                    meeting_booking.address_1 = current_member.address_1
                    meeting_booking.address_2 = current_member.address_2
                    meeting_booking.town = current_member.town
                    meeting_booking.county = current_member.county
                    meeting_booking.country = current_member.country
                    meeting_booking.postcode = current_member.postcode
                    meeting_booking.telephone = current_member.telephone
                    meeting_booking.save()

                else:
                    if request.POST.get('membership_number'):
                        try:
                            booking_member = Member.objects.get(membership_number=meeting_booking.membership_number,surname=meeting_booking.surname)
                        except Member.DoesNotExist:
                            try:
                                booking_member = Member.objects.get(user__email=meeting_booking.email_address)
                            except:
                                messages.warning(request,'A Member could not be found with the details you provided. You will be registered for this meeting as a Non-Member, if this is incorrect, please <a href="%s">Restart your booking</a> and try again.' % (reverse('meeting_booking_meeting',args=[meeting.slug])))
                                booking_member = False
                    else:
                        try:
                            booking_member = Member.objects.get(user__email=meeting_booking.email_address)
                        except:
                            booking_member = False

                    if booking_member:
                        meeting_booking.member = booking_member
                        meeting_booking.registrant_type = 'delegate'
                        meeting_booking.job_title = booking_member.job_title
                        meeting_booking.hospital = booking_member.hospital
                        meeting_booking.address_1 = booking_member.address_1
                        meeting_booking.address_2 = booking_member.address_2
                        meeting_booking.town = booking_member.town
                        meeting_booking.county = booking_member.county
                        meeting_booking.country = booking_member.country
                        meeting_booking.postcode = booking_member.postcode
                        meeting_booking.telephone = booking_member.telephone

                        if booking_member.is_current():
                            meeting_booking.registrant_type = 'member'

                        meeting_booking.save()

                    else:

                        #new delegate
                        new_user = False
                        try:
                            user = User.objects.get(username=meeting_booking.email_address)
                        except User.DoesNotExist:
                            user = User(email=meeting_booking.email_address,first_name=meeting_booking.given_name,last_name=meeting_booking.surname)
                            user.username = random_string_unique(20,User,'username')
                            password = generate_random_password(10)
                            user.set_password(password)
                            user.save()
                            new_user = True

                        delegate = Member(user=user,user_type='non-member',given_name = meeting_booking.given_name,surname=meeting_booking.surname,title=meeting_booking.title)
                        if new_user:
                            delegate.raw_password = password
                        delegate.membership_number = get_next_membership_number()
                        delegate.save()

                        meeting_booking.member = delegate
                        meeting_booking.registrant_type = 'delegate'
                        meeting_booking.user_registered = new_user
                        meeting_booking.save()


                request.session['meeting_booking_key'] = meeting_booking.unique_key

                return HttpResponseRedirect(reverse('meeting_booking_details',args=[meeting.slug]))

    return render_to_response('public/meeting_booking.html',{'meeting':meeting,'booking_form':booking_form},context_instance=RequestContext(request))

def meeting_denied(request,meeting_slug):

    meeting = get_object_or_404(Meeting,slug=meeting_slug)

    return render_to_response('public/access_denied.html',{'meeting':meeting},context_instance=RequestContext(request))

def details(request,meeting_slug):

    meeting = get_object_or_404(Meeting,slug=meeting_slug)

    if not get_access(request,meeting):
        return HttpResponseRedirect(reverse('meetings_access_denied',args=[meeting.slug]))

    if request.session.get('meeting_booking_key', False):
        meeting_booking = get_object_or_404(MeetingBooking,unique_key=request.session['meeting_booking_key'])
        if meeting_booking.complete:
            del request.session['meeting_booking_key']
            messages.error(request,'Sorry, you have already registered for this meeting')
            return HttpResponseRedirect(reverse('meeting_booking_meeting',args=[meeting.slug]))
    else:
        messages.error(request,'You have not started your booking yet')
        return HttpResponseRedirect(reverse('meeting_booking_meeting',args=[meeting.slug]))

    member = meeting_booking.member

    meeting_booking_institution_form = MeetingBookingInstitutionForm(instance=meeting_booking)
    meeting_booking_badge_form = MeetingBookingBadgeForm(instance=meeting_booking)
    meeting_booking_address_form = MeetingBookingAddressForm(instance=meeting_booking)

    try:
        country = MemberCountry.objects.get(name='United Kingdon')
    except:
        country = False

    if request.POST:

        meeting_booking_institution_form = MeetingBookingInstitutionForm(request.POST, instance=meeting_booking)
        meeting_booking_badge_form = MeetingBookingBadgeForm(request.POST, instance=meeting_booking)
        meeting_booking_address_form = MeetingBookingAddressForm(request.POST,instance=meeting_booking)

        if meeting_booking_institution_form.is_valid() and meeting_booking_badge_form.is_valid() and meeting_booking_address_form.is_valid():

            meeting_booking_institution_form.save()
            meeting_booking_badge_form.save()
            meeting_booking_address_form.save()

            if not meeting_booking.member.address_1:
                meeting_booking.member.job_title = meeting_booking.job_title
                meeting_booking.member.hospital = meeting_booking.hospital
                meeting_booking.member.address_1 = meeting_booking.address_1
                meeting_booking.member.address_2 = meeting_booking.address_2
                meeting_booking.member.town = meeting_booking.town
                meeting_booking.member.county = meeting_booking.county
                meeting_booking.member.country = meeting_booking.country
                meeting_booking.member.postcode = meeting_booking.postcode
                meeting_booking.member.telephone = meeting_booking.telephone
                meeting_booking.member.save()

            messages.success(request,'Your details have been saved')

            return HttpResponseRedirect(reverse('meeting_booking_tickets',args=[meeting.slug]))

    return render_to_response('public/details.html',{'meeting':meeting,'meeting_booking':meeting_booking,'meeting_booking_institution_form':meeting_booking_institution_form, 'meeting_booking_badge_form': meeting_booking_badge_form, 'meeting_booking_address_form':meeting_booking_address_form},context_instance=RequestContext(request))


def tickets(request,meeting_slug):

    meeting = get_object_or_404(Meeting,slug=meeting_slug)

    if not get_access(request,meeting):
        return HttpResponseRedirect(reverse('meeting_booking_denied',args=[meeting.slug]))

    if request.session.get('meeting_booking_key', False):
        meeting_booking = get_object_or_404(MeetingBooking,unique_key=request.session['meeting_booking_key'])
        if meeting_booking.complete:
            del request.session['meeting_booking_key']
            messages.error(request,'Sorry, you have already registered for this meeting')
            return HttpResponseRedirect(reverse('meeting_booking_meeting',args=[meeting.slug]))
    else:
        return HttpResponseRedirect(reverse('meeting_booking_meeting',args=[meeting.slug]))

    if meeting_booking.registrant_type == 'member':
        types = MeetingBookingType.objects.filter(Q(limit_to_member_types__isnull=True) | Q(limit_to_member_types=meeting_booking.member.member_type),guests_only=False,meeting=meeting,enabled=True).order_by('order')
    else:
        types = MeetingBookingType.objects.filter(meeting=meeting,limit_to_member_types__isnull=True, enabled=True).order_by('order')

    meeting_booking_discount_form = MeetingBookingDiscountForm(instance=meeting_booking)
    meeting_days = MeetingDay.objects.filter(meeting=meeting).order_by('order')
    social_events = MeetingSocialEvent.objects.filter(meeting=meeting,day_bookings_only=False,enabled=True).order_by('order')
    social_events_days = MeetingSocialEvent.objects.filter(meeting=meeting,day_bookings_only=True,enabled=True).order_by('order')

    if request.POST:

        meeting_booking_discount_form = MeetingBookingDiscountForm(request.POST,instance=meeting_booking)

        errors = False

        if not request.POST.get('type'):
            messages.error(request,'Please select a Registration Fee')
            errors = True
        else:

            day_bookings = MeetingDayBooking.objects.filter(meeting_booking=meeting_booking)
            for day_booking in day_bookings:
                day_booking.delete()

            social_bookings = MeetingSocialEventBooking.objects.filter(meeting_booking=meeting_booking)
            for social_booking in social_bookings:
                social_booking.delete()

            try:
                meeting_booking_type = MeetingBookingType.objects.get(id=request.POST['type'])
                meeting_booking.type = meeting_booking_type
                meeting_booking.type_name = meeting_booking_type.name
                meeting_booking.type_price = meeting_booking_type.get_cost()
                meeting_booking.save()
            except:
                messages.error(request,'Could not save booking type')
                errors = True

            meeting_booking.type_code = ''
            meeting_booking.discount = 0
            meeting_booking.save()

            if meeting_booking_discount_form.is_valid():

                posted_code = meeting_booking_discount_form.cleaned_data['type_code']
                if posted_code:
                    try:
                        mb_type_code = MeetingBookingTypeCode.objects.get(code=posted_code,booking_type=meeting_booking.type,enabled=True)
                        meeting_booking.type_code = mb_type_code.code
                        meeting_booking.discount = mb_type_code.amount
                        meeting_booking.save()

                        messages.success(request,'Your discount code has been applied.')

                    except:
                        messages.warning(request,'Sorry, we could not match a Discount code with the information you supplied, please try again.')
                        errors = True

            if meeting_booking.type.meeting_days_generate:
                if not request.POST.get('meeting_days'):
                    messages.error(request,'Please select a Day you wish to Book')
                    errors = True

            if not errors:
                if meeting_booking.type.meeting_days_generate:
                    if request.POST.get('meeting_days'):
                        posted_days = request.POST.getlist('meeting_days')

                        for day in posted_days:
                            try:
                                meeting_day = MeetingDay.objects.get(id=day)

                                if meeting_booking.registrant_type == 'member':
                                    price_paid = meeting_day.get_member_cost()
                                else:
                                    price_paid = meeting_day.get_cost()

                                meeting_day_booking = MeetingDayBooking(meeting_booking=meeting_booking,meeting_day=meeting_day,meeting_day_name=meeting_day.name,price_paid=price_paid)
                                meeting_day_booking.save()
                            except:
                                pass

                social_event_bookings = []
                if request.POST.get('social_events'):
                    posted_social_events = request.POST.getlist('social_events')

                    for social_event_id in posted_social_events:
                        try:
                            social_event = MeetingSocialEvent.objects.get(id=social_event_id)
                            quantity = request.POST.get("social_event_quantity_%s" % (social_event_id))

                            if quantity:
                                social_event_booking = MeetingSocialEventBooking(meeting_booking=meeting_booking,social_event=social_event,social_event_name=social_event.name,quantity=quantity)
                                social_event_booking.price_paid = social_event.cost
                                social_event_booking.save()

                        except MeetingSocialEvent.DoesNotExist:
                            pass

                messages.success(request,'Your Registration Fee details have been saved.')

                if meeting.get_sessions():
                    return HttpResponseRedirect(reverse('meeting_booking_sessions',args=[meeting.slug]))
                else:
                    return HttpResponseRedirect(reverse('meeting_booking_payment',args=[meeting.slug]))

    return render_to_response('public/tickets.html',{'meeting':meeting,'meeting_booking':meeting_booking,'types':types, 'meeting_booking_discount_form':meeting_booking_discount_form, 'meeting_days':meeting_days,'social_events':social_events,'social_events_days':social_events_days},context_instance=RequestContext(request))

def sessions(request,meeting_slug):

    meeting = get_object_or_404(Meeting,slug=meeting_slug)

    if not get_access(request,meeting):
        return HttpResponseRedirect(reverse('meeting_booking_denied',args=[meeting.slug]))

    if request.session.get('meeting_booking_key', False):
        meeting_booking = get_object_or_404(MeetingBooking,unique_key=request.session['meeting_booking_key'])
        if not meeting_booking.type:
            return HttpResponseRedirect(reverse('meeting_booking_tickets',args=[meeting.slug]))

        if meeting_booking.complete:
            del request.session['meeting_booking_key']
            messages.error(request,'Sorry, you have already registered for this meeting')
            return HttpResponseRedirect(reverse('meeting_booking_meeting',args=[meeting.slug]))

    else:
        return HttpResponseRedirect(reverse('meeting_booking_meeting',args=[meeting.slug]))

    session_categories = MeetingSessionCategory.objects.filter(meeting=meeting).order_by('order')
    sessions = MeetingSession.objects.filter(meeting=meeting).order_by('order')
    if not sessions:
        return HttpResponseRedirect(reverse('meeting_booking_payment',args=[meeting.slug]))
    session_bookings = MeetingSessionBooking.objects.filter(meeting_booking=meeting_booking)
    sessions_booked = []
    for session_booking in session_bookings:
        sessions_booked.append(session_booking.session)

    if request.POST:

        for session_booking in session_bookings:
            session_booking.delete()

        posted_sessions = request.POST.getlist('sessions')

        errors = []
        session_errors = []

        for category in session_categories:

            if category.only_one:
                if request.POST.get('session_category_%s' % (category.id)):

                    #try:
                    posted_session = request.POST['session_category_%s' % (category.id)]
                    if posted_session != 'not':
                        session = MeetingSession.objects.get(id=posted_session)

                        session_booking = MeetingSessionBooking(meeting_booking=meeting_booking,session=session,session_name=session.name)
                        session_booking.price_paid = session.cost
                        session_booking.save()

                    #except:
                    #    errors = True
                else:
                    session_errors.append('Please select an option for <strong>%s</strong>' % (category))

            else:
                for session in category.get_sessions():
                    if str(session.id) in posted_sessions:
                        try:
                            session_booking = MeetingSessionBooking(meeting_booking=meeting_booking,session=session,session_name=session.name)
                            session_booking.price_paid = session.cost
                            session_booking.save()
                        except:
                            errors = True

        session_bookings = MeetingSessionBooking.objects.filter(meeting_booking=meeting_booking)
        sessions_booked = []
        for session_booking in session_bookings:
            sessions_booked.append(session_booking.session)

        if errors:
            messages.error(request,'Sorry, could not save the sessions, please try again')
        elif session_errors:
            for session_error in session_errors:
                messages.error(request,session_error)
        else:
            #redirect view
            messages.success(request,'Your session information has been saved.')
            return HttpResponseRedirect(reverse('meeting_booking_payment',args=[meeting.slug]))

    return render_to_response('public/sessions.html',{'meeting':meeting,'meeting_booking':meeting_booking,'session_categories':session_categories,'sessions':sessions,'session_bookings':session_bookings,'sessions_booked':sessions_booked},context_instance=RequestContext(request))

def payment(request,meeting_slug):

    meeting = get_object_or_404(Meeting,slug=meeting_slug)

    if not get_access(request,meeting):
        return HttpResponseRedirect(reverse('meetings_access_denied',args=[meeting.slug]))

    if request.session.get('meeting_booking_key', False):
        meeting_booking = get_object_or_404(MeetingBooking,unique_key=request.session['meeting_booking_key'])
        if not meeting_booking.type:
            return HttpResponseRedirect(reverse('meeting_booking_tickets',args=[meeting.slug]))

        if meeting_booking.complete:
            del request.session['meeting_booking_key']
            messages.error(request,'Sorry, you have already registered for this meeting')
            return HttpResponseRedirect(reverse('meeting_booking_meeting',args=[meeting.slug]))

    else:
        return HttpResponseRedirect(reverse('meeting_booking_meeting',args=[meeting.slug]))

    meeting_booking_days = MeetingDayBooking.objects.filter(meeting_booking=meeting_booking).order_by('meeting_day__order')
    sessions = MeetingSessionBooking.objects.filter(meeting_booking=meeting_booking,waiting_list=False)
    waiting_list_sessions = MeetingSessionBooking.objects.filter(meeting_booking=meeting_booking,waiting_list=True)
    social_events = MeetingSocialEventBooking.objects.filter(meeting_booking=meeting_booking)

    total_cost = meeting_booking.get_total()

    payment = Payment(member=meeting_booking.member,type='meeting-booking',meeting_booking=meeting_booking)
    payment.save()


    if settings.DEVELOPMENT:
        payment.invoice = "Meeting_Payment_%sD_PSGBI" % (payment.id)
    else :
        payment.invoice = "Meeting_Payment_%s" % (payment.id)

    payment.save()

    #take to page with paypal button

    image = """%simages/pay-online.jpg""" % (settings.STATIC_URL)

    # What you want the button to do.

    paypal_dict = {
        "image": image,
        "business": settings.PAYPAL_RECEIVER_EMAIL,
        "amount": total_cost,
        "custom": "meeting",
        "item_name": '%s Meeting Booking - %s' % (settings.WEBSITE_NAME,meeting.name),
        "currency_code": 'GBP',
        "invoice": payment.invoice,
        "notify_url": "%s%s" % (settings.MEETING_URL, reverse('paypal-ipn')),
        "return_url": "%s%s" % (settings.MEETING_URL, reverse('meeting_booking_payment_complete',args=[meeting.slug])),
        "cancel_return": "%s%s" % (settings.MEETING_URL, reverse('meeting_booking_payment_failure',args=[meeting.slug])),
    }

    if settings.DEVELOPMENT:
        paypal_form = PayPalPaymentsForm(initial=paypal_dict)
    else:
        paypal_form = PayPalEncryptedPaymentsForm(initial=paypal_dict)

    return render_to_response('public/payment.html',{'meeting':meeting,'meeting_booking':meeting_booking,'meeting_booking_days':meeting_booking_days,'sessions':sessions,'waiting_list_sessions':waiting_list_sessions,'social_events':social_events,'total_cost':total_cost,'paypal_form':paypal_form},context_instance=RequestContext(request))

@csrf_exempt
def payment_complete(request,meeting_slug):

    meeting = get_object_or_404(Meeting,slug=meeting_slug)
    try:
        content_block = ContentBlock.objects.get(slug='meeting-payment-complete')
    except:
        content_block = False

    if request.session.get('meeting_booking_key', False):
        meeting_booking = get_object_or_404(MeetingBooking,unique_key=request.session['meeting_booking_key'])

        if meeting_booking.get_total() == 0:
            if not meeting_booking.type:
                return HttpResponseRedirect(reverse('meeting_booking_tickets',args=[meeting.slug]))
            else:
                meeting_booking.complete = True
                meeting_booking.paid = True
                meeting_booking.price_paid = 0
                meeting_booking.save()

                #emails need to go here
                meeting_booking_confirmation_email.send(sender=None, meeting_booking=meeting_booking,receipt=False)

    if request.session.get('meeting_booking_key',False):
        del request.session['meeting_booking_key']

    return render_to_response('public/payment_complete.html',{'meeting':meeting,'content_block':content_block},context_instance=RequestContext(request))


def payment_failure(request,meeting_slug):

    meeting = get_object_or_404(Meeting,slug=meeting_slug)
    try:
        content_block = ContentBlock.objects.get(slug='meeting-payment-failure')
    except:
        content_block = False

    messages.error(request,'Sorry, your payment could not be taken at this time. If you wish to retry your payment, please click below.')
    return HttpResponseRedirect(reverse('meeting_booking_payment',args=[meeting.slug]))


def invoice(request,meeting_slug):

    raise Http404

    meeting = get_object_or_404(Meeting,slug=meeting_slug)

    if not get_access(request,meeting):
        return HttpResponseRedirect(reverse('meetings_access_denied',args=[meeting.slug]))

    if request.session.get('meeting_booking_key', False):
        meeting_booking = get_object_or_404(MeetingBooking,unique_key=request.session['meeting_booking_key'])
        if not meeting_booking.type:
            return HttpResponseRedirect(reverse('meeting_booking_tickets',args=[meeting.slug]))

        if meeting_booking.complete:
            del request.session['meeting_booking_key']
            messages.error(request,'Sorry, you have already registered for this meeting')
            return HttpResponseRedirect(reverse('meeting_booking_meeting',args=[meeting.slug]))

    else:
        return HttpResponseRedirect(reverse('meeting_booking_meeting',args=[meeting.slug]))

    invoice_form = MeetingBookingInvoiceForm()

    if request.POST:
        invoice_form = MeetingBookingInvoiceForm(request.POST)

        if invoice_form.is_valid():

            meeting_booking_invoice = invoice_form.save(commit=False)
            meeting_booking_invoice.meeting_booking = meeting_booking
            meeting_booking_invoice.save()

            meeting_booking.complete = True
            meeting_booking.price_paid = meeting_booking.get_total()
            meeting_booking.save()

            meeting_booking_invoice_email.send(sender=None, request=request, meeting_booking=meeting_booking)

            return HttpResponseRedirect(reverse('meeting_booking_invoice_complete',args=[meeting_slug]))

    return render_to_response('public/invoice.html',{'meeting':meeting,'meeting_booking':meeting_booking,'invoice_form':invoice_form},context_instance=RequestContext(request))

@csrf_exempt
def invoice_complete(request,meeting_slug):

    meeting = get_object_or_404(Meeting,slug=meeting_slug)
    try:
        content_block = ContentBlock.objects.get(slug='meeting-invoice-complete')
    except:
        content_block = False

    if not get_access(request,meeting):
        return HttpResponseRedirect(reverse('meetings_access_denied',args=[meeting.slug]))

    return render_to_response('public/invoice_complete.html',{'meeting':meeting,'content_block':content_block},context_instance=RequestContext(request))
