from django.conf.urls import *

urlpatterns = patterns('',

    ##########BIOS##########
    url(r'^bios/$', 'modules.meeting_information.adminviews.bios', name='admin_meeting_information_bios'),
    url(r'^bios/add/$', 'modules.meeting_information.adminviews.add_bio', name='admin_meeting_information_add_bio'),
    url(r'^bios/invite/$', 'modules.meeting_information.adminviews.invite_bios', name='admin_meeting_information_invite_bios'),
    url(r'^bios/(?P<bio_id>[-\d]+)/edit/$', 'modules.meeting_information.adminviews.edit_bio', name='admin_meeting_information_edit_bio'),
    url(r'^bios/(?P<bio_id>[-\d]+)/delete/$', 'modules.meeting_information.adminviews.delete_bio', name='admin_meeting_information_delete_bio'),
    url(r'^bios/(?P<bio_id>[-\d]+)/resend/$', 'modules.meeting_information.adminviews.resend_bio', name='admin_meeting_information_resend_bio'),

    ##########MEETING INFO##########
    url(r'^$','modules.meeting_information.adminviews.meetings',name='admin_meeting_information'),
    url(r'^add/$','modules.meeting_information.adminviews.add_meeting',name='admin_meeting_information_add'),
    url(r'^(?P<meeting_id>[-\d]+)/edit/$','modules.meeting_information.adminviews.edit_meeting',name='admin_meeting_information_edit'),
    url(r'^(?P<meeting_id>[-\d]+)/splash/$','modules.meeting_information.adminviews.splash_page',name='admin_meeting_information_splash_page'),
    url(r'^(?P<meeting_id>[-\d]+)/duplicate/$','modules.meeting_information.adminviews.duplicate_meeting',name='admin_meeting_information_duplicate'),
    url(r'^(?P<meeting_id>[-\d]+)/delete/$','modules.meeting_information.adminviews.delete_meeting',name='admin_meeting_information_delete'),
    url(r'^(?P<meeting_id>[-\d]+)/enable/$','modules.meeting_information.adminviews.enable_meeting',name='admin_meeting_information_enable'),
    url(r'^(?P<meeting_id>[-\d]+)/disable/$','modules.meeting_information.adminviews.disable_meeting',name='admin_meeting_information_disable'),

    url(r'^(?P<meeting_id>[-\d]+)/pdf/$','modules.meeting_information.adminviews.pdf',name='admin_meeting_information_pdf'),
    url(r'^(?P<meeting_id>[-\d]+)/download-pdf/$','modules.meeting_information.adminviews.download_pdf',name='admin_meeting_information_download_pdf'),
    url(r'^(?P<meeting_id>[-\d]+)/download-csv/$','modules.meeting_information.adminviews.download_csv',name='admin_meeting_information_download_csv'),

    url(r'^(?P<meeting_id>[-\d]+)/links/$', 'modules.meeting_information.adminviews.links', name='admin_meeting_information_links'),
    url(r'^(?P<meeting_id>[-\d]+)/links/add/$', 'modules.meeting_information.adminviews.add_link', name='admin_meeting_information_links_add'),
    url(r'^(?P<meeting_id>[-\d]+)/links/(?P<link_id>[-\d]+)/edit/$', 'modules.meeting_information.adminviews.edit_link', name='admin_meeting_information_links_edit'),
    url(r'^(?P<meeting_id>[-\d]+)/links/(?P<link_id>[-\d]+)/delete/$', 'modules.meeting_information.adminviews.delete_link', name='admin_meeting_information_links_delete'),

    #pages
    url(r'^(?P<meeting_id>[-\d]+)/pages/$', 'modules.meeting_information.adminviews.pages', name='admin_meeting_information_pages'),
    url(r'^(?P<meeting_id>[-\d]+)/pages/add/$', 'modules.meeting_information.adminviews.add_page', name='admin_meeting_information_pages_add'),
    url(r'^(?P<meeting_id>[-\d]+)/pages/import/$','modules.meeting_information.adminviews.import_page',name='admin_meeting_information_pages_import'),
    url(r'^(?P<meeting_id>[-\d]+)/pages/(?P<page_id>[-\d]+)/edit/$', 'modules.meeting_information.adminviews.edit_page', name='admin_meeting_information_pages_edit'),
    url(r'^(?P<meeting_id>[-\d]+)/pages/(?P<page_id>[-\w]+)/delete/$', 'modules.meeting_information.adminviews.delete_page', name='admin_meeting_information_pages_delete'),

    url(r'^(?P<meeting_id>[-\d]+)/pages/(?P<page_id>[-\d]+)/resources/$', 'modules.meeting_information.adminviews.page_resources', name='admin_meeting_information_resources'),
    url(r'^(?P<meeting_id>[-\d]+)/pages/(?P<page_id>[-\d]+)/resources/add/$', 'modules.meeting_information.adminviews.add_resource_page', name='admin_meeting_information_add_resource'),
    url(r'^(?P<meeting_id>[-\d]+)/pages/(?P<page_id>[-\d]+)/resources/(?P<resource_id>[-\d]+)/edit/$', 'modules.meeting_information.adminviews.edit_resource_page', name='admin_meeting_information_edit_resource'),
    url(r'^(?P<meeting_id>[-\d]+)/pages/(?P<page_id>[-\d]+)/resources/(?P<resource_id>[-\d]+)/delete/$', 'modules.meeting_information.adminviews.delete_resource_page', name='admin_meeting_information_delete_resource'),

    #bio pages
    url(r'^(?P<meeting_id>[-\d]+)/bio-pages/$', 'modules.meeting_information.adminviews.bio_pages', name='admin_meeting_information_bio_pages'),
    url(r'^(?P<meeting_id>[-\d]+)/bio-pages/add/$', 'modules.meeting_information.adminviews.add_bio_page', name='admin_meeting_information_add_bio_page'),
    url(r'^(?P<meeting_id>[-\d]+)/bio-pages/(?P<page_id>[-\d]+)/edit/$', 'modules.meeting_information.adminviews.edit_bio_page', name='admin_meeting_information_edit_bio_page'),
    url(r'^(?P<meeting_id>[-\d]+)/bio-pages/(?P<page_id>[-\d]+)/delete/$', 'modules.meeting_information.adminviews.delete_bio_page', name='admin_meeting_information_delete_bio_page'),

    #floor plans
    url(r'^(?P<meeting_id>[-\d]+)/floor-plans/$', 'modules.meeting_information.adminviews.floor_plans', name='admin_meeting_information_floor_plans'),
    url(r'^(?P<meeting_id>[-\d]+)/floor-plans/add/$', 'modules.meeting_information.adminviews.add_floor_plan', name='admin_meeting_information_add_floor_plan'),
    url(r'^(?P<meeting_id>[-\d]+)/floor-plans/(?P<plan_id>[-\d]+)/edit/$', 'modules.meeting_information.adminviews.edit_floor_plan', name='admin_meeting_information_edit_floor_plan'),
    url(r'^(?P<meeting_id>[-\d]+)/floor-plans/(?P<plan_id>[-\w]+)/delete/$', 'modules.meeting_information.adminviews.delete_floor_plan', name='admin_meeting_information_delete_floor_plan'),

    #banners
    url(r'^(?P<meeting_id>[-\d]+)/banners/$', 'modules.meeting_information.adminviews.banners', name='admin_meeting_information_banners'),
    url(r'^(?P<meeting_id>[-\d]+)/banners/add/$', 'modules.meeting_information.adminviews.add_banner', name='admin_meeting_information_add_banner'),
    url(r'^(?P<meeting_id>[-\d]+)/banners/(?P<banner_id>[-\d]+)/edit/$', 'modules.meeting_information.adminviews.edit_banner', name='admin_meeting_information_edit_banner'),
    url(r'^(?P<meeting_id>[-\d]+)/banners/(?P<banner_id>[-\w]+)/delete/$', 'modules.meeting_information.adminviews.delete_banner', name='admin_meeting_information_delete_banner'),

    #programme
    url(r'^(?P<meeting_id>[-\d]+)/programme/$','modules.meeting_information.adminviews.programme',name='admin_meeting_information_programme'),

    url(r'^(?P<meeting_id>[-\d]+)/programme/sessions/add/$','modules.meeting_information.adminviews.add_programme_session',name='admin_meeting_information_add_programme_session'),
    url(r'^(?P<meeting_id>[-\d]+)/programme/sessions/manage/$','modules.meeting_information.adminviews.manage_sessions',name='admin_meeting_information_manage_sessions'),
    url(r'^(?P<meeting_id>[-\d]+)/programme/sessions/(?P<session_id>[-\d]+)/edit/$','modules.meeting_information.adminviews.edit_programme_session',name='admin_meeting_information_edit_programme_session'),
    url(r'^(?P<meeting_id>[-\d]+)/programme/sessions/(?P<session_id>[-\d]+)/delete/$','modules.meeting_information.adminviews.delete_programme_session',name='admin_meeting_information_delete_programme_session'),

    url(r'^(?P<meeting_id>[-\d]+)/programme/sessions/add-presentations/$','modules.meeting_information.adminviews.add_presentations',name='admin_meeting_information_add_presentations'),
    url(r'^(?P<meeting_id>[-\d]+)/programme/sessions/(?P<session_id>[-\d]+)/presentations/$','modules.meeting_information.adminviews.session_presentations',name='admin_meeting_information_session_presentations'),
    url(r'^(?P<meeting_id>[-\d]+)/programme/sessions/(?P<session_id>[-\d]+)/presentations/add/$','modules.meeting_information.adminviews.add_session_presentation',name='admin_meeting_information_add_session_presentation'),
    url(r'^(?P<meeting_id>[-\d]+)/programme/sessions/(?P<session_id>[-\d]+)/presentations/(?P<pres_id>[-\d]+)/edit/$','modules.meeting_information.adminviews.edit_session_presentation',name='admin_meeting_information_edit_session_presentation'),
    url(r'^(?P<meeting_id>[-\d]+)/programme/sessions/(?P<session_id>[-\d]+)/presentations/(?P<pres_id>[-\d]+)/delete/$','modules.meeting_information.adminviews.delete_session_presentation',name='admin_meeting_information_delete_session_presentation'),

    #programme options
    url(r'^(?P<meeting_id>[-\d]+)/options/$','modules.meeting_information.adminviews.programme_options',name='admin_meeting_information_options'),
    url(r'^(?P<meeting_id>[-\d]+)/options/days/add/$','modules.meeting_information.adminviews.add_day',name='add_day'),
    url(r'^(?P<meeting_id>[-\d]+)/options/days/(?P<day_id>[-\d]+)/edit/$','modules.meeting_information.adminviews.edit_day',name='edit_day'),
    url(r'^(?P<meeting_id>[-\d]+)/options/days/(?P<day_id>[-\d]+)/delete/$','modules.meeting_information.adminviews.delete_day',name='delete_day'),

    url(r'^(?P<meeting_id>[-\d]+)/options/session-types/add/$','modules.meeting_information.adminviews.add_session_type',name='add_session_type'),
    url(r'^(?P<meeting_id>[-\d]+)/options/session-types/(?P<type_id>[-\d]+)/edit/$','modules.meeting_information.adminviews.edit_session_type',name='edit_session_type'),
    url(r'^(?P<meeting_id>[-\d]+)/options/session-types/(?P<type_id>[-\d]+)/delete/$','modules.meeting_information.adminviews.delete_session_type',name='delete_session_type'),

    url(r'^(?P<meeting_id>[-\d]+)/options/subjects/add/$','modules.meeting_information.adminviews.add_subject',name='add_subject'),
    url(r'^(?P<meeting_id>[-\d]+)/options/subjects/(?P<subject_id>[-\d]+)/edit/$','modules.meeting_information.adminviews.edit_subject',name='edit_subject'),
    url(r'^(?P<meeting_id>[-\d]+)/options/subjects/(?P<subject_id>[-\d]+)/delete/$','modules.meeting_information.adminviews.delete_subject',name='delete_subject'),

    url(r'^(?P<meeting_id>[-\d]+)/options/locations/add/$','modules.meeting_information.adminviews.add_location',name='add_location'),
    url(r'^(?P<meeting_id>[-\d]+)/options/locations/(?P<location_id>[-\d]+)/edit/$','modules.meeting_information.adminviews.edit_location',name='edit_location'),
    url(r'^(?P<meeting_id>[-\d]+)/options/locations/(?P<location_id>[-\d]+)/delete/$','modules.meeting_information.adminviews.delete_location',name='delete_location'),

    #contacts
    url(r'^(?P<meeting_id>[-\d]+)/contacts/$','modules.meeting_information.adminviews.contacts',name='admin_meeting_information_contacts'),
    url(r'^(?P<meeting_id>[-\d]+)/contacts/add/$','modules.meeting_information.adminviews.add_contact',name='admin_meeting_information_add_contact'),
    url(r'^(?P<meeting_id>[-\d]+)/contacts/add-members/$','modules.meeting_information.adminviews.add_member_contacts',name='admin_meeting_information_add_member_contacts'),
    url(r'^(?P<meeting_id>[-\d]+)/contacts/import/$','modules.meeting_information.adminviews.import_contacts',name='admin_meeting_information_import_contacts'),
    url(r'^(?P<meeting_id>[-\d]+)/contacts/(?P<contact_id>[-\d]+)/edit/$','modules.meeting_information.adminviews.edit_contact',name='admin_meeting_information_edit_contact'),
    url(r'^(?P<meeting_id>[-\d]+)/contacts/(?P<contact_id>[-\d]+)/delete/$','modules.meeting_information.adminviews.delete_contact',name='admin_meeting_information_delete_contact'),

    #emailers
    url(r'^(?P<meeting_id>[-\d]+)/emailers/$','modules.meeting_information.adminviews.emailers',name='admin_meeting_information_emailers'),
    url(r'^(?P<meeting_id>[-\d]+)/emailers/add/$','modules.meeting_information.adminviews.add_emailer',name='admin_meeting_information_add_emailer'),
    url(r'^(?P<meeting_id>[-\d]+)/emailers/(?P<emailer_id>[-\d]+)/edit/$','modules.meeting_information.adminviews.edit_emailer',name='admin_meeting_information_edit_emailer'),
    url(r'^(?P<meeting_id>[-\d]+)/emailers/(?P<emailer_id>[-\d]+)/delete/$','modules.meeting_information.adminviews.delete_emailer',name='admin_meeting_information_delete_emailer'),

    #abstract sessions
    url(r'^(?P<meeting_id>[-\d]+)/posters/$','modules.meeting_information.adminviews.posters',name='admin_meeting_information_posters'),
    url(r'^(?P<meeting_id>[-\d]+)/posters/import/$','modules.meeting_information.adminviews.import_posters',name='admin_meeting_information_import_posters'),
    url(r'^(?P<meeting_id>[-\d]+)/posters/add/$','modules.meeting_information.adminviews.add_poster',name='admin_meeting_information_add_poster'),
    url(r'^(?P<meeting_id>[-\d]+)/posters/(?P<poster_id>[-\d]+)/edit/$','modules.meeting_information.adminviews.edit_poster',name='admin_meeting_information_edit_poster'),
    url(r'^(?P<meeting_id>[-\d]+)/posters/(?P<poster_id>[-\d]+)/delete/$','modules.meeting_information.adminviews.delete_poster',name='admin_meeting_information_delete_poster'),

    #abstract sessions
    url(r'^(?P<meeting_id>[-\d]+)/exhibitors/$','modules.meeting_information.adminviews.exhibitors',name='admin_meeting_information_exhibitors'),
    url(r'^(?P<meeting_id>[-\d]+)/exhibitors/add/$','modules.meeting_information.adminviews.add_exhibitor',name='admin_meeting_information_add_exhibitor'),
    url(r'^(?P<meeting_id>[-\d]+)/exhibitors/(?P<exhibitor_id>[-\d]+)/edit/$','modules.meeting_information.adminviews.edit_exhibitor',name='admin_meeting_information_edit_exhibitor'),
    url(r'^(?P<meeting_id>[-\d]+)/exhibitors/(?P<exhibitor_id>[-\d]+)/delete/$','modules.meeting_information.adminviews.delete_exhibitor',name='admin_meeting_information_delete_exhibitor'),

    #votes
    url(r'^(?P<meeting_id>[-\d]+)/votes/$', 'modules.meeting_information.adminviews.votes', name='admin_meeting_information_votes'),
    url(r'^(?P<meeting_id>[-\d]+)/votes/add/$', 'modules.meeting_information.adminviews.add_vote', name='admin_meeting_information_votes_add'),
    url(r'^(?P<meeting_id>[-\d]+)/votes/(?P<vote_id>[-\d]+)/edit/$', 'modules.meeting_information.adminviews.edit_vote', name='admin_meeting_information_votes_edit'),
    url(r'^(?P<meeting_id>[-\d]+)/votes/(?P<vote_id>[-\d]+)/delete/$', 'modules.meeting_information.adminviews.delete_vote', name='admin_meeting_information_votes_delete'),
    url(r'^(?P<meeting_id>[-\d]+)/votes/(?P<vote_id>[-\d]+)/questions/$', 'modules.meeting_information.adminviews.vote_questions', name='admin_meeting_information_votes_questions'),
    url(r'^(?P<meeting_id>[-\d]+)/votes/(?P<vote_id>[-\d]+)/submissions/$', 'modules.meeting_information.adminviews.vote_submissions', name='admin_meeting_information_votes_submissions'),
    url(r'^(?P<meeting_id>[-\d]+)/votes/(?P<vote_id>[-\d]+)/reminder/$', 'modules.meeting_information.adminviews.send_vote_reminder', name='admin_meeting_information_send_vote_reminder'),

    #evaluations
    url(r'^(?P<meeting_id>[-\d]+)/scoring/$', 'modules.meeting_information.adminviews.evaluation', name='admin_meeting_information_evaluation'),
    url(r'^(?P<meeting_id>[-\d]+)/scoring/scorers/$', 'modules.meeting_information.adminviews.evaluation_evaluators', name='admin_meeting_information_evaluation_evaluators'),
    url(r'^(?P<meeting_id>[-\d]+)/scoring/scorers/all/$','modules.meeting_information.adminviews.add_all_evaluators', name='admin_meeting_information_add_all_evaluators'),
    
    url(r'^(?P<meeting_id>[-\d]+)/scoring/s/(?P<session_id>[-\d]+)/$', 'modules.meeting_information.adminviews.evaluation_session', name='admin_meeting_information_evaluation_session'),
    url(r'^(?P<meeting_id>[-\d]+)/scoring/s/(?P<session_id>[-\d]+)/download/$', 'modules.meeting_information.adminviews.download_evaluation_submissions', name='admin_meeting_information_evaluation_session_download'),
    url(r'^(?P<meeting_id>[-\d]+)/scoring/download-sessions/$', 'modules.meeting_information.adminviews.download_sessions', name='admin_meeting_information_download_sessions'),
    url(r'^(?P<meeting_id>[-\d]+)/scoring/download-presentations/$', 'modules.meeting_information.adminviews.download_presentations', name='admin_meeting_information_download_presentations'),
    url(r'^(?P<meeting_id>[-\d]+)/scoring/download-presentations-average/$', 'modules.meeting_information.adminviews.download_average_presentation_scores', name='admin_meeting_information_download_average_presentation_scores'),

    url(r'^(?P<meeting_id>[-\d]+)/evaluation/s/(?P<session_id>[-\d]+)/view/(?P<submission_id>[-\d]+)$', 'modules.meeting_information.adminviews.evaluation_session_view_submission', name='admin_meeting_information_evaluation_session_view_submission'),
    url(r'^(?P<meeting_id>[-\d]+)/evaluation/s/(?P<session_id>[-\d]+)/delete/(?P<submission_id>[-\d]+)$', 'modules.meeting_information.adminviews.evaluation_session_delete_submission', name='admin_meeting_information_evaluation_session_delete_submission'),

    url(r'^(?P<meeting_id>[-\d]+)/scoring/p/(?P<poster_id>[-\d]+)/$', 'modules.meeting_information.adminviews.evaluation_poster', name='admin_meeting_information_evaluation_poster'),
    url(r'^(?P<meeting_id>[-\d]+)/scoring/p/(?P<poster_id>[-\d]+)/download/$', 'modules.meeting_information.adminviews.evaluation_poster_download', name='admin_meeting_information_evaluation_poster_download'),
    url(r'^(?P<meeting_id>[-\d]+)/scoring/download-posters/$', 'modules.meeting_information.adminviews.download_poster_scores', name='admin_meeting_information_download_poster_scores'),
    url(r'^(?P<meeting_id>[-\d]+)/scoring/download-posters-average/$', 'modules.meeting_information.adminviews.download_average_poster_scores', name='admin_meeting_information_download_average_poster_scores'),

    url(r'^(?P<meeting_id>[-\d]+)/evaluation/(?P<poster_id>[-\d]+)/view/(?P<submission_id>[-\d]+)$', 'modules.meeting_information.adminviews.evaluation_poster_view_submission', name='admin_meeting_information_evaluation_poster_view_submission'),
    url(r'^(?P<meeting_id>[-\d]+)/evaluation/(?P<poster_id>[-\d]+)/delete/(?P<submission_id>[-\d]+)$', 'modules.meeting_information.adminviews.evaluation_poster_delete_submission', name='admin_meeting_information_evaluation_poster_delete_submission'),
    url(r'^(?P<meeting_id>[-\d]+)/evaluation/questions/$', 'modules.meeting_information.adminviews.eval_questions', name='admin_meeting_information_eval_questions'),

    url(r'^(?P<meeting_id>[-\d]+)/evaluation/presentation-questions/$', 'modules.meeting_information.adminviews.eval_presentation_questions', name='admin_meeting_information_eval_presentation_questions'),

    url(r'^(?P<meeting_id>[-\d]+)/evaluation/poster-questions/$', 'modules.meeting_information.adminviews.eval_poster_questions', name='admin_meeting_information_eval_poster_questions'),

)
