from models import *
from modules.members.models import Member
from modules.meeting_booking.models import MeetingBooking

def get_meeting(request,*args,**kwargs):

    
    all_meetings = MeetingInformation.objects.all()
    if request.user.is_authenticated():
        if not request.user.is_staff:
            all_meetings = all_meetings.filter(enabled=True)

    if hasattr(request, 'resolver_match'):
        if hasattr(request.resolver_match,'kwargs'):
            if 'meeting_slug' in request.resolver_match.kwargs:
                meeting_slug = request.resolver_match.kwargs['meeting_slug']
                try:
                    meeting = MeetingInformation.objects.get(slug=meeting_slug)
                    meeting_links = MeetingLink.objects.filter(meeting=meeting,navigation=True)

                    other_meetings = all_meetings.exclude(id=meeting.id)

                    member_emailer = False
                    receive_comms = False
                    unread_count = 0
                    if request.user.is_authenticated():
                        try:
                            member = Member.objects.get(user=request.user)

                            try:
                                member_emailer = MeetingEmailer.objects.get(member=member, meeting=meeting)
                            except:
                                pass

                            meeting_bookings = MeetingBooking.objects.filter(member=member, complete=True)
                            if meeting_bookings:
                                receive_comms = True
                                messages = MeetingMessageReceipient.objects.filter(receiver=member, read=False)
                                unread_count = messages.count()

                        except Member.DoesNotExist:
                            pass

                    if not member_emailer:
                        meeting_links = meeting_links.exclude(link_type='message')

                    return {'all_meetings':all_meetings, 'other_meetings':other_meetings, 'meeting_information':meeting,'meeting_links':meeting_links, 'receive_comms':receive_comms, 'unread_count':unread_count}

                except Exception as e:
                    print("Exception %s" % (e))
                    pass

    return {'all_meetings':all_meetings}
