from django.core.exceptions import PermissionDenied
from django.http import HttpResponseRedirect
from django.core.urlresolvers import reverse
from django.shortcuts import redirect
from django.contrib import messages

from modules.members.models import *

from datetime import datetime,date,time

def meeting_members_only(function):

    def _inner(request, *args, **kwargs):

        if request.user.is_anonymous():
            return redirect('meeting_login', meeting_slug=kwargs['meeting_slug'])

        try:
            member = Member.objects.get(user=request.user)
            return function(request, *args, **kwargs)
        except Member.DoesNotExist:
            if request.user.is_superuser:
                messages.error(request, 'Sorry, you need to be logged in as a member to view this page.')

        return redirect('meeting_login', meeting_slug=kwargs['meeting_slug'])
    return _inner
