from modules.notifications.models import EmailTemplate, send_mail
from .models import *
from modules.meeting_booking.models import MeetingBooking

from django.conf import settings
from django.core.urlresolvers import reverse


def send_bio_request_email(bio):

    template = EmailTemplate.objects.get(key='bio_request')

    send_mail(template.key, template.subject, bio.message, template.from_address.email_address, bio.email_address)


def submit_bio_email(bio):

    template = EmailTemplate.objects.get(key='bio_submitted')
    admin_url = "%s%s" % (settings.URL, reverse('admin_meeting_information_bios'))
    message = template.content % (bio.name, bio.email_address, admin_url, admin_url)

    send_mail(template.key, template.subject, message, template.from_address.email_address, template.get_to_addresses())


def marketing_email(meeting_message, recipients):

    template = EmailTemplate.objects.get(key='marketing_email')

    subject = "PSGBI - Your have A New Message"
    content = template.content % (meeting_message.sender, meeting_message.subject, meeting_message.message)

    send_mail('marketing_email', template.subject, content, template.from_address.email_address, template.from_address.email_address, bcc_addresses=recipients, reply_to=meeting_message.sender.user.email)


def vote_reminder(vr):

    recipients = []

    registrants = MeetingBooking.objects.filter(meeting=vr.vote.meeting.meeting_booking, complete=True)

    if vr.vote.voting_type == 'members-only':
        registrants = registrants.filter(registrant_type='member')

    recipients = registrants.values_list('email_address', flat=True)

    #for registrant in registrants:
    #    recipients.append(registrant.email_address)

    template = EmailTemplate.objects.get(key='voting_reminder')
    send_mail(template.key, vr.subject, vr.content, template.from_address.email_address, template.get_to_addresses(), bcc_addresses=recipients)
