from django.conf.urls import patterns, include, url
from django.contrib.auth.views import logout
from django.conf import settings

from django.conf.urls import *

handler404 = 'modules.meeting_information.meetingviews.handler404'
handler500 = 'modules.meeting_information.meetingviews.handler500'

urlpatterns = patterns('',

    url(r'^$','modules.meeting_information.meetingviews.home',name='home'),
)

if settings.DEVELOPMENT:
    urlpatterns += patterns('',
        url(r'^media/(?P<path>.*)$', 'django.views.static.serve', {
            'document_root': settings.MEDIA_ROOT
        }),
    )

urlpatterns += patterns('',
    url(r'^(?P<meeting_slug>[-\w]+)/$', 'modules.meeting_information.meetingviews.meeting_home',name='meeting_home'),
    url(r'^(?P<meeting_slug>[-\w]+)/login/$', 'modules.meeting_information.meetingviews.meeting_login',name='meeting_login'),
    url(r'^(?P<meeting_slug>[-\w]+)/logout/$', 'modules.meeting_information.meetingviews.meeting_logout',name='meeting_logout'),
    url(r'^(?P<meeting_slug>[-\w]+)/forgot-password/$', 'modules.meeting_information.meetingviews.meeting_forgot_password', name='meeting_forgot_password'),
    url(r'^(?P<meeting_slug>[-\w]+)/forgot-password/(?P<forgot_key>[-\w]+)/$', 'modules.meeting_information.meetingviews.meeting_forgot_password_confirm', name='meeting_forgot_password_confirm'),

    #programme
    url(r'^(?P<meeting_slug>[-\w]+)/programme/$', 'modules.meeting_information.meetingviews.programme', name='programme'),

    url(r'^(?P<meeting_slug>[-\w]+)/programme/happening-now/$', 'modules.meeting_information.meetingviews.programme_happening_now', name='programme_happening_now'),

    url(r'^(?P<meeting_slug>[-\w]+)/programme/by-day/$', 'modules.meeting_information.meetingviews.programme_by_day', name='programme_by_day'),
    url(r'^(?P<meeting_slug>[-\w]+)/programme/by-day/(?P<day_id>[-\d]+)/(?P<time_slug>[-\w]+)/$', 'modules.meeting_information.meetingviews.programme_by_day', name='programme_day_time'),
    url(r'^(?P<meeting_slug>[-\w]+)/programme/by-day/load/(?P<day_id>[-\d]+)/(?P<time_slug>[-\w]+)/$', 'modules.meeting_information.meetingviews.programme_load_day_time', name='programme_load_day_time'),

    url(r'^(?P<meeting_slug>[-\w]+)/programme/by-sesion-type/$', 'modules.meeting_information.meetingviews.programme_by_type', name='programme_by_type'),
    url(r'^(?P<meeting_slug>[-\w]+)/programme/by-session-type/(?P<type_id>[-\d]+)/$', 'modules.meeting_information.meetingviews.programme_type', name='programme_type'),

    url(r'^(?P<meeting_slug>[-\w]+)/programme/by-subject/$', 'modules.meeting_information.meetingviews.programme_by_subject', name='programme_by_subject'),
    url(r'^(?P<meeting_slug>[-\w]+)/programme/by-subject/(?P<subject_id>[-\d]+)/$', 'modules.meeting_information.meetingviews.programme_subject', name='programme_subject'),

    url(r'^(?P<meeting_slug>[-\w]+)/programme/by-location/$', 'modules.meeting_information.meetingviews.programme_by_location', name='programme_by_location'),
    url(r'^(?P<meeting_slug>[-\w]+)/programme/by-location/(?P<location_id>[-\d]+)/$', 'modules.meeting_information.meetingviews.programme_location', name='programme_location'),

    url(r'^(?P<meeting_slug>[-\w]+)/programme/session/(?P<session_id>[-\d]+)/$', 'modules.meeting_information.meetingviews.programme_session', name='programme_session'),
    url(r'^(?P<meeting_slug>[-\w]+)/programme/session/(?P<session_id>[-\d]+)/add/$', 'modules.meeting_information.meetingviews.programme_session_add', name='programme_session_add'),
    url(r'^(?P<meeting_slug>[-\w]+)/programme/session/(?P<session_id>[-\d]+)/note/$', 'modules.meeting_information.meetingviews.programme_session_note', name='programme_session_note'),
    url(r'^(?P<meeting_slug>[-\w]+)/programme/session/(?P<session_id>[-\d]+)/note/add/$', 'modules.meeting_information.meetingviews.programme_session_note_add', name='programme_session_note_add'),

    url(r'^(?P<meeting_slug>[-\w]+)/programme/session/(?P<session_id>[-\d]+)/scoring/$', 'modules.meeting_information.meetingviews.programme_session_evaluation', name='programme_session_evaluation'),
    url(r'^(?P<meeting_slug>[-\w]+)/programme/session/(?P<session_id>[-\d]+)/scoring/complete/$', 'modules.meeting_information.meetingviews.programme_session_evaluation_complete', name='programme_session_evaluation_complete'),

    url(r'^(?P<meeting_slug>[-\w]+)/programme/session/(?P<session_id>[-\d]+)/presentation/(?P<presentation_id>[-\d]+)/$', 'modules.meeting_information.meetingviews.programme_presentation',name='programme_presentation'),
    url(r'^(?P<meeting_slug>[-\w]+)/programme/session/(?P<session_id>[-\d]+)/presentation/(?P<presentation_id>[-\d]+)/note/$', 'modules.meeting_information.meetingviews.programme_presentation_note', name='programme_presentation_note'),
    url(r'^(?P<meeting_slug>[-\w]+)/programme/session/(?P<session_id>[-\d]+)/presentation/(?P<presentation_id>[-\d]+)/note/add/$', 'modules.meeting_information.meetingviews.programme_presentation_note_add', name='programme_presentation_note_add'),

    url(r'^(?P<meeting_slug>[-\w]+)/floor-plans/$', 'modules.meeting_information.meetingviews.floor_plans', name='meeting_floorplans'),
    url(r'^(?P<meeting_slug>[-\w]+)/floor-plan/(?P<plan_id>[-\d]+)/$', 'modules.meeting_information.meetingviews.floor_plan', name='meeting_floorplan'),

    #posters
    url(r'^(?P<meeting_slug>[-\w]+)/posters/$', 'modules.meeting_information.meetingviews.meeting_posters', name='meeting_posters'),
    url(r'^(?P<meeting_slug>[-\w]+)/posters/(?P<poster_id>[-\d]+)/$', 'modules.meeting_information.meetingviews.meeting_poster', name='meeting_poster'),
    url(r'^(?P<meeting_slug>[-\w]+)/posters/(?P<poster_id>[-\d]+)/note/$', 'modules.meeting_information.meetingviews.meeting_poster_note', name='meeting_poster_note'),
    url(r'^(?P<meeting_slug>[-\w]+)/posters/(?P<poster_id>[-\d]+)/note/add/$', 'modules.meeting_information.meetingviews.meeting_poster_note_add', name='meeting_poster_note_add'),

    #poster scoring
    url(r'^(?P<meeting_slug>[-\w]+)/posters/(?P<poster_id>[-\d]+)/scoring/$', 'modules.meeting_information.meetingviews.meeting_poster_scoring', name='meeting_poster_scoring'),
    url(r'^(?P<meeting_slug>[-\w]+)/posters/(?P<poster_id>[-\d]+)/scoring/complete/$', 'modules.meeting_information.meetingviews.meeting_poster_scoring_complete', name='meeting_poster_scoring_complete'),


    #exhibitors
    url(r'^(?P<meeting_slug>[-\w]+)/exhibitors/$', 'modules.meeting_information.meetingviews.meeting_exhibitors', name='meeting_exhibitors'),
    url(r'^(?P<meeting_slug>[-\w]+)/exhibitors/(?P<exhibitor_id>[-\d]+)/$', 'modules.meeting_information.meetingviews.meeting_exhibitor', name='meeting_exhibitor'),
    url(r'^(?P<meeting_slug>[-\w]+)/exhibitors/(?P<exhibitor_id>[-\d]+)/note/$', 'modules.meeting_information.meetingviews.meeting_exhibitor_note', name='meeting_exhibitor_note'),
    url(r'^(?P<meeting_slug>[-\w]+)/exhibitors/(?P<exhibitor_id>[-\d]+)/note/add/$', 'modules.meeting_information.meetingviews.meeting_exhibitor_note_add', name='meeting_exhibitor_note_add'),

    #people
    #url(r'^(?P<meeting_slug>[-\w]+)/people/$', 'modules.meeting_information.meetingviews.meeting_people', name='meeting_people'),
    url(r'^(?P<meeting_slug>[-\w]+)/people/(?P<person_id>[-\d]+)/$', 'modules.meeting_information.meetingviews.meeting_person', name='meeting_person'),

    #send emails
    url(r'^(?P<meeting_slug>[-\w]+)/send-email/$', 'modules.meeting_information.meetingviews.send_marketing_email', name='send_marketing_email'),


    url(r'^(?P<meeting_slug>[-\w]+)/my-messages/$', 'modules.meeting_information.meetingviews.my_messages', name='my_messages'),
    url(r'^(?P<meeting_slug>[-\w]+)/my-messages/(?P<message_id>[-\d]+)/delete/$', 'modules.meeting_information.meetingviews.delete_message', name='delete_message'),

    #my programme
    url(r'^(?P<meeting_slug>[-\w]+)/my-meeting/$', 'modules.meeting_information.meetingviews.my_meeting',name='my_meeting'),

    url(r'^(?P<meeting_slug>[-\w]+)/my-meeting/programme/$', 'modules.meeting_information.meetingviews.my_programme',name='meeting_my_programme'),
    url(r'^(?P<meeting_slug>[-\w]+)/my-meeting/programme/(?P<day_id>[-\d]+)/(?P<time_slug>[-\w]+)/$', 'modules.meeting_information.meetingviews.my_programme', name='my_programme_day_time'),
    url(r'^(?P<meeting_slug>[-\w]+)/my-meeting/programme/load/(?P<day_id>[-\d]+)/(?P<time_slug>[-\w]+)/$', 'modules.meeting_information.meetingviews.my_programme_load_day_time', name='my_programme_load_day_time'),


    #my notes
    url(r'^(?P<meeting_slug>[-\w]+)/my-meeting/notes/$', 'modules.meeting_information.meetingviews.my_notes',name='meeting_my_notes'),
    url(r'^(?P<meeting_slug>[-\w]+)/my-meeting/notes/(?P<note_id>[-\d]+)/view/$', 'modules.meeting_information.meetingviews.view_note', name='my_notes_view_note'),
    url(r'^(?P<meeting_slug>[-\w]+)/my-meeting/notes/(?P<note_id>[-\d]+)/change/$', 'modules.meeting_information.meetingviews.change_note', name='my_notes_change_note'),
    url(r'^(?P<meeting_slug>[-\w]+)/my-meeting/notes/(?P<note_id>[-\d]+)/remove/$', 'modules.meeting_information.meetingviews.remove_note', name='my_notes_remove_note'),

    url(r'^(?P<meeting_slug>[-\w]+)/search/$', 'modules.meeting_information.meetingviews.meeting_search',name='meeting_search'),

    url(r'^(?P<meeting_slug>[-\w]+)/voting/$', 'modules.meeting_information.meetingviews.voting_home', name='voting_home'),
    url(r'^(?P<meeting_slug>[-\w]+)/voting/(?P<vote_id>[-\d]+)/$', 'modules.meeting_information.meetingviews.vote', name='vote'),
    url(r'^(?P<meeting_slug>[-\w]+)/voting/(?P<vote_id>[-\d]+)/results/$', 'modules.meeting_information.meetingviews.vote_results', name='vote_results'),
    url(r'^(?P<meeting_slug>[-\w]+)/voting/(?P<vote_id>[-\d]+)/q/(?P<question_id>[-\d]+)/$', 'modules.meeting_information.meetingviews.vote_question', name='vote_question'),
    url(r'^(?P<meeting_slug>[-\w]+)/voting/(?P<vote_id>[-\d]+)/complete/$', 'modules.meeting_information.meetingviews.vote_complete', name='vote_complete'),

    #pages
    url(r'^(?P<meeting_slug>[-\w]+)/profiles/(?P<bio_url>[-\w]+)/$', 'modules.meeting_information.meetingviews.bio_page',name='meeting_bio_page'),
    url(r'^(?P<meeting_slug>[-\w]+)/(?P<address>[-\w\./]+)$', 'modules.meeting_information.meetingviews.meeting_page',name='meeting_page'),
)
