# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('resources', '0001_initial'),
        ('meeting_booking', '0018_auto_20220707_1154'),
        ('members', '0018_auto_20220707_1154'),
        ('abstracts', '0002_auto_20190606_1005'),
    ]

    operations = [
        migrations.CreateModel(
            name='Bio',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('email_address', models.EmailField(max_length=254, blank=True)),
                ('unique_key', models.CharField(max_length=200, blank=True)),
                ('name', models.CharField(max_length=200, blank=True)),
                ('description', models.TextField()),
                ('image', models.ImageField(null=True, upload_to=b'meeting-information/bios', blank=True)),
                ('details_entered', models.BooleanField(default=False)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(null=True, blank=True)),
                ('message', models.TextField(null=True, blank=True)),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='MeetingBanner',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=150)),
                ('order', models.IntegerField()),
                ('image', models.ImageField(upload_to=b'meeting_information/banners')),
            ],
            options={
                'ordering': ('order',),
            },
        ),
        migrations.CreateModel(
            name='MeetingBioPage',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('meta_title', models.CharField(help_text=b'The title to be displayed on search engines', max_length=80, blank=True)),
                ('meta_description', models.CharField(help_text=b'The description to be displayed on search engines', max_length=160, blank=True)),
                ('title', models.CharField(max_length=150)),
                ('url', models.SlugField(max_length=150, unique=True, null=True, blank=True)),
                ('content', models.TextField(blank=True)),
                ('bios', models.ManyToManyField(to='meeting_information.Bio', blank=True)),
            ],
            options={
                'ordering': ['title'],
            },
        ),
        migrations.CreateModel(
            name='MeetingContact',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=20, null=True, blank=True)),
                ('first_name', models.CharField(max_length=200)),
                ('last_name', models.CharField(max_length=200)),
                ('email_address', models.EmailField(max_length=254, null=True, blank=True)),
                ('institution', models.CharField(max_length=200, null=True, blank=True)),
                ('bio', models.TextField(null=True, blank=True)),
            ],
            options={
                'ordering': ['last_name'],
            },
        ),
        migrations.CreateModel(
            name='MeetingEmailer',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
            ],
            options={
                'ordering': ['meeting', 'member'],
            },
        ),
        migrations.CreateModel(
            name='MeetingExhibitor',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('image', models.ImageField(null=True, upload_to=b'meeting-information/exhibitors', blank=True)),
                ('description', models.TextField()),
                ('booth', models.CharField(max_length=200)),
                ('sponsor', models.BooleanField(default=False)),
            ],
            options={
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='MeetingFloorPlan',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=150)),
                ('order', models.IntegerField()),
                ('image', models.ImageField(upload_to=b'meeting_information/floor_plans')),
            ],
            options={
                'ordering': ('order',),
            },
        ),
        migrations.CreateModel(
            name='MeetingInformation',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200, verbose_name=b'Short Name')),
                ('long_name', models.CharField(max_length=200, null=True, blank=True)),
                ('slug', models.SlugField(max_length=200)),
                ('enabled', models.BooleanField(default=False)),
                ('content', models.TextField(blank=True)),
                ('banner', models.ImageField(null=True, upload_to=b'meeting-information', blank=True)),
                ('mobile_banner', models.ImageField(null=True, upload_to=b'meeting-information', blank=True)),
                ('banner_title', models.CharField(max_length=200, null=True, blank=True)),
                ('banner_subtitle', models.CharField(max_length=200, null=True, blank=True)),
                ('_pdf', models.TextField(blank=True)),
                ('splash_enabled', models.BooleanField(default=False)),
                ('splash_title', models.CharField(max_length=200, null=True, blank=True)),
                ('splash_image', models.ImageField(null=True, upload_to=b'meeting-information', blank=True)),
                ('splash_content', models.TextField(null=True, blank=True)),
                ('abstract_request', models.ForeignKey(blank=True, to='abstracts.AbstractRequest', help_text=b'Abstract request to use for posters.', null=True)),
                ('evaluators', models.ManyToManyField(to='members.Member', blank=True)),
                ('meeting_booking', models.ForeignKey(blank=True, to='meeting_booking.Meeting', help_text=b'Meeting booking to use for registrants.', null=True)),
            ],
        ),
        migrations.CreateModel(
            name='MeetingLink',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=150)),
                ('icon', models.CharField(blank=True, max_length=20, null=True, choices=[('programme', 'Programme'), ('information', 'Information'), ('exhibitors', 'Exhibitors'), ('floor-plans', 'Floor Plans'), ('my-programme', 'My Programme'), ('voting', 'Voting'), ('evaluation', 'Evaluation'), ('camera', 'Camera'), ('checkbox', 'Checkbox'), ('document', 'Document'), ('drinks', 'Drinks'), ('info', 'Info (3)'), ('info-2', 'Info (2)'), ('pen-paper', 'Pen and Paper'), ('plane', 'Plane'), ('search', 'Search'), ('spotlight', 'Spotlight'), ('wifi', 'Wifi'), ('yes-no', 'Yes / No'), ('linkedin', 'Linked In'), ('twitter', 'Twitter'), ('youtube', 'Youtube')])),
                ('link_type', models.CharField(blank=True, max_length=100, null=True, choices=[('programme', 'Meeting Programme'), ('exhibitors', 'Exhibitors'), ('floor-plans', 'Floor Plans'), ('my-programme', 'My Programme'), ('bio-page', 'Bio Page'), ('page', 'Page'), ('message', 'Message (Sponsors)'), ('voting', 'Voting'), ('custom', 'Custom')])),
                ('custom', models.CharField(max_length=300, null=True, blank=True)),
                ('order', models.IntegerField(default=0)),
                ('homepage', models.BooleanField(default=False)),
                ('navigation', models.BooleanField(default=True)),
                ('new_window', models.BooleanField(default=False, verbose_name=b'Open in new window?')),
                ('bio_page', models.ForeignKey(blank=True, to='meeting_information.MeetingBioPage', null=True)),
                ('meeting', models.ForeignKey(to='meeting_information.MeetingInformation')),
            ],
            options={
                'ordering': ['order'],
            },
        ),
        migrations.CreateModel(
            name='MeetingMessage',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('subject', models.CharField(max_length=200)),
                ('message', models.TextField()),
                ('meeting', models.ForeignKey(to='meeting_information.MeetingInformation')),
                ('sender', models.ForeignKey(related_name='message_sender', to='members.Member')),
            ],
            options={
                'ordering': ['-created'],
            },
        ),
        migrations.CreateModel(
            name='MeetingMessageReceipient',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('read', models.BooleanField(default=False)),
                ('message', models.ForeignKey(to='meeting_information.MeetingMessage')),
                ('receiver', models.ForeignKey(related_name='message_receiver', to='members.Member')),
            ],
        ),
        migrations.CreateModel(
            name='MeetingPage',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('meta_title', models.CharField(help_text=b'The title to be displayed on search engines', max_length=80, blank=True)),
                ('meta_description', models.CharField(help_text=b'The description to be displayed on search engines', max_length=160, blank=True)),
                ('title', models.CharField(max_length=150)),
                ('url', models.SlugField(max_length=150, null=True, blank=True)),
                ('introduction', models.TextField(blank=True)),
                ('introduction_image', models.ImageField(null=True, upload_to=b'meeting-information/pages', blank=True)),
                ('content', models.TextField(blank=True)),
                ('meeting', models.ForeignKey(to='meeting_information.MeetingInformation')),
                ('parent', models.ForeignKey(blank=True, to='meeting_information.MeetingPage', null=True)),
            ],
            options={
                'ordering': ['title'],
            },
        ),
        migrations.CreateModel(
            name='MeetingPageResource',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=150)),
                ('order', models.IntegerField()),
                ('page', models.ForeignKey(to='meeting_information.MeetingPage')),
                ('resource', models.ForeignKey(to='resources.Resource')),
            ],
        ),
        migrations.CreateModel(
            name='MeetingPoster',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=200)),
                ('poster_type', models.CharField(max_length=20, choices=[('educational', 'Educational'), ('scientific', 'Scientific')])),
                ('abstract', models.TextField(blank=True)),
                ('poster_file', models.FileField(null=True, upload_to=b'meeting-information/posters', blank=True)),
                ('abstract_submission', models.ForeignKey(on_delete=django.db.models.deletion.SET_NULL, blank=True, to='abstracts.AbstractSubmission', null=True)),
                ('contact', models.ForeignKey(on_delete=django.db.models.deletion.SET_NULL, blank=True, to='meeting_information.MeetingContact', null=True)),
                ('meeting', models.ForeignKey(to='meeting_information.MeetingInformation')),
            ],
            options={
                'ordering': ('title',),
            },
        ),
        migrations.CreateModel(
            name='MeetingVote',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('start_time', models.DateTimeField()),
                ('end_time', models.DateTimeField()),
                ('voting_type', models.CharField(default=b'all-users', max_length=200, choices=[('all-users', 'All Delegates'), ('members-only', 'Members Only')])),
                ('show_results', models.BooleanField(default=False)),
                ('meeting', models.ForeignKey(to='meeting_information.MeetingInformation')),
            ],
        ),
        migrations.CreateModel(
            name='MeetingVoteQuestion',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('order', models.IntegerField()),
                ('options', models.TextField()),
                ('vote', models.ForeignKey(to='meeting_information.MeetingVote')),
            ],
            options={
                'ordering': ('order',),
            },
        ),
        migrations.CreateModel(
            name='MeetingVoteQuestionSubmission',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('answer', models.TextField()),
                ('question', models.ForeignKey(to='meeting_information.MeetingVoteQuestion')),
            ],
        ),
        migrations.CreateModel(
            name='MeetingVoteReminder',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('subject', models.CharField(max_length=200)),
                ('content', models.TextField()),
                ('to_addresses', models.TextField(blank=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('vote', models.ForeignKey(to='meeting_information.MeetingVote')),
            ],
        ),
        migrations.CreateModel(
            name='MeetingVoteSubmission',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('complete', models.BooleanField(default=False)),
                ('member', models.ForeignKey(to='members.Member')),
                ('vote', models.ForeignKey(to='meeting_information.MeetingVote')),
            ],
        ),
        migrations.CreateModel(
            name='PosterEvaluationQuestion',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('order', models.IntegerField()),
                ('type', models.CharField(max_length=200, choices=[('scale', 'Scale (1-5)'), ('yes-no', 'Yes / No'), ('text', 'Free Text')])),
                ('lower_scale', models.CharField(max_length=200, null=True, blank=True)),
                ('upper_scale', models.CharField(max_length=200, null=True, blank=True)),
                ('meeting', models.ForeignKey(to='meeting_information.MeetingInformation')),
            ],
            options={
                'ordering': ['order'],
            },
        ),
        migrations.CreateModel(
            name='PosterEvaluationSubmission',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('created', models.DateTimeField(auto_now=True)),
                ('member', models.ForeignKey(to='members.Member')),
                ('poster', models.ForeignKey(to='meeting_information.MeetingPoster')),
            ],
            options={
                'ordering': ['created'],
            },
        ),
        migrations.CreateModel(
            name='PosterEvaluationSubmissionAnswer',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('question_name', models.CharField(max_length=200)),
                ('answer', models.TextField()),
                ('order', models.IntegerField()),
                ('evaluation_submission', models.ForeignKey(to='meeting_information.PosterEvaluationSubmission')),
                ('question', models.ForeignKey(blank=True, to='meeting_information.PosterEvaluationQuestion', null=True)),
            ],
            options={
                'ordering': ['order'],
            },
        ),
        migrations.CreateModel(
            name='PresentationEvaluationQuestion',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('order', models.IntegerField()),
                ('type', models.CharField(max_length=200, choices=[('scale', 'Scale (1-5)'), ('yes-no', 'Yes / No'), ('text', 'Free Text')])),
                ('lower_scale', models.CharField(max_length=200, null=True, blank=True)),
                ('upper_scale', models.CharField(max_length=200, null=True, blank=True)),
                ('meeting', models.ForeignKey(to='meeting_information.MeetingInformation')),
            ],
            options={
                'ordering': ['order'],
            },
        ),
        migrations.CreateModel(
            name='ProgrammeSession',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('programme_name', models.CharField(max_length=200, blank=True)),
                ('programme_description', models.TextField(blank=True)),
                ('programme_presenters', models.TextField(blank=True)),
                ('start_time', models.TimeField()),
                ('end_time', models.TimeField()),
                ('time_of_day', models.CharField(max_length=20, choices=[('morning', 'Morning'), ('afternoon', 'Afternoon')])),
                ('break_session', models.BooleanField(default=False, verbose_name=b'Break Session?')),
                ('content', models.TextField(null=True, blank=True)),
                ('evaluation_enabled', models.BooleanField(default=False, verbose_name=b'Scoring Enabled')),
                ('chair', models.ForeignKey(related_name='session_chair_1', on_delete=django.db.models.deletion.SET_NULL, verbose_name=b'Speaker', blank=True, to='meeting_information.MeetingContact', null=True)),
                ('chair_2', models.ForeignKey(related_name='session_chair_2', on_delete=django.db.models.deletion.SET_NULL, verbose_name=b'Speaker 2', blank=True, to='meeting_information.MeetingContact', null=True)),
            ],
            options={
                'ordering': ('meeting', 'day', 'start_time'),
            },
        ),
        migrations.CreateModel(
            name='SessionDay',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date', models.DateField()),
                ('meeting', models.ForeignKey(to='meeting_information.MeetingInformation')),
            ],
            options={
                'ordering': ('date',),
            },
        ),
        migrations.CreateModel(
            name='SessionEvaluationQuestion',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('order', models.IntegerField()),
                ('after', models.BooleanField(default=False, verbose_name=b'Display After Individual Session Questions')),
                ('type', models.CharField(max_length=200, choices=[('scale', 'Scale (1-5)'), ('text', 'Free Text')])),
                ('lower_scale', models.CharField(max_length=200, null=True, blank=True)),
                ('upper_scale', models.CharField(max_length=200, null=True, blank=True)),
                ('meeting', models.ForeignKey(to='meeting_information.MeetingInformation')),
            ],
            options={
                'ordering': ['order', 'after'],
            },
        ),
        migrations.CreateModel(
            name='SessionEvaluationSubmission',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('created', models.DateTimeField(auto_now=True)),
                ('member', models.ForeignKey(to='members.Member')),
                ('session', models.ForeignKey(to='meeting_information.ProgrammeSession')),
            ],
            options={
                'ordering': ['created'],
            },
        ),
        migrations.CreateModel(
            name='SessionEvaluationSubmissionAnswer',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('question_name', models.CharField(max_length=200)),
                ('answer', models.TextField()),
                ('order', models.IntegerField()),
                ('evaluation_submission', models.ForeignKey(to='meeting_information.SessionEvaluationSubmission')),
            ],
            options={
                'ordering': ['order'],
            },
        ),
        migrations.CreateModel(
            name='SessionLocation',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('meeting', models.ForeignKey(to='meeting_information.MeetingInformation')),
            ],
            options={
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='SessionPresentation',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=200)),
                ('order', models.IntegerField(default=0)),
                ('abstract_submission', models.ForeignKey(blank=True, to='abstracts.AbstractSubmission', null=True)),
                ('meeting_session', models.ForeignKey(to='meeting_information.ProgrammeSession')),
                ('speaker', models.ForeignKey(related_name='presentation_speaker', on_delete=django.db.models.deletion.SET_NULL, blank=True, to='meeting_information.MeetingContact', null=True)),
                ('speaker_2', models.ForeignKey(related_name='presentation_speaker_2', on_delete=django.db.models.deletion.SET_NULL, blank=True, to='meeting_information.MeetingContact', null=True)),
                ('speaker_3', models.ForeignKey(related_name='presentation_speaker_3', on_delete=django.db.models.deletion.SET_NULL, blank=True, to='meeting_information.MeetingContact', null=True)),
                ('speaker_4', models.ForeignKey(related_name='presentation_speaker_4', on_delete=django.db.models.deletion.SET_NULL, blank=True, to='meeting_information.MeetingContact', null=True)),
                ('speaker_5', models.ForeignKey(related_name='presentation_speaker_5', on_delete=django.db.models.deletion.SET_NULL, blank=True, to='meeting_information.MeetingContact', null=True)),
            ],
            options={
                'ordering': ('meeting_session__day', 'meeting_session__start_time', 'meeting_session__id', 'order'),
            },
        ),
        migrations.CreateModel(
            name='SessionSubject',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
            ],
            options={
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='SessionType',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
            ],
            options={
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='UserNote',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('content', models.TextField()),
                ('exhibitor', models.ForeignKey(blank=True, to='meeting_information.MeetingExhibitor', null=True)),
                ('member', models.ForeignKey(to='members.Member')),
                ('poster', models.ForeignKey(blank=True, to='meeting_information.MeetingPoster', null=True)),
                ('presentation', models.ForeignKey(blank=True, to='meeting_information.SessionPresentation', null=True)),
                ('session', models.ForeignKey(blank=True, to='meeting_information.ProgrammeSession', null=True)),
            ],
        ),
        migrations.CreateModel(
            name='UserSession',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('member', models.ForeignKey(to='members.Member')),
                ('session', models.ForeignKey(to='meeting_information.ProgrammeSession')),
            ],
        ),
        migrations.AddField(
            model_name='sessionevaluationsubmissionanswer',
            name='presentation',
            field=models.ForeignKey(blank=True, to='meeting_information.SessionPresentation', null=True),
        ),
        migrations.AddField(
            model_name='sessionevaluationsubmissionanswer',
            name='question',
            field=models.ForeignKey(blank=True, to='meeting_information.SessionEvaluationQuestion', null=True),
        ),
        migrations.AddField(
            model_name='programmesession',
            name='day',
            field=models.ForeignKey(to='meeting_information.SessionDay'),
        ),
        migrations.AddField(
            model_name='programmesession',
            name='location',
            field=models.ForeignKey(on_delete=django.db.models.deletion.SET_NULL, blank=True, to='meeting_information.SessionLocation', null=True),
        ),
        migrations.AddField(
            model_name='programmesession',
            name='meeting',
            field=models.ForeignKey(to='meeting_information.MeetingInformation'),
        ),
        migrations.AddField(
            model_name='programmesession',
            name='primary_subject',
            field=models.ForeignKey(related_name='session_primary_subject', on_delete=django.db.models.deletion.SET_NULL, blank=True, to='meeting_information.SessionSubject', null=True),
        ),
        migrations.AddField(
            model_name='programmesession',
            name='secondary_subject',
            field=models.ForeignKey(related_name='session_secondary_subject', on_delete=django.db.models.deletion.SET_NULL, blank=True, to='meeting_information.SessionSubject', null=True),
        ),
        migrations.AddField(
            model_name='programmesession',
            name='session_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.SET_NULL, blank=True, to='meeting_information.SessionType', null=True),
        ),
        migrations.AddField(
            model_name='meetingvotequestionsubmission',
            name='vote_submission',
            field=models.ForeignKey(to='meeting_information.MeetingVoteSubmission'),
        ),
        migrations.AddField(
            model_name='meetinglink',
            name='page',
            field=models.ForeignKey(blank=True, to='meeting_information.MeetingPage', null=True),
        ),
        migrations.AddField(
            model_name='meetingfloorplan',
            name='meeting',
            field=models.ForeignKey(to='meeting_information.MeetingInformation'),
        ),
        migrations.AddField(
            model_name='meetingexhibitor',
            name='floor_plan',
            field=models.ForeignKey(blank=True, to='meeting_information.MeetingFloorPlan', null=True),
        ),
        migrations.AddField(
            model_name='meetingexhibitor',
            name='meeting',
            field=models.ForeignKey(to='meeting_information.MeetingInformation'),
        ),
        migrations.AddField(
            model_name='meetingemailer',
            name='meeting',
            field=models.ForeignKey(to='meeting_information.MeetingInformation'),
        ),
        migrations.AddField(
            model_name='meetingemailer',
            name='member',
            field=models.ForeignKey(to='members.Member'),
        ),
        migrations.AddField(
            model_name='meetingcontact',
            name='meeting',
            field=models.ForeignKey(to='meeting_information.MeetingInformation'),
        ),
        migrations.AddField(
            model_name='meetingcontact',
            name='member',
            field=models.ForeignKey(on_delete=django.db.models.deletion.SET_NULL, blank=True, to='members.Member', null=True),
        ),
        migrations.AddField(
            model_name='meetingbiopage',
            name='meeting',
            field=models.ForeignKey(to='meeting_information.MeetingInformation'),
        ),
        migrations.AddField(
            model_name='meetingbanner',
            name='meeting',
            field=models.ForeignKey(to='meeting_information.MeetingInformation'),
        ),
    ]
