from django.shortcuts import render,redirect, get_object_or_404
from django.contrib.auth.decorators import login_required, permission_required
from django.contrib import messages

from models import *
from forms import *
from emails import submit_bio_email

from datetime import datetime,date,time

def submit_bio(request, bio_key):

    bio = get_object_or_404(Bio, unique_key=bio_key)

    if bio.details_entered:
        return render(request, 'public/submit-bio/detailed-entered.html', {'bio':bio})

    submit_bio_form = SubmitBioForm(instance=bio)

    if request.POST:
        submit_bio_form = SubmitBioForm(request.POST, request.FILES, instance=bio)

        if submit_bio_form.is_valid():

            submit_bio_form.save()
            bio.details_entered = True
            bio.updated = datetime.now()
            bio.save()

            submit_bio_email(bio)

            return render(request, 'public/submit-bio/detailed-entered.html', {'bio':bio})

    return render(request,'public/submit-bio/enter-details.html', {'bio':bio, 'submit_bio_form':submit_bio_form})
