from django.conf.urls import *

urlpatterns = patterns('',
    url(r'^$', 'modules.members.accountviews.account_home', name='account_home'),

    url(r'^dismiss/(?P<id>[-\w]+)/$','modules.members.accountviews.dismiss_activity',name='dismiss_activity'),
    url(r'^remove/(?P<id>[-\w]+)/$','modules.members.accountviews.remove_activity',name='remove_activity'),

    url(r'^category/$', 'modules.members.accountviews.activity_category', name='activity_category'),

    url(r'^my-account/$','modules.members.accountviews.my_account',name='my_account'),
    url(r'^my-account/update-details-member/$', 'modules.members.accountviews.update_details_member', name='update_details_member'),
    url(r'^my-account/update-details-delegate/$', 'modules.members.accountviews.update_details_delegate', name='update_details_delegate'),
    url(r'^my-account/change-password/$', 'modules.members.accountviews.change_password', name='change_password'),

    url(r'^emails/$','modules.members.accountviews.emails',name='account_emails'),
    url(r'^emails/view-email/(?P<email_id>[-\d]+)/$','modules.members.accountviews.view_email',name='account_view_email'),

    #image
    url(r'^change-image/$','modules.members.accountviews.change_image',name='change_image'),

    url(r'^membership/$','modules.members.accountviews.membership',name='account_membership'),

    url(r'^membership/direct-debit/$','modules.members.accountviews.update_direct_debit',name='account_membership_update_direct_debit'),

    url(r'^membership/renew/$', 'modules.members.accountviews.renew_membership',name='account_renew'),
    url(r'^membership/renew/payment/$', 'modules.members.accountviews.renew_membership_payment', name='account_renew_payment'),
    url(r'^membership/renew/payment/complete/$', 'modules.members.accountviews.renew_membership_payment_complete', name='account_renew_payment_complete'),
    url(r'^membership/renew/payment/failure/$', 'modules.members.accountviews.renew_membership_payment_failure', name='account_renew_payment_failure'),
    url(r'^membership/renew/invoice/$', 'modules.members.accountviews.renew_membership_invoice', name='account_renew_invoice'),
    url(r'^membership/renew/invoice/complete/$', 'modules.members.accountviews.renew_membership_invoice_complete', name='account_renew_invoice_complete'),
    url(r'^membership/renew/direct-debit/$', 'modules.members.accountviews.renew_membership_direct_debit', name='account_renew_direct_debit'),
    url(r'^membership/renew/direct-debit/complete/$', 'modules.members.accountviews.renew_membership_direct_debit_complete', name='account_renew_direct_debit_complete'),

    #url(r'^pay-arrears/(?P<id>[-\d]+)/$','modules.members.accountviews.pay_arrears',name='account_pay_arrears'),
    #url(r'^pay-arrears/(?P<id>[-\d]+)/payment/$','modules.members.accountviews.pay_arrears_payment',name='account_pay_arrears_payment'),
    #url(r'^pay-arrears/(?P<id>[-\d]+)/payment/complete/$', 'modules.members.accountviews.pay_arrears_payment_complete', name='account_pay_arrears_payment_complete'),
    #url(r'^pay-arrears/(?P<id>[-\d]+)/payment/failure/$', 'modules.members.accountviews.pay_arrears_payment_failure', name='account_pay_arrears_payment_failure'),

    url(r'^my-receipts/$','modules.members.accountviews.my_receipts',name='my_receipts'),
    url(r'^my-receipts/(?P<receipt_key>[-\w]+)/view-pdf/$','modules.members.accountviews.view_receipt_pdf',name='my_receipts_view_pdf'),

    url(r'^my-certificates/$','modules.members.accountviews.my_certificates',name='my_certificates'),
    url(r'^my-certificates/(?P<certificate_id>[-\d]+)/view-pdf/$','modules.members.accountviews.view_cert_pdf',name='my_certtificates_view_pdf'),


    #url(r'^my-documents/$','modules.members.accountviews.my_documents',name='my_documents'),
    #url(r'^my-documents/remove/(?P<id>[-\d]+)/$','modules.members.accountviews.remove_document',name='remove_document'),

    #url(r'^my-certificates/$','modules.members.accountviews.my_certificates',name='my_certificates'),

    url(r'^meeting-booking/',include('modules.meeting_booking.accounturls')),
    url(r'^abstracts/',include('modules.abstracts.accounturls')),
    url(r'^papers/',include('modules.papers.accounturls')),

    url(r'^journal/$', 'modules.members.accountviews.journal', name='journal'),

)
