#Django core bits
from django.shortcuts import render_to_response, get_object_or_404
from django.template import RequestContext, loader, Context
from django.contrib.auth.decorators import login_required, permission_required
from django.db.models import Q
from django.contrib.sites.models import Site
from django.conf import settings
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.contrib.auth.models import User, Group
from django.core.mail import EmailMessage
from django.contrib import messages

from datetime import datetime,date,time

#Forms
from adminforms import *

#Models
from models import *
#from modules.meetings.models import *
from modules.payments.models import *

#Others
import random,csv,string
from django.template.defaultfilters import slugify

from modules.core.decorators import *
from modules.core.functions import *
from signals import *

@permission_required('admin_users.can_access_members')
def delegates(request):
    
    letters = map(chr, range(97, 123))
    
    member = Member()
    
    final_letters = []
    
    for letter in letters:
        status = member.get_letter_active_delegate(letter)
        if status:
            final_letters.append(letter)
    
    latest_delegates = Member.objects.filter(user_type='non-member').order_by('-user__date_joined')[:20]
    
    return render_to_response('admin/members/delegates/delegates.html',{'latest_delegates':latest_delegates,'letters':letters,'final_letters':final_letters},context_instance=RequestContext(request))
    
@permission_required('admin_users.can_access_members')
def delegates_alpha(request,letter):
    
    letters = map(chr, range(97, 123))
    
    member = Member()
    
    final_letters = []
    
    for prim_letter in letters:
        status = member.get_letter_active_delegate(prim_letter)
        if status:
            final_letters.append(prim_letter)
    
    delegates = Member.objects.filter(user__last_name__istartswith=letter,user_type='non-member').order_by('user__last_name')
        
    return render_to_response('admin/members/delegates/delegate-alpha.html',{'letters':letters,'final_letters':final_letters,'delegates':delegates,'letter':letter},context_instance=RequestContext(request))
    
@permission_required('admin_users.can_access_members')
def export_delegates(request):
    
    delegates = Member.objects.filter(user_type='non-member')
    
    #csv export
    
@permission_required('admin_users.can_access_members')
def edit_delegate(request,delegate_id):
    
    delegate = get_object_or_404(Member,id=delegate_id,user_type='non-member')
    
    member_user_form = AdminMemberUserForm(instance=delegate.user)
    member_password_form = AdminMemberPasswordForm()
    delegate_form = AdminDelegateForm(instance=delegate)
    
    if request.POST:
        member_user_form = AdminMemberUserForm(request.POST,instance=delegate.user)
        member_password_form = AdminMemberPasswordForm(request.POST)
        delegate_form = AdminDelegateForm(request.POST,request.FILES,instance=delegate)
            
        if member_user_form.is_valid() and delegate_form.is_valid():
            
            password_error = False
            new_password = False
            
            if request.POST.get('password1'):
                
                if not member_password_form.is_valid():
                    password_error = True
                new_password = request.POST['password1']
                
            if not password_error:
                
                member_user_form.save()
                
                if new_password:
                    delegate.user.set_password(request.POST['password'])
                    delegate.user.save()
            
                delegate_form.save()
            
                if delegate.given_name:
                    delegate.user.first_name = delegate.given_name
                if delegate.surname:
                    delegate.user.last_name = delegate.surname

                delegate.user.save()
            
                messages.success(request,'Delegate Updated')
                return HttpResponseRedirect(reverse('admin_members_non_members'))

    return render_to_response('admin/members/delegates/edit-delegate.html',{'delegate':delegate,'member_user_form':member_user_form,'member_password_form':member_password_form,'delegate_form':delegate_form},context_instance=RequestContext(request))
    
@permission_required('admin_users.can_access_members')
def view_delegate(request,delegate_id):
    
    member = get_object_or_404(Member,id=delegate_id,user_type='non-member')
    
    payments = Payment.objects.filter(member=member).order_by('-created')
    member_transactions = MemberTransaction.objects.filter(member=member).order_by('-transaction_date')
    member_events = MemberEvent.objects.filter(member=member).order_by('-created')
    
    return render_to_response('admin/members/delegates/view-delegate.html',{'member':member,'payments':payments,'member_transactions':member_transactions,'member_events':member_events},context_instance=RequestContext(request))
    
@permission_required('admin_users.can_access_members')
def delete_delegate(request,delegate_id):
    
    delegate = get_object_or_404(Member,id=delegate_id,user_type='non-member')
    
    try:
        delegate.user.delete()
        messages.success(request,'Delegate has been deleted')
        
    except:
        messages.error(request,'Could not delete Delegate')
        
    return HttpResponseRedirect(reverse('admin_members_non_members'))
    
@permission_required('admin_users.can_access_members')
def make_delegate_member(request,delegate_id):
    
    delegate = get_object_or_404(Member,id=delegate_id,user_type='non-member')
    
    member_user_form = AdminMemberUserForm(instance=delegate.user)
    member_form = AdminMemberForm(instance=delegate)
    
    if request.POST:
        
        member_user_form = AdminMemberUserForm(request.POST,instance=delegate.user)
        member_form = AdminMemberForm(request.POST,instance=delegate)
        
        if member_user_form.is_valid and member_form.is_valid():
            
            try:
                delegate = member_form.save()
                
                delegate.user_type = 'member'
                delegate.member_status = 'current'
                delegate.approved = True
                delegate.save()
                
                messages.success(request,'Delegate has been made a member')
                
                return HttpResponseRedirect(reverse('view_member',args=[delegate.id]))
                
            except:
                messages.error(request,'Could not make member a Delegate')
            
            
    return render_to_response('admin/members/delegates/make-delegate-member.html',{'delegate':delegate,'member_user_form':member_user_form,'member_form':member_form},context_instance=RequestContext(request))
