from django.forms import ModelForm
from django import forms
from models import *

#for adding / updating members
class AdminMemberUserForm(ModelForm):

    def __init__(self,*args,**kwargs):
        super(AdminMemberUserForm,self).__init__(*args,**kwargs)
        self.fields['email'].label = 'Email Address'
        self.fields['email'].help_text = ''
        self.fields['is_staff'].label = 'Admin Access'
        self.fields['is_staff'].help_text = ''

    class Meta:
        model = User
        fields = ('email','is_staff')

    def clean_email(self):
        email = self.cleaned_data.get('email')
        if email:
            users = User.objects.filter(email=email).exclude(email=self.instance.email)
            if users:
                raise forms.ValidationError(u'Sorry A User with this Email Address already exists')

        return email


class AdminAddMemberPasswordForm(forms.Form):

    password1 = forms.CharField(widget=forms.PasswordInput(), min_length=6, max_length=20, label='Password', help_text='')
    password2 = forms.CharField(widget=forms.PasswordInput(), min_length=6, max_length=20, label='Confirm Password')

    def clean_password2(self):
        password1 = self.cleaned_data.get('password1')
        password2 = self.cleaned_data.get('password2')

        if password1 and password2:
            if password1 != password2:
                raise forms.ValidationError(u'Please ensure your passwords match')


class AdminMemberPasswordForm(forms.Form):

    password1 = forms.CharField(widget=forms.PasswordInput(), min_length=6, max_length=20, label='Update Password', required=False, help_text='Leave blank to keep password unchanged')
    password2 = forms.CharField(widget=forms.PasswordInput(), min_length=6, max_length=20, label='Confirm Password', required=False)

    def clean_password2(self):
        password1 = self.cleaned_data.get('password1')
        password2 = self.cleaned_data.get('password2')

        if password1 and password2:
            if password1 != password2:
                raise forms.ValidationError(u'Please ensure your passwords match')


class AdminMemberForm(ModelForm):

    def __init__(self,*args,**kwargs):
        super(AdminMemberForm,self).__init__(*args,**kwargs)
        self.fields['hospital_address_1'].label = 'Hospital Address 1'
        self.fields['hospital_address_2'].label = 'Hospital Address 2'
        self.fields['member_type'].label = 'Membership Type'

    class Meta:
        model = Member
        fields = ('title','given_name','surname','member_type','expiry_date','qualifications','gender','address_1','address_2','town','county','country','postcode','personal_email','job_title','hospital','hospital_address_1','hospital_address_2','hospital_town','hospital_county','hospital_country','hospital_postcode','hospital_phone','hospital_email','preferred_mailing_address','profile_picture','mailing_list', 'agree_terms', 'notes',)

class AdminMemberGiftAidForm(ModelForm):


    def __init__(self,*args,**kwargs):
        super(AdminMemberGiftAidForm,self).__init__(*args,**kwargs)
        self.fields['gift_aid'].label = 'Has applied for gift aid?'

    class Meta:
        model = Member
        fields = ('gift_aid','gift_aid_name','gift_aid_address1','gift_aid_address2','gift_aid_town','gift_aid_county','gift_aid_country','gift_aid_postcode','gift_aid_received','gift_aid_end')

class AdminMemberInvoiceForm(ModelForm):

    class Meta:
        model = Member
        fields = ('invoice_company_name','invoice_email')


class AdminDelegateForm(ModelForm):

    def __init__(self,*args,**kwargs):
        super (AdminDelegateForm,self).__init__(*args,**kwargs)

    class Meta:
        model = Member
        fields = ('title','given_name','surname','address_1','address_2','town','county','country','postcode','telephone')


class FurtherInformationForm(ModelForm):

    class Meta:
        model = FurtherInformationMessage
        fields = ('message',)

class MemberArrearsForm(ModelForm):

    class Meta:
        model = MemberArrears
        exclude = ('member','paid')

class MemberTransactionForm(ModelForm):

    class Meta:
        model = MemberTransaction
        exclude = ('member',)

class MemberEventForm(ModelForm):

    class Meta:
        model = MemberEvent
        exclude = ('member',)

class MemberContactForm(ModelForm):

    class Meta:
        model = MemberContact
        exclude = ('member',)

class MemberCommitteeForm(ModelForm):

    class Meta:
        model = MemberCommittee
        exclude = ('member','position_code')

class MemberClassificationForm(ModelForm):

    class Meta:
        model  = MemberClassification
        exclude = ('member',)

class MemberAddSubscriptionForm(ModelForm):

    class Meta:
        model = MemberSubscription
        exclude = ('member',)


class MemberEditSubscriptionForm(ModelForm):

    class Meta:
        model = MemberSubscription
        exclude = ('member','method','renew_membership')

class MemberTypeForm(ModelForm):
    class Meta:
        model = MemberType
        fields = ('__all__')

class MemberGroupForm(ModelForm):

    def __init__(self,*args,**kwargs):
        super(MemberGroupForm,self).__init__(*args,**kwargs)
        self.fields['members'].queryset = Member.objects.filter(approved=True,member_status='current',user_type='member')

    class Meta:
        model = MemberGroup
        fields = ('__all__')

class AreaOfInterestForm(ModelForm):

    class Meta:
        model = AreaOfInterest
        fields = ('__all__')


class ImportMembersForm(forms.Form):

    file = forms.FileField(label='Members (CSV)')

class AdminAddDirectDebitForm(ModelForm):

    def __init__(self,*args,**kwargs):
        super(AdminAddDirectDebitForm,self).__init__(*args,**kwargs)
        self.fields['member'].queryset = Member.objects.filter(member_status='current',user_type='member')

    class Meta:
        model = MemberDirectDebit
        exclude = ('old_sort_code','old_ac_name','old_ac_no')


class AdminEditDirectDebitForm(ModelForm):

    class Meta:
        model = MemberDirectDebit
        exclude = ('member','old_sort_code','old_ac_name','old_ac_no')
