from django.conf.urls import *

urlpatterns = patterns('',

    url(r'^$', 'modules.members.adminviews.admin_members', name='admin_members'),

    url(r'^import/$','modules.members.adminviews.import_members',name='admin_import_members'),
    url(r'^send-passwords/$', 'modules.members.adminviews.send_passwords', name='admin_members_send_passwords'),

    url(r'^reports/',include('modules.members.reports.adminurls')),
    url(r'^direct-debits/',include('modules.members.direct_debits.adminurls')),
    url(r'^pending/',include('modules.members.pending.adminurls')),

    url(r'^delegates/$', 'modules.members.admindelegateviews.delegates',name='admin_members_non_members'),
    url(r'^delegates/list/(?P<letter>[-\w]+)/$','modules.members.admindelegateviews.delegates_alpha',name='admin_members_non_members_alpha'),
    url(r'^delegates/(?P<delegate_id>[-\w]+)/edit/$', 'modules.members.admindelegateviews.edit_delegate',name='admin_members_edit_delegate'),
    url(r'^delegates/(?P<delegate_id>[-\w]+)/view/$', 'modules.members.admindelegateviews.view_delegate',name='admin_members_view_delegate'),
    url(r'^delegates/(?P<delegate_id>[-\w]+)/delete/$', 'modules.members.admindelegateviews.delete_delegate',name='admin_members_delete_delegate'),
    url(r'^delegates/(?P<delegate_id>[-\w]+)/make-member/$', 'modules.members.admindelegateviews.make_delegate_member',name='admin_members_make_delegate_member'),

    url(r'^sort-subscriptions/$','modules.members.adminviews.sort_subscriptions',name='admin_members_sort_subscriptions'),
    url(r'^sort-expired/$','modules.members.adminviews.sort_expired',name='admin_members_sort_expired'),
    url(r'^download/$', 'modules.members.adminviews.admin_members_download', name='admin_members_download'),

    url(r'^all/$','modules.members.adminviews.all_members',name='admin_members_all'),
    url(r'^list/(?P<letter>[-\w]+)/$','modules.members.adminviews.alpha_members',name='admin_member_list_alpha'),

    url(r'^archived/$','modules.members.adminviews.archived',name='admin_members_archived'),
    url(r'^archived/list/(?P<letter>[-\w]+)/$','modules.members.adminviews.archived_alpha',name='admin_members_archived_alpha'),

    url(r'^load-member/$','modules.members.adminviews.load_member',name='admin_members_load_member'),
    url(r'^search-name/$','modules.members.adminviews.search_name',name='admin_members_search_name'),

    url(r'renewal-invoices/$','modules.members.adminviews.renewal_invoices',name='admin_members_renewal_invoices'),
    url(r'renewal-invoices/download/$','modules.members.adminviews.download_renewal_invoices',name='admin_members_download_renewal_invoices'),
    url(r'renewal-invoices/(?P<id>[-\w]+)/view/$','modules.members.adminviews.view_renewal_invoice',name='admin_members_view_renewal_invoice'),
    url(r'renewal-invoices/(?P<id>[-\w]+)/mark-paid/$','modules.members.adminviews.mark_paid_invoice',name='admin_members_mark_paid_renewal_invoice'),
    url(r'renewal-invoices/(?P<id>[-\w]+)/delete/$','modules.members.adminviews.delete_renewal_invoice',name='admin_members_delete_renewal_invoice'),

    url(r'^add/$','modules.members.adminviews.admin_add_member',name='add_member'),
    url(r'^(?P<id>[-\w]+)/view/$', 'modules.members.adminviews.admin_view_member', name='view_member'),
    url(r'^(?P<id>[-\w]+)/edit/$', 'modules.members.adminviews.admin_edit_member', name='edit_member'),
    url(r'^(?P<id>[-\w]+)/delete/$', 'modules.members.adminviews.admin_delete_member', name='delete_member'),
    url(r'^(?P<id>[-\w]+)/activate/$', 'modules.members.adminviews.admin_activate_member', name='activate_member'),
    url(r'^(?P<id>[-\w]+)/archive/$', 'modules.members.adminviews.admin_archive_member', name='archive_member'),
    url(r'^(?P<id>[-\w]+)/suspend/$', 'modules.members.adminviews.admin_suspend_member', name='suspend_member'),
    url(r'^(?P<id>[-\w]+)/change-status/(?P<status>[-\w]+)/$', 'modules.members.adminviews.change_status', name='admin_members_change_status'),
    url(r'^(?P<id>[-\w]+)/download-cv/$','modules.members.adminviews.download_cv',name="admin_members_download_cv"),
    url(r'^(?P<id>[-\w]+)/download-first-reference/$','modules.members.adminviews.download_first_reference',name="admin_members_download_first_reference"),
    url(r'^(?P<id>[-\w]+)/download-second-reference/$','modules.members.adminviews.download_second_reference',name="admin_members_download_second_reference"),

    url(r'^(?P<id>[-\w]+)/arrears/add/$','modules.members.adminviews.admin_add_member_arrears',name="add_member_arrears"),
    url(r'^(?P<id>[-\w]+)/arrears/(?P<arrears_id>[-\w]+)/edit/$','modules.members.adminviews.admin_edit_member_arrears',name="edit_member_arrears"),
    url(r'^(?P<id>[-\w]+)/arrears/(?P<arrears_id>[-\w]+)/delete/$','modules.members.adminviews.admin_delete_member_arrears',name="delete_member_arrears"),
    url(r'^(?P<id>[-\w]+)/arrears/(?P<arrears_id>[-\w]+)/update-paid/$','modules.members.adminviews.admin_update_paid_member_arrears',name="update_paid_member_arrears"),

    url(r'^(?P<id>[-\w]+)/transactions/$','modules.members.adminviews.member_transactions',name="admin_member_transactions"),
    url(r'^(?P<id>[-\w]+)/transactions/add/$','modules.members.adminviews.add_member_transaction',name="admin_add_member_transaction"),
    url(r'^(?P<id>[-\w]+)/transactions/export/$','modules.members.adminviews.download_member_transactions',name="admin_download_member_transactions"),
    url(r'^(?P<id>[-\w]+)/transactions/(?P<transaction_id>[-\w]+)/view/$','modules.members.adminviews.view_member_transaction',name="admin_view_member_transaction"),
    url(r'^(?P<id>[-\w]+)/transactions/(?P<transaction_id>[-\w]+)/edit/$','modules.members.adminviews.edit_member_transaction',name="admin_edit_member_transaction"),
    url(r'^(?P<id>[-\w]+)/transactions/(?P<transaction_id>[-\w]+)/delete/$','modules.members.adminviews.delete_member_transaction',name="admin_delete_member_transaction"),

    url(r'^(?P<id>[-\w]+)/events/$','modules.members.adminviews.member_events',name="admin_member_events"),
    url(r'^(?P<id>[-\w]+)/events/add/$','modules.members.adminviews.add_member_event',name="admin_add_member_event"),
    url(r'^(?P<id>[-\w]+)/events/export/$','modules.members.adminviews.download_member_events',name="admin_download_member_events"),
    url(r'^(?P<id>[-\w]+)/events/(?P<event_id>[-\w]+)/view/$','modules.members.adminviews.view_member_event',name="admin_view_member_event"),
    url(r'^(?P<id>[-\w]+)/events/(?P<event_id>[-\w]+)/edit/$','modules.members.adminviews.edit_member_event',name="admin_edit_member_event"),
    url(r'^(?P<id>[-\w]+)/events/(?P<event_id>[-\w]+)/delete/$','modules.members.adminviews.delete_member_event',name="admin_delete_member_event"),

    url(r'^(?P<id>[-\w]+)/contacts/$','modules.members.adminviews.member_contacts',name="admin_member_contacts"),
    url(r'^(?P<id>[-\w]+)/contacts/add/$','modules.members.adminviews.add_member_contact',name="admin_add_member_contact"),
    url(r'^(?P<id>[-\w]+)/contacts/export/$','modules.members.adminviews.download_member_contacts',name="admin_download_member_contacts"),
    url(r'^(?P<id>[-\w]+)/contacts/(?P<contact_id>[-\w]+)/view/$','modules.members.adminviews.view_member_contact',name="admin_view_member_contact"),
    url(r'^(?P<id>[-\w]+)/contacts/(?P<contact_id>[-\w]+)/edit/$','modules.members.adminviews.edit_member_contact',name="admin_edit_member_contact"),
    url(r'^(?P<id>[-\w]+)/contacts/(?P<contact_id>[-\w]+)/delete/$','modules.members.adminviews.delete_member_contact',name="admin_delete_member_contact"),

    url(r'^(?P<id>[-\w]+)/committees/$','modules.members.adminviews.member_committees',name="admin_member_committees"),
    url(r'^(?P<id>[-\w]+)/committees/add/$','modules.members.adminviews.add_member_committee',name="admin_add_member_committee"),
    url(r'^(?P<id>[-\w]+)/committees/export/$','modules.members.adminviews.download_member_committees',name="admin_download_member_committees"),
    url(r'^(?P<id>[-\w]+)/committees/(?P<committee_id>[-\w]+)/view/$','modules.members.adminviews.view_member_committee',name="admin_view_member_committee"),
    url(r'^(?P<id>[-\w]+)/committees/(?P<committee_id>[-\w]+)/edit/$','modules.members.adminviews.edit_member_committee',name="admin_edit_member_committee"),
    url(r'^(?P<id>[-\w]+)/committees/(?P<committee_id>[-\w]+)/delete/$','modules.members.adminviews.delete_member_committee',name="admin_delete_member_committee"),

    url(r'^(?P<id>[-\w]+)/classifications/$','modules.members.adminviews.member_classifications',name="admin_member_classifications"),
    url(r'^(?P<id>[-\w]+)/classifications/add/$','modules.members.adminviews.add_member_classification',name="admin_add_member_classification"),
    url(r'^(?P<id>[-\w]+)/classifications/export/$','modules.members.adminviews.download_member_classifications',name="admin_download_member_classifications"),
    url(r'^(?P<id>[-\w]+)/classifications/(?P<classification_id>[-\w]+)/view/$','modules.members.adminviews.view_member_classification',name="admin_view_member_classification"),
    url(r'^(?P<id>[-\w]+)/classifications/(?P<classification_id>[-\w]+)/edit/$','modules.members.adminviews.edit_member_classification',name="admin_edit_member_classification"),
    url(r'^(?P<id>[-\w]+)/classifications/(?P<classification_id>[-\w]+)/delete/$','modules.members.adminviews.delete_member_classification',name="admin_delete_member_classification"),

    url(r'^(?P<id>[-\w]+)/subscriptions/$','modules.members.adminviews.member_subscriptions',name="admin_member_subscriptions"),
    url(r'^(?P<id>[-\w]+)/subscriptions/add/$','modules.members.adminviews.add_member_subscription',name="admin_add_member_subscription"),
    url(r'^(?P<id>[-\w]+)/subscriptions/export/$','modules.members.adminviews.download_member_subscriptions',name="admin_download_member_subscriptions"),
    url(r'^(?P<id>[-\w]+)/subscriptions/(?P<subscription_id>[-\w]+)/view/$','modules.members.adminviews.view_member_subscription',name="admin_view_member_subscription"),
    url(r'^(?P<id>[-\w]+)/subscriptions/(?P<subscription_id>[-\w]+)/edit/$','modules.members.adminviews.edit_member_subscription',name="admin_edit_member_subscription"),
    url(r'^(?P<id>[-\w]+)/subscriptions/(?P<subscription_id>[-\w]+)/delete/$','modules.members.adminviews.delete_member_subscription',name="admin_delete_member_subscription"),

    url(r'type/(?P<id>[-\w]+)/$','modules.members.adminviews.admin_member_list_type',name='admin_member_list_type'),
    url(r'type/(?P<id>[-\w]+)/download/$','modules.members.adminviews.admin_member_list_type_download',name='admin_member_list_type_download'),

    url(r'area/(?P<id>[-\w]+)/$', 'modules.members.adminviews.admin_member_list_area', name='admin_member_list_area'),
    url(r'area/(?P<id>[-\w]+)/download/$', 'modules.members.adminviews.admin_member_list_area_download', name='admin_member_list_area_download'),

    url(r'^member-types/$','modules.members.adminviews.member_types',name='admin_member_types'),
    url(r'^member-types/add/$','modules.members.adminviews.add_member_type',name='admin_member_type_add'),
    url(r'^member-types/(?P<type_id>[-\w]+)/edit/$','modules.members.adminviews.edit_member_type',name='admin_member_type_edit'),
    url(r'^member-types/(?P<type_id>[-\w]+)/delete/$','modules.members.adminviews.delete_member_type',name='admin_member_type_delete'),

    url(r'^member-groups/$','modules.members.adminviews.admin_member_groups',name='admin_member_groups'),
    url(r'^member-groups/add/$','modules.members.adminviews.admin_member_group_add',name='admin_member_group_add'),
    url(r'^member-groups/(?P<group_id>[-\w]+)/edit/$','modules.members.adminviews.admin_member_group_edit',name='admin_member_group_edit'),
    url(r'^member-groups/(?P<group_id>[-\w]+)/delete/$','modules.members.adminviews.admin_member_group_delete',name='admin_member_group_delete'),

    url(r'^interest/$','modules.members.adminviews.areas_of_interest',name='admin_members_areas_of_interest'),
    url(r'^interest/add/$','modules.members.adminviews.add_area_of_interest',name='admin_members_add_area_of_interest'),
    url(r'^interest/(?P<area_id>[-\d]+)/edit/$','modules.members.adminviews.edit_area_of_interest',name='admin_members_edit_area_of_interest'),
    url(r'^interest/(?P<area_id>[-\d]+)/delete/$','modules.members.adminviews.delete_area_of_interest',name='admin_members_delete_area_of_interest'),

)
