#Django core bits
from django.shortcuts import render_to_response, get_object_or_404
from django.template import RequestContext, loader, Context
from django.contrib.auth.decorators import login_required, permission_required
from django.db.models import Q
from django.conf import settings
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.contrib.auth.models import User, Group
from django.core.mail import EmailMessage
from django.contrib import messages
from datetime import datetime,date,time
from django.views.decorators.csrf import csrf_exempt

from datetime import datetime,date,time
from dateutil.relativedelta import relativedelta

import os
import pdfcrowd

#models
from models import *
from forms import *

from signals import *

def check_members(request,key):

    if key != 'rjihihji89r90g0u55s8h8fhl':
         return HttpResponseRedirect('/')
    else:
        today = date.today()

        yesterday = today + relativedelta(days=-1)
        last_week = today + relativedelta(days=-7)

        one_week = today + relativedelta(days=+7)
        two_weeks = today + relativedelta(days=+14)
        three_weeks = today + relativedelta(days=+21)
        four_weeks = today + relativedelta(days=+28)

        one_month_ago = today + relativedelta(days=-30)
        two_months_ago = today + relativedelta(days=-60)
        three_months_ago = today + relativedelta(days=-90)
        
        renewal_sent = []
        expired_sent = []
        reminders_sent =[]
        archived_sent = []

        renewal_members = Member.objects.filter(Q(expiry_date=four_weeks) | Q(expiry_date=three_weeks) | Q(expiry_date=two_weeks) | Q(expiry_date=one_week), member_status='current', approved=True, user_type='member').order_by('user__last_name')

        for member in renewal_members:

            member_activity = UserActivity(member=member,title="Membership Renewal",text='Your membership is due to expire on %s, please <a href="%s">Renew your membership</a>.' % (member.expiry_date,reverse('account_renew')), type='account-notification')
            member_activity.save()

            membership_renewal.send(sender=None,request=request,member=member)
            renewal_sent.append(member)

        expired_members = Member.objects.filter(expiry_date=yesterday,approved=True,user_type='member', member_status='current')

        for member in expired_members:

            member_activity = UserActivity(member=member,title="Membership Expired",text='Your membership has expired, please <a href="%s">Renew your membership</a>.' % (reverse('account_renew')), type='account-notification')
            member_activity.save()

            membership_expired.send(sender=None,request=request,member=member)
            expired_sent.append(member)

        reminder_members = Member.objects.filter(Q(expiry_date=one_month_ago) | Q(expiry_date=two_months_ago) | Q(expiry_date=three_months_ago), approved=True, user_type='member').order_by('user__last_name')

        for member in reminder_members:
            membership_expired_reminder.send(sender=None,request=request,member=member)
            reminders_sent.append(member)

        return render_to_response('public/member-check.html',{'renewal_sent':renewal_sent,'expired_sent':expired_sent, 'reminders_sent':reminders_sent},context_instance=RequestContext(request))


def renew_members(request,key):

    if key != 'rjihiejiq90g0u55s8h8fhl':
        return HttpResponseRedirect('/')

    today = date.today()
    this_year = date(today.year,1,1)
    last_year = date(today.year-1,12,31)

    members_renewed = []

    member_subscriptions = MemberSubscription.objects.filter(expiry_date__lte=last_year)
    for subscription in member_subscriptions:
        subscription.status = 'Archived'
        if not subscription.invoice_created:
            subscription.invoice_created = this_year
        subscription.save()

    direct_debits = MemberDirectDebit.objects.filter(status='current')

    for direct_debit in direct_debits:
        if direct_debit.member:

            member = direct_debit.member

            if member.member_status != 'archived':

                member_subscriptions = MemberSubscription.objects.filter(start_date=this_year,member=member)

                if member.user.email == 'daniel@calmdigital.com':

                    if not member_subscriptions:

                        member_type = member.member_type
                        total = rate.renewal_fee - rate.dd_discount

                        subscription_name = '%s Membership Subscription %s' % (rate.name,this_year.year)
                        invoice_to_name = '%s %s %s' % (member.get_title_display(),member.given_name,member.surname)

                        member_subscription = MemberSubscription(
                            member=member,
                            member_type = member_type,
                            subscription=subscription_name,
                            amount=rate.renewal_fee,
                            discount=rate.dd_discount,
                            total= total,
                            invoice_to=invoice_to_name,
                            status='pending',
                            start_date=this_year,
                            expiry_date=member.expiry_date,
                            invoice_created=today)
                        member_subscription.save()

                        member.expiry_date = date(this_year.year,12,31)
                        member.save()

                        receipt_name = '%s Membership Subscription %s' % (settings.WEBSITE_NAME,this_year.year)
                        receipt = Receipt(member=member,name=receipt_name,start_date=member_subscription.start_date,amount_paid=total,payment_type='Credit Card')
                        receipt.unique_key = random_string_unique(20,Receipt,'unique_key')
                        receipt.save()

                        #try:
                        # create an API client instance
                        client = pdfcrowd.Client("calmdigital", "dc33e7c4525620565185d0a00d90b8f0")
                        client.setPageMargins('50','50','0','50')

                        # convert an HTML string and save the result to a file
                        output_file = open(os.path.join(settings.MEDIA_ROOT, 'members/receipts/membership_renewal_%s.pdf' % (receipt.id)), 'wb')

                        if settings.URL == 'http://127.0.0.1:8000':
                            client.convertURI('%s%s' % (settings.NGROK_URL,reverse('my_receipts_view_pdf',args=[receipt.unique_key])),output_file)
                        else:
                            client.convertURI('%s%s' % (settings.URL,reverse('my_receipts_view_pdf',args=[receipt.unique_key])),output_file)
                        output_file.close()
                        #except:
                        #    pass

                        receipt.file = 'members/receipts/membership_renewal_%s.pdf' % (receipt.id)
                        #receipt.unique_key = ''
                        receipt.save()

                        renewal_confirmation.send(sender=None,request=request,member=member,subscription=subscription,method='Direct Debit',receipt=receipt,notify_admin=False)

                        notification = UserActivity(member=member,type='account-notification',title='Membership Renewed',text='Your membership has been successfully renewed for 12 months.<br/>Visit <a href="%s">My Receipts</a> to view your receipt.' % (reverse('my_receipts')))
                        notification.save()

                        members_renewed.append(member)

    return render_to_response('public/members_renewed.html',{'members_renewed':members_renewed},context_instance=RequestContext(request))
