from models import *

from django.conf import settings

import hashlib

from time import gmtime, strftime


def get_member(request):

    member = False

    try:
        member = Member.objects.get(user = request.user)
    except:
        pass

    return {'current_member': member}


def get_journal_url(request):

    if request.user.is_authenticated():

        origin = settings.JOURNAL_ORIGIN_ID
        salt = settings.JOURNAL_SALT
        ts = strftime("%Y%m%d%H%M%S", gmtime())

        target = 'https%3A%2F%2Fwww.sciencedirect.com%2Fjournal%2Fpancreatology'

        query_string = """_ob=TicketedURL&_origin=%s&_originUser=&_target=%s&_ts=%s&_version=1""" % (origin, target, ts)
        salt_string = "%s%s" % (query_string,salt)
        md5 = hashlib.md5(salt_string).hexdigest()
        journal_url = """https://www.sciencedirect.com/user/ticketedUrl?%s&md5=%s""" % (query_string, md5)

        #journal_url = 'https://www.sciencedirect.com/journal/european-journal-of-vascular-and-endovascular-surgery'

    else:
        journal_url = ''

    return {'journal_url': journal_url}