#Django core bits
from django.shortcuts import render_to_response, get_object_or_404
from django.contrib import messages
from django.contrib.auth.models import User, Group
from django.core.mail import EmailMessage

import random,string

from datetime import datetime, date, time
from models import *
from forms import *

from signals import *

def register_member(request,approval_required=False):

    errors = False

    registration_form_user = RegistrationFormUser(request.POST)
    registration_form_password = RegistrationFormPassword(request.POST)
    registration_form_personal = RegistrationFormPersonal(request.POST)
    registration_form_member_type = RegistrationFormMemberType(request.POST)
    registration_form_personal_address = RegistrationFormPersonalAddress(request.POST)
    registration_form_hospital = RegistrationFormHospital(request.POST)
    registration_form_work_skip = RegistrationFormWorkSkip(request.POST)
    registration_form_support = RegistrationFormSupport(request.POST,request.FILES)
    registration_form_other_societies = RegistrationFormOtherSocieties(request.POST)
    registration_form_donation = RegistrationFormDonation(request.POST)
    registration_form_contact = RegistrationFormContact(request.POST)
    registration_form_terms = RegistrationFormTerms(request.POST)

    if registration_form_user.is_valid() and registration_form_password.is_valid() and registration_form_personal.is_valid() and registration_form_member_type.is_valid() and registration_form_personal_address.is_valid() and registration_form_other_societies.is_valid() and registration_form_donation.is_valid() and registration_form_contact.is_valid() and registration_form_terms.is_valid():

        if not registration_form_hospital.is_valid():
            if registration_form_work_skip.is_valid():
                if not registration_form_work_skip.cleaned_data['no_work_address']:
                    errors = True

        member_type = registration_form_member_type.cleaned_data['member_type']
        if member_type.student:
            if not registration_form_support.is_valid():
                errors = True

        if not errors:
            #create user

            user = registration_form_user.save(commit=False)
            user.username = random_string_unique(20,User,'username')
            user.set_password(request.POST['password1'])
            user.save()

            #try:
            member = registration_form_personal.save(commit=False)
            member.user = user
            member.user_type = 'member'
            member.save()

            user.first_name = member.given_name
            user.last_name = member.surname
            user.save()

            registration_form_member_type = RegistrationFormMemberType(request.POST,instance=member)
            registration_form_member_type.save()

            registration_form_personal_address = RegistrationFormPersonalAddress(request.POST,instance=member)
            registration_form_personal_address.save()

            if registration_form_hospital.is_valid():
                registration_form_hospital = RegistrationFormHospital(request.POST,instance=member)
                registration_form_hospital.save()

            if registration_form_work_skip.is_valid():
                registration_form_work_skip = RegistrationFormWorkSkip(request.POST,instance=member)
                registration_form_work_skip.save()

            registration_form_support = RegistrationFormSupport(request.POST,request.FILES,instance=member)
            registration_form_support.save()

            if member.referrer_email:
                unique_key = random_string_unique_referrer()
                member.referrer_key = unique_key

            registration_form_other_societies = RegistrationFormOtherSocieties(request.POST,instance=member)
            registration_form_other_societies.save()

            registration_form_donation = RegistrationFormDonation(request.POST,instance=member)
            registration_form_donation.save()

            registration_form_contact = RegistrationFormContact(request.POST,instance=member)
            registration_form_contact.save()

            registration_form_terms = RegistrationFormTerms(request.POST,instance=member)
            registration_form_terms.save()

            return member

    messages.error(request,'Please ensure you complete all the fields to continue')

    return False

def get_next_membership_number():

    members = Member.objects.filter(membership_number__isnull=False).order_by('-membership_number')
    if members:
        last_member = members[0]
        return last_member.membership_number + 1
    else:
        return 1

def random_string_unique_referrer():

    while True:
        random_str = ''.join(random.choice(string.ascii_uppercase + string.digits) for x in range(50))

        if (not Member.objects.filter(**{'referrer_key':random_str}).count()):
            return random_str

def find_updated_fields(request,member,user_form,forms=[]):

    updated_fields = []

    for field in user_form:
        original_val = getattr(member.user,field.name)
        if original_val != request.POST[field.name]:
            updated_fields.append({'field':field.label,'old':original_val,'new':request.POST[field.name]})

    for form in forms:
        for field in form:
            original_val = getattr(member,field.name)
            new_val  = ''
            if request.POST.get(field.name):
                new_val = request.POST[field.name]
                if new_val == 'on':
                    new_val = 'True'
                elif new_val == 'off':
                    new_val = 'False'

            if field.name == 'country' or field.name == 'hospital_country':
                if original_val:
                    original_val_id = str(original_val.id)
                    original_val_name = original_val.name
                    if original_val_id != request.POST[field.name]:
                        if field.name == 'country' or field.name == 'hospital_country':
                            country = Country.objects.get(id=request.POST[field.name])
                            updated_fields.append({'field':field.label,'old':original_val_name,'new':country.name})
            elif field.name == 'date_of_birth':
                if original_val:
                    original_val = original_val.strftime('%d/%m/%Y')
                else:
                    original_val = ''

                if original_val != new_val:
                    updated_fields.append({'field':field.label,'old':original_val,'new':new_val})

            elif field.name == 'other_societies':
                original_values = original_val.all()
                new_values = request.POST.getlist(field.name)
                different = False
                if len(original_values) != len(new_values):
                    different = True
                else:
                    for original_value in original_values:
                        if str(original_value.id) not in new_values:
                            different = True
                if different:
                    old_string = ''
                    new_string = ''
                    for original_value in original_values:
                        old_string = "%s%s," % (old_string,original_value.name)
                    for new_value in new_values:
                        try:
                            other_society = OtherSociety.objects.get(id=new_value)
                            new_string = "%s%s," % (new_string,other_society.name)
                        except:
                            pass
                    updated_fields.append({'field':field.label,'old':old_string,'new':new_string})
            elif field.name == 'areas_of_interest':
                original_values = original_val.all()
                new_values = request.POST.getlist(field.name)
                different = False
                if len(original_values) != len(new_values):
                    different = True
                else:
                    for original_value in original_values:
                        if str(original_value.id) not in new_values:
                            different = True
                if different:
                    old_string = ''
                    new_string = ''
                    for original_value in original_values:
                        old_string = "%s%s," % (old_string,original_value.name)
                    for new_value in new_values:
                        try:
                            area_of_interest = AreaOfInterest.objects.get(id=new_value)
                            new_string = "%s%s," % (new_string,area_of_interest.name)
                        except:
                            pass
                    updated_fields.append({'field':field.label,'old':old_string,'new':new_string})
            else:
                try:
                    original_val = str(original_val)
                    if original_val != new_val:
                        updated_fields.append({'field':field.label,'old':original_val,'new':new_val})
                except:
                    pass

    return updated_fields
