#Django core bits
from django.shortcuts import render_to_response, get_object_or_404
from django.template import RequestContext, loader, Context
from django.contrib.auth.decorators import login_required, permission_required
from django.db.models import Q
from django.contrib.sites.models import Site
from django.conf import settings
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.contrib.auth.models import User, Group
from django.core.mail import EmailMessage
from django.contrib import messages
from datetime import datetime,date,time
import math

#Forms
from forms import *

#Models
from models import *
from modules.pages.models import *

#Others
import random,csv,string

from modules.core.functions import *
from modules.core.decorators import *

@current_members_only
def members_list(request):
    
    all_members = Member.objects.all()

    per_page = 20
    count = all_members.count()
    page_dec = float(count) / float(per_page)
    num_pages = int(math.ceil(page_dec))
    
    upper_limit = 20
    if upper_limit >= count:
        upper_limit = count
  
    members = Member.objects.all().order_by('-user__last_login')[:20]
        
    return render_to_response('public/members/listings/list.html', {'members':members,'sort':'last_login','page':1,'per_page':per_page,'count':count,'num_pages':num_pages,'lower_limit':1,'upper_limit':upper_limit}, context_instance=RequestContext(request))
    
@current_members_only
def members_basic_search(request,sort,page,per_page):
    
    if request.GET.get('query'):
        search_term = request.GET.get('query')
    else:
        search_term = False
        
    if request.GET.get('location'):
        location_term = request.GET.get('location')
    else:
        location_term = False

    if search_term:
        all_members = Member.objects.filter(Q(given_name__icontains=search_term) | Q(surname__icontains=search_term))
    else:
        all_members = Member.objects.all()
        
    if location_term:
        all_members = all_members.filter(Q(hospital_town=location_term) | Q(hospital_county__icontains=location_term) | Q(hospital__icontains=location_term))
    
    
    count = all_members.count()
    page_dec = float(count) / float(per_page)
    num_pages = int(math.ceil(page_dec))
    
    offset = int(per_page) * (int(page) - 1)
    lower_limit = offset + 1
    upper_limit = int(per_page) + offset
    
    if upper_limit >= count:
        upper_limit = count
    
    if search_term or location_term:

        if search_term:
            if sort == 'name':
                members = Member.objects.filter(Q(given_name__icontains=search_term) | Q(surname__icontains=search_term)).order_by('surname')
            elif sort == 'last_login':
                members = Member.objects.filter(Q(given_name__icontains=search_term) | Q(surname__icontains=search_term))
            else:
                sort = 'name'
                members = MemberSearch.objects.filter(first_name__icontains=search_term).order_by('last_name')
        else:
            members = MemberSearch.objects.all().order_by('surname')
    
        if location_term:
            if sort == 'name':
                members = members.filter(Q(hospital_town=location_term) | Q(hospital_county__icontains=location_term) | Q(hospital__icontains=location_term)).order_by('surname')[offset:upper_limit]
            elif sort == 'last_login':
                members = members.filter(Q(hospital_town=location_term) | Q(hospital_county__icontains=location_term) | Q(hospital__icontains=location_term))[offset:upper_limit]
            else:
                sort = 'name'
                members = members.filter(Q(hospital_town=location_term) | Q(hospital_county__icontains=location_term) | Q(hospital__icontains=location_term)).order_by('surname')[offset:upper_limit]
        else:
            members = members[offset:upper_limit]
        
    
    else:
        return HttpResponseRedirect(reverse('members_sort_page',args=[sort,page,per_page]))
    
    return render_to_response('public/members/listings/search.html',{'members':members,'search_term':search_term,'location_term':location_term,'sort':sort,'page':page,'per_page':per_page,'count':count,'num_pages':num_pages,'lower_limit':lower_limit,'upper_limit':upper_limit},context_instance=RequestContext(request))
    
    
@current_members_only
def members_sort_page(request,sort,page,per_page):
    
    if sort == 'current_post':
        all_members = Member.objects.filter(current_post__isnull = False)
    elif sort == 'hospital':
        all_members = Member.objects.filter(hospital__isnull = False)
    else:
        all_members = Member.objects.all()
        
    count = all_members.count()
    page_dec = float(count) / float(per_page)
    num_pages = int(math.ceil(page_dec))
    
    offset = int(per_page) * (int(page) - 1)
    lower_limit = offset + 1
    upper_limit = int(per_page) + offset
    
    if upper_limit >= count:
        upper_limit = count

    if sort == 'name':
        members = Member.objects.all().order_by('surname')[offset:upper_limit]
    elif sort == 'last_login':
        members = Member.objects.all().order_by('-user__last_login')[offset:upper_limit]
    elif sort == 'current_post':
        members = Member.objects.filter(current_post__isnull = False).order_by('current_post')[offset:upper_limit]
    elif sort == 'hospital':
        members = Member.objects.filter(hospital__isnull = False).order_by('site')[offset:upper_limit]
    else:
        sort = 'last_login'
        members = Member.objects.all().order_by('-user__last_login')[offset:upper_limit]

    return render_to_response('public/members/listings/list.html',{'members':members,'sort':sort,'page':page,'per_page':per_page,'count':count,'num_pages':num_pages,'lower_limit':lower_limit,'upper_limit':upper_limit},context_instance=RequestContext(request))
    
@current_members_only
def members_sort_all(request,sort):
    
    all_members = Member.objects.all()
    count = all_members.count()
    
    page_dec = float(count) / float(20)
    num_pages = int(math.ceil(page_dec))

    if sort == 'name':
        members = Member.objects.all().order_by('surname')
    elif sort == 'last_login':
        members = Member.objects.all().order_by('-user__last_login')
    elif sort == 'current_post':
        members = Member.objects.filter(job_title__isnull = False).order_by('hospital')
    elif sort == 'hospital':
        members = Member.objects.filter(site__isnull = False).order_by('hospital')
    else:
        sort = 'last_login'
        members = MemberSearch.objects.all().order_by('-member__user__last_login')

    return render_to_response('public/members/listings/list.html',{'members':members,'sort':sort,'page':1,'per_page':20,'count':count,'num_pages':num_pages,'lower_limit':1,'upper_limit':20,'all':True},context_instance=RequestContext(request))
    
@current_members_only
def member_profile(request,username):
    
    member = get_object_or_404(Member,user__email=username,archived=False)
    
    return render_to_response('public/members/listings/member-profile.html',{'member':member}, context_instance=RequestContext(request))
    
@current_members_only
def email_member(request,username):

    current_member = get_object_or_404(Member,user=request.user)
    member = get_object_or_404(Member,user__email=username,archived=False)
    
    form  = EmailMemberForm()

    if request.POST:
        form = EmailMemberForm(request.POST)
        if form.is_valid():
            try:
                member_email = MemberEmail(sender=current_member,recipient=member,message=request.POST.get('message'))
                member_email.save()
            
                message = """
<p>Member: %s</p>

<p>Message: - %s</p>

<p>To reply to their message please go to %s%s</p>

<p>This is an automatic email generated by the BSIR website.</p>""" % (current_member,request.POST.get('message'),request.META['HTTP_HOST'],reverse('member_profile_email',args=[current_member.user.email]))

                msg = EmailMessage('BSIR - A member has sent you a private message', message, settings.CONTACT_EMAIL, [member.user.email],['daniel@calmdigital.com'])
                #msg = EmailMessage('BSIR - A member has sent you a private message', message, settings.CONTACT_EMAIL, ['daniel@calmdigital.com'])

                msg.content_subtype = "html"
                try:
                    msg.send()
                except:
                    pass
            
                return render_to_response('public/members/listings/message-sent.html',{'member':member},context_instance=RequestContext(request))
                    
            except:
                messages.error(request,'Sorry, could not send your mesage')

    return render_to_response('public/members/listings/email-member.html',{'member':member,'form':form},context_instance=RequestContext(request))
    
    