# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
import datetime
import modules.core.encryption
import django.db.models.deletion
from django.conf import settings


class Migration(migrations.Migration):

    dependencies = [
        #('meeting_booking', '__first__'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        #('resources', '__first__'),
    ]

    operations = [
        migrations.CreateModel(
            name='AreaOfInterest',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Certificate',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('file', models.FileField(null=True, upload_to=b'members/certificates', blank=True)),
                ('start_date', models.DateField(null=True, blank=True)),
                ('end_date', models.DateField(null=True, blank=True)),
            ],
        ),
        migrations.CreateModel(
            name='Country',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=100)),
                ('order', models.IntegerField()),
                ('iso_code', models.CharField(max_length=20, null=True, blank=True)),
                ('currency', models.CharField(blank=True, max_length=10, null=True, choices=[('GBP', 'GBP'), ('EUR', 'EUR')])),
            ],
            options={
                'ordering': ('order',),
            },
        ),
        migrations.CreateModel(
            name='FurtherInformationMessage',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('message', models.TextField(help_text=b'Please enter your message above, this will appear above the link for the member to resend their application.')),
                ('created', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='Member',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('user_type', models.CharField(default=b'member', max_length=100, choices=[('member', 'Member'), ('non-member', 'Non Member')])),
                ('registered', models.DateTimeField(null=True, blank=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('raw_password', models.CharField(max_length=100, null=True, blank=True)),
                ('approved', models.BooleanField(default=False)),
                ('complete', models.BooleanField(default=False)),
                ('paid', models.BooleanField(default=False)),
                ('payment_type', models.CharField(max_length=20, null=True, blank=True)),
                ('member_status', models.CharField(default=b'current', max_length=100, choices=[('current', 'Current'), ('suspended', 'Suspended'), ('lapsed', 'Lapsed'), ('archived', 'Archived')])),
                ('renewal_message_date', models.DateField(null=True, blank=True)),
                ('num_reminders', models.IntegerField(default=0)),
                ('lapsed_date', models.DateField(null=True, blank=True)),
                ('expiry_date', models.DateField(null=True, blank=True)),
                ('unique_key', models.CharField(max_length=200, null=True, blank=True)),
                ('requires_password_reset', models.BooleanField(default=True)),
                ('temp_password', models.BooleanField(default=False)),
                ('temp_email', models.BooleanField(default=False)),
                ('membership_number', models.IntegerField(null=True, blank=True)),
                ('category', models.CharField(max_length=10, null=True, blank=True)),
                ('chapter', models.CharField(max_length=10, null=True, blank=True)),
                ('previous_member_type', models.CharField(max_length=10, null=True, blank=True)),
                ('date_added', models.DateField(null=True, blank=True)),
                ('previous_name', models.TextField(null=True, blank=True)),
                ('title', models.CharField(blank=True, max_length=10, null=True, choices=[('Mr', 'Mr'), ('Mrs', 'Mrs'), ('Miss', 'Miss'), ('Ms', 'Ms'), ('Doctor', 'Doctor'), ('Professor', 'Professor')])),
                ('given_name', models.CharField(max_length=200, null=True, blank=True)),
                ('surname', models.CharField(max_length=200, null=True, blank=True)),
                ('gender', models.CharField(blank=True, max_length=10, null=True, choices=[('Male', 'Male'), ('Female', 'Female')])),
                ('date_of_birth', models.DateField(null=True, blank=True)),
                ('qualifications', models.CharField(max_length=200, null=True, blank=True)),
                ('profession', models.CharField(max_length=200, null=True, blank=True)),
                ('speciality', models.CharField(max_length=200, null=True, blank=True)),
                ('job_title', models.CharField(max_length=200, null=True, blank=True)),
                ('hospital', models.CharField(max_length=200, null=True, verbose_name=b'Hospital or Clinic', blank=True)),
                ('hospital_department', models.CharField(max_length=200, null=True, verbose_name=b'Department', blank=True)),
                ('hospital_address_1', models.CharField(max_length=200, null=True, verbose_name=b'Address 1', blank=True)),
                ('hospital_address_2', models.CharField(max_length=200, null=True, verbose_name=b'Address 2', blank=True)),
                ('hospital_address_3', models.CharField(max_length=200, null=True, verbose_name=b'Address 3', blank=True)),
                ('hospital_town', models.CharField(max_length=200, null=True, verbose_name=b'Town', blank=True)),
                ('hospital_county', models.CharField(max_length=200, null=True, verbose_name=b'County', blank=True)),
                ('hospital_postcode', models.CharField(max_length=200, null=True, verbose_name=b'Postcode', blank=True)),
                ('hospital_phone', models.CharField(max_length=40, verbose_name=b'Phone Number', blank=True)),
                ('hospital_email', models.EmailField(max_length=200, null=True, verbose_name=b'Hospital Email Address', blank=True)),
                ('no_work_address', models.BooleanField(default=False, verbose_name=b'Tick if you have no work address (Previous address fields are not required)')),
                ('address_1', modules.core.encryption.EncryptedCharField(max_length=869, null=True, blank=True)),
                ('address_2', models.CharField(max_length=200, null=True, blank=True)),
                ('address_3', models.CharField(max_length=200, null=True, blank=True)),
                ('town', models.CharField(max_length=200, null=True, blank=True)),
                ('county', models.CharField(max_length=200, null=True, blank=True)),
                ('postcode', modules.core.encryption.EncryptedCharField(max_length=165, null=True, blank=True)),
                ('telephone', models.CharField(max_length=40, null=True, verbose_name=b'Phone Number', blank=True)),
                ('mobile', models.CharField(max_length=40, null=True, verbose_name=b'Mobile Number', blank=True)),
                ('personal_email', models.EmailField(max_length=200, null=True, verbose_name=b'Personal Email Address', blank=True)),
                ('preferred_mailing_address', models.CharField(blank=True, max_length=20, null=True, verbose_name=b'Preferred Postal Address', choices=[('Residence', 'Residence'), ('Work', 'Work')])),
                ('profile_picture', models.ImageField(null=True, upload_to=b'members', blank=True)),
                ('other_societies_other', models.CharField(max_length=200, null=True, verbose_name=b'Other - Please Specify', blank=True)),
                ('referrer_email', models.EmailField(max_length=200, null=True, verbose_name=b"Course Leader's Email Address", blank=True)),
                ('referrer_key', models.CharField(max_length=200, null=True, blank=True)),
                ('referrer_approved', models.BooleanField(default=False)),
                ('areas_of_interest_other', models.CharField(max_length=200, null=True, verbose_name=b'Other - Please Specify', blank=True)),
                ('notes', models.TextField(null=True, blank=True)),
                ('donation', models.BooleanField(default=False)),
                ('donation_amount', models.FloatField(null=True, verbose_name=b'Amount (&pound;)', blank=True)),
                ('mailing_list', models.BooleanField(default=False, verbose_name=b'Tick the box if you wish be added to the Mailing List')),
                ('gift_aid', models.BooleanField(default=True, verbose_name=b"If you are a UK tax payer and not already claiming back your subscription as a professional expense, you could help PSGBI claim 20% of your membership subscription back from Her Majesty's Revenue and Customs at no cost to you. You could help PSGBI keeps its membership costs as low as possible. All you need to do is complete the declaration on the next page.")),
                ('gift_aid_name', models.CharField(max_length=200, null=True, verbose_name=b'Name', blank=True)),
                ('gift_aid_address1', models.CharField(max_length=200, null=True, verbose_name=b'Address 1', blank=True)),
                ('gift_aid_address2', models.CharField(max_length=200, null=True, verbose_name=b'Address 2', blank=True)),
                ('gift_aid_town', models.CharField(max_length=200, null=True, verbose_name=b'Town', blank=True)),
                ('gift_aid_county', models.CharField(max_length=200, null=True, verbose_name=b'County', blank=True)),
                ('gift_aid_postcode', models.CharField(max_length=200, null=True, verbose_name=b'Postcode', blank=True)),
                ('gift_aid_received', models.DateField(null=True, blank=True)),
                ('gift_aid_end', models.DateField(null=True, blank=True)),
                ('invoice_company_name', models.CharField(max_length=200, null=True, verbose_name=b'Company Name', blank=True)),
                ('invoice_email', models.EmailField(max_length=200, null=True, verbose_name=b'Email Address', blank=True)),
                ('areas_of_interest', models.ManyToManyField(to='members.AreaOfInterest', blank=True)),
                ('country', models.ForeignKey(related_name='Country', blank=True, to='members.Country', null=True)),
                ('gift_aid_country', models.ForeignKey(related_name='gift_aid_country', verbose_name=b'Country', blank=True, to='members.Country', null=True)),
                ('hospital_country', models.ForeignKey(related_name='hospital_country', verbose_name=b'Country', blank=True, to='members.Country', null=True)),
            ],
            options={
                'ordering': ['membership_number'],
            },
        ),
        migrations.CreateModel(
            name='MemberArrears',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('description', models.TextField(verbose_name=b'Message')),
                ('amount', models.FloatField()),
                ('paid', models.BooleanField(default=False)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('member', models.ForeignKey(to='members.Member')),
            ],
        ),
        migrations.CreateModel(
            name='MemberClassification',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('parent_classification', models.CharField(max_length=200, null=True, blank=True)),
                ('classification', models.CharField(max_length=200)),
                ('class_date', models.DateField()),
                ('source', models.CharField(max_length=100, null=True, blank=True)),
                ('member', models.ForeignKey(to='members.Member')),
            ],
        ),
        migrations.CreateModel(
            name='MemberCommittee',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('committee', models.CharField(max_length=200)),
                ('position_code', models.CharField(max_length=20, null=True, blank=True)),
                ('position', models.CharField(max_length=200)),
                ('start_date', models.DateField()),
                ('end_date', models.DateField()),
                ('member', models.ForeignKey(to='members.Member')),
            ],
        ),
        migrations.CreateModel(
            name='MemberContact',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('contact_date', models.DateField()),
                ('contact_type', models.CharField(max_length=200)),
                ('category', models.CharField(max_length=200)),
                ('subject', models.CharField(max_length=200)),
                ('operator', models.CharField(max_length=100)),
                ('closed', models.BooleanField(default=False)),
                ('member', models.ForeignKey(to='members.Member')),
            ],
        ),
        migrations.CreateModel(
            name='MemberDirectDebit',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('sort_code', modules.core.encryption.EncryptedCharField(max_length=165, verbose_name=b'Sort Code')),
                ('ac_name', models.CharField(max_length=100, verbose_name=b'Account Name')),
                ('ac_no', modules.core.encryption.EncryptedCharField(max_length=165, verbose_name=b'Account Number')),
                ('collection', models.CharField(default=b'A', max_length=100, choices=[('A', 'Annual (Single)')])),
                ('submission', models.CharField(default=b'1', max_length=100, choices=[('01', 'New Submission'), ('17', 'Existing Submission')])),
                ('type', models.CharField(default=b'UKDD', max_length=100, choices=[('UKDD', 'UK Direct Debit (BACS)')])),
                ('old_sort_code', modules.core.encryption.EncryptedCharField(max_length=165, null=True, verbose_name=b'Old Sort Code', blank=True)),
                ('old_ac_name', models.CharField(max_length=100, null=True, verbose_name=b'Old Account Name', blank=True)),
                ('old_ac_no', modules.core.encryption.EncryptedCharField(max_length=165, null=True, verbose_name=b'Old Account Number', blank=True)),
                ('status', models.CharField(default=b'pending', max_length=20, choices=[('pending', 'Pending'), ('current', 'Current'), ('archived', 'Archived')])),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('member', models.ForeignKey(to='members.Member')),
            ],
        ),
        migrations.CreateModel(
            name='MemberEmail',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('message', models.TextField()),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('recipient', models.ForeignKey(related_name='receipient', to='members.Member')),
                ('sender', models.ForeignKey(related_name='sender', to='members.Member')),
            ],
        ),
        migrations.CreateModel(
            name='MemberEvent',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('event_name', models.CharField(max_length=200)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('member_name', models.CharField(max_length=200)),
                ('booking_type', models.CharField(max_length=20)),
                ('status', models.CharField(max_length=20, choices=[('confirmed', 'Confirmed'), ('cancelled', 'Cancelled')])),
                ('member', models.ForeignKey(to='members.Member')),
            ],
        ),
        migrations.CreateModel(
            name='MemberGroup',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('order', models.IntegerField(default=0)),
                ('members', models.ManyToManyField(to='members.Member', blank=True)),
            ],
        ),
        migrations.CreateModel(
            name='MemberRenewalInvoice',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('paid', models.BooleanField(default=False)),
                ('organisation_name', models.CharField(max_length=200)),
                ('address_1', models.CharField(max_length=200)),
                ('address_2', models.CharField(max_length=200, null=True, blank=True)),
                ('address_3', models.CharField(max_length=200, null=True, blank=True)),
                ('town', models.CharField(max_length=200)),
                ('postcode', models.CharField(max_length=20)),
                ('po_number', models.CharField(max_length=100, verbose_name=b'Purchase Order Number / Contact Name')),
                ('email_address', models.CharField(max_length=100)),
                ('telephone', models.CharField(max_length=20)),
                ('country', models.ForeignKey(related_name='renewal_invoice_country', to='members.Country')),
                ('member', models.ForeignKey(to='members.Member')),
            ],
        ),
        migrations.CreateModel(
            name='MemberResource',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('member', models.ForeignKey(to='members.Member')),
            ],
        ),
        migrations.CreateModel(
            name='MemberSubscription',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('subscription', models.CharField(max_length=200)),
                ('amount', models.FloatField(verbose_name=b'Amount(GBP)')),
                ('discount', models.FloatField(default=0, verbose_name=b'Discount(GBP)')),
                ('total', models.FloatField(verbose_name=b'Total(GBP)')),
                ('invoice_to', models.CharField(max_length=200)),
                ('status', models.CharField(max_length=20, choices=[('archived', 'Archived'), ('pending', 'Pending'), ('current', 'Current')])),
                ('start_date', models.DateField()),
                ('expiry_date', models.DateField()),
                ('invoice_created', models.DateField(default=datetime.date.today, null=True, blank=True)),
                ('archived', models.BooleanField(default=False)),
                ('method', models.CharField(max_length=200, null=True, verbose_name=b'Payment Method', blank=True)),
                ('renew_membership', models.BooleanField(default=False, verbose_name=b'Renew the members membership when saved - will create Receipt and Email')),
                ('member', models.ForeignKey(to='members.Member')),
            ],
        ),
        migrations.CreateModel(
            name='MemberTransaction',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('transaction_date', models.DateField(null=True, blank=True)),
                ('invoice_no', models.CharField(max_length=20, null=True, blank=True)),
                ('item', models.IntegerField()),
                ('transaction_type', models.CharField(max_length=20)),
                ('batch', models.IntegerField()),
                ('amount', models.FloatField()),
                ('vat', models.FloatField()),
                ('balance', models.FloatField()),
                ('paid', models.FloatField()),
                ('payment_method', models.CharField(max_length=100, null=True, blank=True)),
                ('printed', models.CharField(max_length=100, null=True, blank=True)),
                ('credit_note_id', models.CharField(max_length=100, null=True, blank=True)),
                ('member', models.ForeignKey(to='members.Member')),
            ],
        ),
        migrations.CreateModel(
            name='MemberType',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('order', models.IntegerField(default=0)),
                ('description', models.TextField()),
                ('apply_online', models.BooleanField(default=False)),
                ('direct_debit_only', models.BooleanField(default=False)),
                ('subscription_length', models.CharField(default=b'12-months', max_length=10, choices=[('3-months', b'3 Months'), ('6-months', b'6 Months'), ('12-months', b'12 Months'), ('untimed', b'Untimed')])),
                ('new_fee', models.FloatField(verbose_name=b'Membership fee for New Members')),
                ('renewal_fee', models.FloatField(verbose_name=b'Renewal fee')),
                ('dd_discount', models.FloatField(verbose_name=b'Discount when renewing via Direct Debit')),
                ('student', models.BooleanField(default=False)),
            ],
            options={
                'ordering': ['order'],
            },
        ),
        migrations.CreateModel(
            name='OtherSociety',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Receipt',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('type', models.CharField(default=b'membership', max_length=20)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('file', models.FileField(null=True, upload_to=b'members/receipts', blank=True)),
                ('amount_paid', models.CharField(max_length=20)),
                ('start_date', models.DateField(null=True, blank=True)),
                ('payment_type', models.CharField(max_length=20)),
                ('unique_key', models.CharField(max_length=20, null=True, blank=True)),
                ('member', models.ForeignKey(to='members.Member')),
            ],
        ),
        migrations.CreateModel(
            name='UserActivity',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('read', models.BooleanField(default=False)),
                ('title', models.CharField(max_length=200)),
                ('text', models.TextField()),
                ('type', models.CharField(default=b'general', max_length=100, choices=[('general', 'General Notification'), ('meeting-notification', 'Meeting Notification'), ('voting-notification', 'Voting Notification'), ('member-notification', 'Member Notification'), ('account-notification', 'Account Notification'), ('certificate-notification', 'Certificate Notifications'), ('receipt-notification', 'Receipt Notifications')])),
                ('member', models.ForeignKey(to='members.Member')),
            ],
        ),
        migrations.AddField(
            model_name='membersubscription',
            name='member_type',
            field=models.ForeignKey(blank=True, to='members.MemberType', null=True),
        ),
        migrations.AddField(
            model_name='member',
            name='member_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.SET_NULL, verbose_name=b'Type of Membership Required', blank=True, to='members.MemberType', null=True),
        ),
        migrations.AddField(
            model_name='member',
            name='other_societies',
            field=models.ManyToManyField(to='members.OtherSociety', blank=True),
        ),
        migrations.AddField(
            model_name='member',
            name='user',
            field=models.ForeignKey(to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='furtherinformationmessage',
            name='member',
            field=models.ForeignKey(to='members.Member'),
        ),
        migrations.AddField(
            model_name='certificate',
            name='member',
            field=models.ForeignKey(to='members.Member'),
        ),
    ]
