# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
import modules.core.encryption


class Migration(migrations.Migration):

    dependencies = [
        ('resources', '0001_initial'),
        ('meeting_booking', '0003_auto_20150904_1111'),
        ('members', '0004_auto_20150904_1104'),
    ]

    operations = [
        migrations.AddField(
            model_name='memberresource',
            name='resource',
            field=models.ForeignKey(blank=True, to='resources.Resource'),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='receipt',
            name='meeting_booking',
            field=models.ForeignKey(blank=True, to='meeting_booking.MeetingBooking', null=True),
        ),
        migrations.AlterField(
            model_name='member',
            name='address_1',
            field=modules.core.encryption.EncryptedCharField(max_length=1765, null=True, blank=True),
        ),
        migrations.AlterField(
            model_name='member',
            name='postcode',
            field=modules.core.encryption.EncryptedCharField(max_length=357, null=True, blank=True),
        ),
        migrations.AlterField(
            model_name='memberdirectdebit',
            name='ac_no',
            field=modules.core.encryption.EncryptedCharField(max_length=357, verbose_name=b'Account Number'),
        ),
        migrations.AlterField(
            model_name='memberdirectdebit',
            name='old_ac_no',
            field=modules.core.encryption.EncryptedCharField(max_length=357, null=True, verbose_name=b'Old Account Number', blank=True),
        ),
        migrations.AlterField(
            model_name='memberdirectdebit',
            name='old_sort_code',
            field=modules.core.encryption.EncryptedCharField(max_length=357, null=True, verbose_name=b'Old Sort Code', blank=True),
        ),
        migrations.AlterField(
            model_name='memberdirectdebit',
            name='sort_code',
            field=modules.core.encryption.EncryptedCharField(max_length=357, verbose_name=b'Sort Code'),
        ),
    ]
