#Django core bits
from django.shortcuts import render_to_response,get_object_or_404
from django.template.loader import render_to_string
from django.template import RequestContext
from django.contrib.auth.decorators import login_required, permission_required
from django.contrib.sites.models import Site
from django.conf import settings
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.contrib import messages

from datetime import datetime,date,time
from dateutil.relativedelta import relativedelta

import pdfcrowd,random,csv,string

#Forms
from modules.members.adminforms import *

#Models
from modules.members.models import *
from modules.payments.models import *

from modules.core.functions import *
from modules.members.signals import *

def download_members(members,writer):

    writer.writerow(['Membership Number','Title','Given Name','Surname','Email Address','Member Type''Registered','Qualifications','Gender','Address 1','Address 2','Town','County','Country','Postcode','Telephone','Personal Email','Job Title','Hospital','Hospital Department','Hospital Address 1','Hospital Address 2','Hospital Town','Hospital County','Hospital Country','Hospital Postcode','Hospital Telephone','Hospital Email Address','Preferred Mailing Address'])

    for member in members:

        writer.writerow([unicode(s).encode("utf-8") for s in (member.membership_number,member.title,member.given_name,member.surname,member.user.email,member.member_type,member.user.date_joined,member.qualifications,member.get_gender_display(),member.address_1,member.address_2,member.town,member.county,member.country,member.postcode,member.telephone,member.personal_email,member.job_title,member.hospital,member.hospital_department,member.hospital_address_1,member.hospital_address_2,member.hospital_town,member.hospital_county,member.hospital_country,member.hospital_postcode,member.hospital_phone,member.hospital_email,member.get_preferred_mailing_address_display())])

    return writer

@permission_required('admin_users.can_access_members')
def members_pending(request):

    pending_members = Member.objects.filter(user_type='member',complete=True,approved=False).order_by('-user__date_joined')

    return render(request,'admin/members/approval/pending_members.html',{'pending_members':pending_members})


@permission_required('admin_users.can_access_members')
def members_pending_mark_paid(request,member_id):

    member = get_object_or_404(Member,id=member_id,complete=True,paid=False)
    today = date.today()

    total = member.get_registration_fee()
    if member.donation_amount:
        amount_paid = total + member.donation_amount
    else:
        amount_paid = total

    receipt_name = '%s Membership Subscription (%s)' % (settings.WEBSITE_NAME,today.strftime('%B %Y'))
    receipt = Receipt(member=member,name=receipt_name,start_date=today,amount_paid=amount_paid,payment_type=member.payment_type)
    receipt.unique_key = random_string_unique(20,Receipt,'unique_key')
    receipt.save()

    try:
        client = pdfcrowd.Client("calmdigital", "dc33e7c4525620565185d0a00d90b8f0")
        client.setPageMargins('50','50','0','50')
        output_file = open(os.path.join(settings.MEDIA_ROOT, 'members/receipts/membership_payment_%s.pdf' % (receipt.id)), 'wb')
        html = render_to_string('members/receipts/view-receipt-pdf.html',{'receipt':receipt},context_instance=RequestContext(request))
        client.convertHtml(html,output_file)
        output_file.close()
    except:
        pass
    receipt.file = 'members/receipts/membership_payment_%s.pdf' % (receipt.id)
    receipt.save()

    messages.success(request,'Member Marked as Paid')

    member_invoice_paid.send(sender=None,request=request,member=member,receipt=receipt)

    member.paid = True
    member.save()

    return HttpResponseRedirect(reverse('admin_members_pending'))

@permission_required('admin_users.can_access_members')
def members_pending_download(request):

    pending_members = Member.objects.filter(user_type='member',complete=True,approved=False)

    response = HttpResponse(content_type='text/csv')
    response['Content-Disposition'] = "attachment; filename=members-awaiting-admin-approval.csv"

    writer = csv.writer(response)
    writer = download_members(pending_members,writer)

    return response

@permission_required('admin_users.can_access_members')
def members_pending_approve(request,member_id):

    member = get_object_or_404(Member,id=member_id,complete=True,approved=False)

    #try:
    member.approved = True
    member.save()

    total = member.get_registration_fee()
    today = date.today()
    start_date = today
    member_type = member.member_type

    if member_type.subscription_length == '3-months':
        end_date = start_date+relativedelta(months=+3,days=-1)
    elif member_type.subscription_length == '6-months':
        end_date = start_date+relativedelta(months=+6,days=-1)
    else:
        end_date = start_date+relativedelta(months=+12,days=-1)

    member.expiry_date = end_date
    member.save()

    subscription_name = '%s Membership Subscription (%s)' % (member_type.name,start_date.strftime('%B %Y'))
    invoice_to_name = '%s %s %s' % (member.get_title_display(),member.given_name,member.surname)

    member_subscription = MemberSubscription(
        member=member,
        member_type = member.member_type,
        subscription= subscription_name,
        amount= total,
        discount=0,
        total= total,
        invoice_to=invoice_to_name,
        status='current',
        start_date=today,
        expiry_date=member.expiry_date,
        invoice_created=today)

    member_subscription.save()

    #create certificate pdf
    certificate = Certificate(member=member,start_date=member_subscription.start_date,end_date=member_subscription.expiry_date)
    certificate.save()

    try:
        client = pdfcrowd.Client("calmdigital", "dc33e7c4525620565185d0a00d90b8f0")
        client.setPageMargins('50','50','0','50')
        output_file = open(os.path.join(settings.MEDIA_ROOT, 'members/certificates/membership_certificate_%s.pdf' % (certificate.id)), 'wb')
        html = render_to_string('members/certificates/view-cert-pdf.html',{'certificate':certificate},context_instance=RequestContext(request))
        client.convertHtml(html,output_file)
        output_file.close()
    except:
        pass

    certificate.file = 'members/certificates/membership_certificate_%s.pdf' % (certificate.id)
    certificate.save()

    member_admin_approved.send(sender=None,request=request,member=member,certificate=certificate)

    messages.success(request,'Member has been approved')

    #except:
    #    member.approved = False
    #    member.save()
    #    messages.error(request,'Could not approve member')

    return HttpResponseRedirect(reverse('admin_members_pending'))
