from django.forms import ModelForm
from django import forms
from models import *

from django.db.models import Q
        
class PageForm(ModelForm):
	class Meta:
		model = Page
		exclude = ('url','full_url')
		
class PageEditForm(ModelForm):
    
    def __init__(self, *args, **kwargs):
        super(PageEditForm, self).__init__(*args, **kwargs)
        pages = Page.objects.all().exclude(id=self.instance.pk)
        self.fields['parent'].queryset = pages

    class Meta:
        model = Page
        exclude = ('full_url',)

class PageSectionForm(ModelForm):
	class Meta:
		model = PageSection
		exclude = ('page',)
		
class PageBlockForm(ModelForm):
    
    class Meta:
        model = PageBlock
        exclude = ('page',)
    
class PageResourceForm(ModelForm):
    class Meta:
        model = PageResource
        exclude = ('page',)
        
class PageSectionResourceForm(ModelForm):
    class Meta:
        model = PageSectionResource
        exclude = ('section',)

