# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
import django.db.models.deletion
import modules.file_manager.fields


class Migration(migrations.Migration):

    dependencies = [
        ('file_manager', '0001_initial'),
        ('resources', '0001_initial'),
        ('blocks', '0001_initial'),
        ('auth', '0006_require_contenttypes_0002'),
        ('members', '0003_auto_20150904_1057'),
    ]

    operations = [
        migrations.CreateModel(
            name='Page',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=150)),
                ('url', models.SlugField(max_length=150, unique=True, null=True, blank=True)),
                ('redirect_to', models.CharField(max_length=200, null=True, blank=True)),
                ('order', models.IntegerField(null=True, blank=True)),
                ('intro_page', models.BooleanField(default=False, verbose_name=b'Is an Intro Page')),
                ('introduction', models.TextField(blank=True)),
                ('keywords', models.TextField(help_text=b'These are used for search, please enter comma separated.', blank=True)),
                ('introduction_image', models.ImageField(null=True, upload_to=b'pages', blank=True)),
                ('content', models.TextField(blank=True)),
                ('groups_allowed', models.ManyToManyField(to='auth.Group', verbose_name=b'Groups Allowed to Edit', blank=True)),
                ('limit_to_member_groups', models.ManyToManyField(to='members.MemberGroup', blank=True)),
                ('limit_to_member_types', models.ManyToManyField(to='members.MemberType', blank=True)),
                ('parent', models.ForeignKey(blank=True, to='pages.Page', null=True)),
                ('search_terms', models.ManyToManyField(to='blocks.HomepageSearch', blank=True)),
            ],
            options={
                'ordering': ['title'],
            },
        ),
        migrations.CreateModel(
            name='PageBlock',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=200)),
                ('content', models.TextField()),
                ('link', models.CharField(max_length=200)),
                ('order', models.IntegerField()),
                ('image', modules.file_manager.fields.ImageUploadField(on_delete=django.db.models.deletion.SET_NULL, blank=True, to='file_manager.Image', null=True)),
                ('page', models.ForeignKey(to='pages.Page')),
            ],
        ),
        migrations.CreateModel(
            name='PageResource',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=150)),
                ('order', models.IntegerField()),
                ('page', models.ForeignKey(to='pages.Page')),
                ('resource', models.ForeignKey(to='resources.Resource')),
            ],
        ),
        migrations.CreateModel(
            name='PageSection',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=150)),
                ('order', models.IntegerField()),
                ('content', models.TextField(blank=True)),
                ('is_title', models.BooleanField(default=False)),
                ('page', models.ForeignKey(to='pages.Page')),
            ],
        ),
        migrations.CreateModel(
            name='PageSectionResource',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=150)),
                ('order', models.IntegerField()),
                ('resource', models.ForeignKey(to='resources.Resource')),
                ('section', models.ForeignKey(to='pages.PageSection')),
            ],
        ),
    ]
