#Django core bits
from django.shortcuts import render_to_response, get_object_or_404
from django.template import RequestContext, loader, Context
from django.contrib.auth.decorators import login_required, permission_required
from django.db.models import Q
from django.contrib.sites.models import Site
from django.conf import settings
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.contrib import messages
from django.template.defaultfilters import slugify

from datetime import datetime, date, time, timedelta

#Models
from models import *
from modules.members.models import *

from modules.core.functions import *
from modules.core.forms import *

#Others
import random,csv

def page(request,address):

    if address[-1] != '/':
        redirect_url = """/%s/""" % (address)
        return HttpResponseRedirect(redirect_url)

    parts = address.split('/')
    last_part = parts[-2]

    try:
        page = Page.objects.get(url=last_part)
    except Page.DoesNotExist:
        raise Http404

    if page.redirect_to:
        return HttpResponseRedirect(page.redirect_to)

    if address != page.get_full_url():
        raise Http404

    access = page.get_permission(request)

    if access == 'denied':
        login_form = LoginForm()
        return render_to_response('public/login/access-denied.html',{'login_form':login_form},context_instance=RequestContext(request))

    if access == 'permission-denied':
        return render_to_response('public/login/permission-denied.html',{},context_instance=RequestContext(request))

    redirect_url = "/%s" % page.get_full_url()

    sections = PageSection.objects.filter(page=page).order_by('order')

    today = date.today()

    if request.user.is_authenticated():
        try:
            member = Member.objects.get(user=request.user)
            if member.expiry_date:
                if today >= member.expiry_date:
                    page_resources = PageResource.objects.filter(page=page,resource__limit_to_member_types__isnull=True).order_by('order')
                else:
                    page_resources = PageResource.objects.filter(Q(resource__limit_to_member_types__isnull=True) | Q(resource__limit_to_member_types=member.member_type),page=page).order_by('order')
            else:
                page_resources = PageResource.objects.filter(Q(resource__limit_to_member_types__isnull=True) | Q(resource__limit_to_member_types=member.member_type),page=page).order_by('order')
        except:
            if request.user.is_superuser:
                page_resources = PageResource.objects.filter(page=page).order_by('order')
            else:
                page_resources = PageResource.objects.filter(page=page,resource__limit_to_member_types__isnull=True).order_by('order')
    else:
        page_resources = PageResource.objects.filter(page=page,resource__limit_to_member_types__isnull=True).order_by('order')

    final_resources = []

    for resource in page_resources:
 
        if resource.resource.limit_to_member_groups.all():
            if request.user.is_authenticated():
                try:
                    member = Member.objects.get(user=request.user)

                    in_groups = False
                    for group in resource.resource.limit_to_member_groups.all():
                        if member in group.members.all():
                            in_groups = True

                    if in_groups:
                        final_resources.append(resource)

                except:
                    if request.user.is_superuser:
                        final_resources.append(resource)
        else:
            final_resources.append(resource)

    top_level_page = page.get_top_level()

    return render_to_response('public/pages/page.html',{'page':page,'sections':sections,'resources':final_resources,'today':today,'top_level_page':top_level_page}, context_instance=RequestContext(request))
