#Django core bits
from django.shortcuts import render, redirect, get_object_or_404
from django.contrib.auth.decorators import login_required, permission_required
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.contrib import messages
from django.template.defaultfilters import slugify
import csv

from modules.core.functions import *

#Forms
from forms import *

#Models
from models import *

@permission_required('admin_users.can_access_pump_priming')
def pp_forms(request):

    enabled_pp_forms = PPForm.objects.filter(enabled=True)
    disabled_pp_forms = PPForm.objects.filter(enabled=False)

    return render(request, 'admin/pump_priming/pp-forms.html', {'enabled_pp_forms':enabled_pp_forms, 'disabled_pp_forms':disabled_pp_forms})


@permission_required('admin_users.can_access_pump_priming')
def add_ppform(request):

    pp_form_form = PPFormForm()

    if request.POST:

        pp_form_form = PPFormForm(request.POST)
        if pp_form_form.is_valid():
            pp_form = pp_form_form.save(commit=False)
            pp_form.slug = slugify_unique(pp_form.name, PPForm, 'slug')
            pp_form.save()

            messages.success(request, 'Pump Priming Form Created')

            return redirect(reverse('admin_pump_priming'))

    return render(request, 'admin/pump_priming/add-pp-form.html', {'form':pp_form_form})

@permission_required('admin_users.can_access_pump_priming')
def edit_ppform(request, form_id):

    pp_form = get_object_or_404(PPForm, id=form_id)
    pp_form_form = PPFormForm(instance=pp_form)

    if request.POST:

        pp_form_form = PPFormForm(request.POST, instance=pp_form)
        if pp_form_form.is_valid():
            pp_form_form.save()

            messages.success(request, 'Pump Priming Form Updated')

            return redirect(reverse('admin_pump_priming'))

    return render(request, 'admin/pump_priming/add-pp-form.html', {'pp_form':pp_form, 'form':pp_form_form})


@permission_required('admin_users.can_access_pump_priming')
def delete_ppform(request, form_id):

    pp_form = get_object_or_404(PPForm, id=form_id)
    pp_form.delete()

    messages.success(request, 'PP Form Deleted')

    return redirect(reverse('admin_pump_priming'))


@permission_required('admin_users.can_access_pump_priming')
def applications(request, form_id):

    pp_form = get_object_or_404(PPForm, id=form_id)
    applications = PPApplication.objects.filter(form=pp_form)

    return render(request, 'admin/pump_priming/applications.html', {'pp_form':pp_form, 'applications':applications})


@permission_required('admin_users.can_access_travel_grants')
def download_applications(request, form_id):

    pp_form = get_object_or_404(PPForm, id=form_id)
    applications = PPApplication.objects.filter(form=pp_form)

    fields = ['Title', 'Forename', 'Surname', 'Email', 'Telephone', 'Institution', 'Address', 'Adminitering Institution', 'Address', 'Title of Study', 'Abstract', 'Erhical Approval', 'Institutional Approval Info', 'Declaration', 'HOD Title', 'HOD Forename', 'HOD Surname', 'HOD Email', 'HOD Telephone', 'HOD Institution', 'HOD Address']
    
    response = HttpResponse(content_type='text/csv')
    response['Content-Disposition'] = "attachment; filename=pump_priming_applicants.csv"

    writer = csv.writer(response)
    writer.writerow(fields)

    for application in applications:

        fields = [application.title, application.forename, application.surname, application.email, application.telephone, application.institution, application.address, application.adm_institution, application.adm_institution_address, application.title_of_study, application.abstract, application.ethical_approval, application.institutional_approval_information, application.confirm_declaration, application.hod_title, application.hod_forename, application.hod_surname, application.hod_email, application.hod_telephone, application.hod_institution, application.hod_address]
        applicants = application.get_applicants()
        if applicants:
            fields += ['Applicants']
            for applicant in applicants:
                fields += [applicant.title, applicant.forename, applicant.surname, applicant.age, applicant.post_held]
        timetable =  application.get_timetable()
        if timetable:
            fields += ['Timetable']
            for timetable in timetable:
                fields += [timetable.name, timetable.date]
        funding = application.get_funding()
        if funding:
            fields += ['Funding']
            for funding in funding:
                fields += [funding.name, funding.amount]

        writer.writerow(fields)
    
    return response


@permission_required('admin_users.can_access_pump_priming')
def view_application(request, form_id, application_id):

    pp_form = get_object_or_404(PPForm, id=form_id)
    application = get_object_or_404(PPApplication, id=application_id)

    return render(request, 'admin/pump_priming/view-application.html', {'pp_form':pp_form, 'application':application})


@permission_required('admin_users.can_access_pump_priming')
def delete_application(request, form_id, application_id):

    pp_form = get_object_or_404(PPForm, id=form_id)
    application = get_object_or_404(PPApplication, id=application_id)

    application.delete()

    messages.success(request, 'Application has been deleted')

    return redirect(reverse('admin_pp_applications', args=[pp_form.id]))