# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='TGApplication',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('title', models.CharField(max_length=10)),
                ('forename', models.CharField(max_length=200)),
                ('surname', models.CharField(max_length=200)),
                ('email', models.EmailField(max_length=254)),
                ('telephone', models.CharField(max_length=20)),
                ('institution', models.CharField(max_length=200)),
                ('address', models.TextField()),
                ('abstract', models.TextField(help_text=b'Approx 2000 Words', verbose_name=b'Abstract and methodological description of the study')),
                ('objective', models.TextField()),
                ('confirm_declaration', models.BooleanField(default=False, verbose_name=b'I agree to abide by the terms of the grant funding and the decision of the PSGB&I committee')),
            ],
            options={
                'ordering': ['-created'],
            },
        ),
        migrations.CreateModel(
            name='TGContributor',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('order', models.IntegerField()),
                ('title', models.CharField(max_length=10)),
                ('forename', models.CharField(max_length=200)),
                ('surname', models.CharField(max_length=200)),
                ('age', models.CharField(max_length=10)),
                ('post_held', models.CharField(max_length=200)),
                ('application', models.ForeignKey(to='travel_grants.TGContributor')),
            ],
        ),
        migrations.CreateModel(
            name='TGForm',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=100)),
                ('slug', models.SlugField(max_length=102)),
                ('description', models.TextField(blank=True)),
                ('enabled', models.BooleanField(default=False)),
                ('completed_message', models.TextField(blank=True)),
            ],
        ),
        migrations.AddField(
            model_name='tgapplication',
            name='form',
            field=models.ForeignKey(to='travel_grants.TGForm'),
        ),
    ]
