#Django core bits
from django.shortcuts import render, redirect, get_object_or_404
from django.contrib.auth.decorators import login_required, permission_required
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.contrib import messages
from django.template.defaultfilters import slugify
import csv

from django.forms.formsets import formset_factory
from django.forms import modelformset_factory

from modules.core.functions import *

#Forms
from forms import TGApplicationForm, TGContributorForm

from emails import travel_grant_complete_email

#Models
from models import TGForm, TGContributor

from modules.core.decorators import members_only


@members_only
def tg_form(request, form_slug):

    tg_form = get_object_or_404(TGForm, slug=form_slug)
    tg_application_form = TGApplicationForm()

    ContributorFormset = modelformset_factory(TGContributor, form=TGContributorForm, extra=1)
    contributor_formset = ContributorFormset(queryset=TGContributor.objects.none(), prefix='contributor')

    if request.POST:
        tg_application_form = TGApplicationForm(request.POST)
        contributor_formset = ContributorFormset(request.POST, queryset=TGContributor.objects.none(), prefix='contributor')

        if tg_application_form.is_valid() and contributor_formset.is_valid():
            
            tg_application = tg_application_form.save(commit=False)
            tg_application.form = tg_form
            tg_application.save()

            order = 1
            for contributor_form in contributor_formset:
                contributor = contributor_form.save(commit=False)
                contributor.order = order
                contributor.application = tg_application
                contributor.save()
                order += 1

            travel_grant_complete_email(request, tg_application)

            return redirect('travel_grant_complete', tg_form.slug)
        else:
            messages.error(request, 'Sorry, could not complete the form, please ensure you have entered all fields correctly and try again.')

    return render(request, 'public/travel_grants/form.html', {'tg_form': tg_form, 'tg_application_form': tg_application_form, 'contributor_formset': contributor_formset})


@members_only
def tg_complete(request, form_slug):

    tg_form = get_object_or_404(TGForm, slug=form_slug)

    return render(request, 'public/travel_grants/complete.html', {'tg_form':tg_form})
