#Django core bits
from django.shortcuts import render, redirect, get_object_or_404
from django.contrib.auth.decorators import login_required, permission_required
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.contrib import messages
from django.template.defaultfilters import slugify
import csv

from modules.core.functions import *

#Forms
from forms import *

#Models
from models import *

@permission_required('admin_users.can_access_videos')
def video_forms(request):

    enabled_video_forms = VideoForm.objects.filter(enabled=True)
    disabled_video_forms = VideoForm.objects.filter(enabled=False)

    return render(request, 'admin/videos/video-forms.html', {
        'enabled_video_forms': enabled_video_forms, 'disabled_video_forms': disabled_video_forms
    })


@permission_required('admin_users.can_access_videos')
def add_videoform(request):

    video_form_form = VideoFormForm()

    if request.POST:

        video_form_form = VideoFormForm(request.POST)
        if video_form_form.is_valid():
            video_form = video_form_form.save(commit=False)
            video_form.slug = slugify_unique(video_form.name, VideoForm, 'slug')
            video_form.save()

            messages.success(request, 'Video Form Created')

            return redirect(reverse('admin_videos'))

    return render(request, 'admin/videos/add-video-form.html', {'form':video_form_form})

@permission_required('admin_users.can_access_videos')
def edit_videoform(request, form_id):

    video_form = get_object_or_404(VideoForm, id=form_id)
    video_form_form = VideoFormForm(instance=video_form)

    if request.POST:

        video_form_form = VideoFormForm(request.POST, instance=video_form)
        if video_form_form.is_valid():
            video_form_form.save()

            messages.success(request, 'Video Form Updated')

            return redirect(reverse('admin_videos'))

    return render(request, 'admin/videos/add-video-form.html', {'video_form':video_form, 'form':video_form_form})


@permission_required('admin_users.can_access_videos')
def delete_videoform(request, form_id):

    video_form = get_object_or_404(VideoForm, id=form_id)
    video_form.delete()

    messages.success(request, 'Video Form Deleted')

    return redirect(reverse('admin_videos'))


@permission_required('admin_users.can_access_videos')
def applications(request, form_id):

    video_form = get_object_or_404(VideoForm, id=form_id)
    applications = VideoApplication.objects.filter(form=video_form)

    return render(request, 'admin/videos/applications.html', {'video_form':video_form, 'applications':applications})


@permission_required('admin_users.can_access_videos')
def download_applications(request, form_id):

    video_form = get_object_or_404(VideoForm, id=form_id)
    applications = VideoApplication.objects.filter(form=video_form)

    fields = ['Title', 'Forename', 'Surname', 'Email', 'Organisation', 'UUID Key']
    
    response = HttpResponse(content_type='text/csv')
    response['Content-Disposition'] = "attachment; filename=pump_priming_applicants.csv"

    writer = csv.writer(response)
    writer.writerow(fields)

    for application in applications:
        fields = [application.title, application.forename, application.surname, application.email, application.organisation, application.uuid_key]
        writer.writerow(fields)

    return response


@permission_required('admin_users.can_access_videos')
def view_application(request, form_id, application_id):

    video_form = get_object_or_404(VideoForm, id=form_id)
    application = get_object_or_404(VideoApplication, id=application_id)

    return render(request, 'admin/videos/view-application.html', {'video_form':video_form, 'application':application})


@permission_required('admin_users.can_access_videos')
def delete_application(request, form_id, application_id):

    video_form = get_object_or_404(VideoForm, id=form_id)
    application = get_object_or_404(VideoApplication, id=application_id)

    application.delete()

    messages.success(request, 'Application has been deleted')

    return redirect(reverse('admin_video_applications', args=[video_form.id]))