from models import *

from django.forms import ModelForm
from snowpenguin.django.recaptcha2.fields import ReCaptchaField
from snowpenguin.django.recaptcha2.widgets import ReCaptchaWidget

class VideoFormForm(ModelForm):

    class Meta:
        model = VideoForm
        fields = ('name', 'description', 'video', 'completed_message', 'hidden_message', 'enabled')


class VideoApplicationForm(ModelForm):

    recaptcha = ReCaptchaField(widget=ReCaptchaWidget)
    class Meta:
        model = VideoApplication
        fields = ('title', 'forename', 'surname', 'email', 'organisation', 'recaptcha')
