from django.db import models

# Create your models here.
class VideoForm(models.Model):

    name = models.CharField(max_length=100)
    slug = models.SlugField(max_length=102)
    description = models.TextField(blank=True)
    video = models.TextField(verbose_name='Video Embed Code')
    completed_message = models.TextField(blank=True)
    hidden_message = models.TextField(blank=True, help_text='Content that appears once the unique link is followed.')
    
    enabled = models.BooleanField(default=False)

    def __unicode__(self):
        return self.name

    def get_applications(self):
        return VideoApplication.objects.filter(form=self)


class VideoApplication(models.Model):

    form = models.ForeignKey('VideoForm')
    created = models.DateTimeField(auto_now_add=True)

    title = models.CharField(max_length=10)
    forename = models.CharField(max_length=200)
    surname = models.CharField(max_length=200)
    email = models.EmailField()
    organisation = models.CharField(max_length=200)
    uuid_key = models.CharField(max_length=200, unique=True, null=True, default=None)

    class Meta:
        ordering = ['-created']

    def __unicode__(self):
        return "%s %s" % (self.forename, self.surname)