#Django core bits
from django.shortcuts import render, redirect, get_object_or_404
from django.contrib.auth.decorators import login_required, permission_required
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.contrib import messages
from django.template.defaultfilters import slugify
import csv, uuid, base64

from modules.notifications.models import EmailTemplate, send_mail

from django.forms.formsets import formset_factory
from django.forms import modelformset_factory

from modules.core.functions import *

#Forms
from forms import *

#Models
from models import *

from modules.core.decorators import members_only

# get a UUID - URL safe, Base64
def get_a_uuid(model):
    r_uuid = base64.urlsafe_b64encode(uuid.uuid4().bytes)
    r_uuid = r_uuid.replace('=', '')
    r_uuid = r_uuid.replace('-', '')
    try:
        existing = model.objects.get(uuid_key=r_uuid)
        if existing:
            return get_unique_uuid(model)
    except Exception:
        return r_uuid

def video_form(request, form_slug):

    video_form = get_object_or_404(VideoForm, slug=form_slug)
    video_application_form = VideoApplicationForm()

    if request.POST:
        video_application_form = VideoApplicationForm(request.POST)

        if video_application_form.is_valid():
            video_application = video_application_form.save(commit=False)
            video_application.form = video_form
            video_application.uuid_key = get_a_uuid(VideoForm)
            video_application.save()

            # email member
            url = 'https://' + request.META['HTTP_HOST'] + reverse(video_complete_hidden, args=[form_slug, video_application.uuid_key])
            template = EmailTemplate.objects.get(key="videos_completed")
            message = template.content % (
                video_form,
                url, url
            )
            send_mail(template.key, template.subject, message, template.from_address.email_address, video_application.email)

            # admin
            admin_url = 'https://' + request.META['HTTP_HOST'] + reverse('admin_view_video_application', args=[video_form.id, video_application.id])
            admin_template = EmailTemplate.objects.get(key="videos_completed_admin")
            message = admin_template.content % (
                video_form, video_application.title, video_application.forename,
                video_application.surname, video_application.email, 
                video_application.organisation,
                admin_url, admin_url
            )
            send_mail(admin_template.key, admin_template.subject, message, admin_template.from_address.email_address, admin_template.get_to_addresses())

            return redirect('video_complete', video_form.slug)
        else:
            messages.error(request, 'Sorry, could not complete the form, please ensure you have entered all fields correctly and try again.')

    return render(request, 'public/videos/form.html', {
        'video_form': video_form,
        'video_application_form': video_application_form,
    })


def video_complete(request, form_slug):

    video_form = get_object_or_404(VideoForm, slug=form_slug)
    return render(request, 'public/videos/complete.html', {'video_form':video_form})

def video_complete_hidden(request, form_slug, uuid_key):

    video_form = get_object_or_404(VideoForm, slug=form_slug)
    application = get_object_or_404(VideoApplication, uuid_key=uuid_key)

    return render(request, 'public/videos/complete_hidden.html', {
        'video_form': video_form, 'application': application,
    })

